/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.htree;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.mk.htree.HashDirectory;
import org.apache.jackrabbit.mk.model.ChildNodeEntries;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.store.Binding;
import org.apache.jackrabbit.mk.store.PersistHook;
import org.apache.jackrabbit.mk.store.RevisionProvider;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.mk.util.AbstractFilteringIterator;
import org.apache.jackrabbit.mk.util.AbstractRangeIterator;

public class ChildNodeEntriesHTree
implements ChildNodeEntries,
PersistHook {
    private HashDirectory top;

    public ChildNodeEntriesHTree(RevisionProvider provider) {
        this.top = new HashDirectory(provider, 0);
    }

    @Override
    public Object clone() {
        ChildNodeEntriesHTree clone = null;
        try {
            clone = (ChildNodeEntriesHTree)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.top = (HashDirectory)this.top.clone();
        return clone;
    }

    @Override
    public boolean inlined() {
        return false;
    }

    @Override
    public int getCount() {
        return this.top.getCount();
    }

    @Override
    public ChildNodeEntry get(String name) {
        return this.top.get(name);
    }

    @Override
    public Iterator<String> getNames(int offset, int count) {
        if (offset < 0 || count < -1) {
            throw new IllegalArgumentException();
        }
        if (offset >= this.getCount() || count == 0) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        if (count == -1 || offset + count > this.getCount()) {
            count = this.getCount() - offset;
        }
        return new AbstractRangeIterator<String>(this.getEntries(offset, count), 0, -1){

            @Override
            protected String doNext() {
                ChildNodeEntry cne = (ChildNodeEntry)this.it.next();
                return cne.getName();
            }
        };
    }

    @Override
    public Iterator<ChildNodeEntry> getEntries(int offset, int count) {
        return this.top.getEntries(offset, count);
    }

    @Override
    public ChildNodeEntry add(ChildNodeEntry entry) {
        return this.top.add(entry);
    }

    @Override
    public ChildNodeEntry remove(String name) {
        return this.top.remove(name);
    }

    @Override
    public ChildNodeEntry rename(String oldName, String newName) {
        if (oldName.equals(newName)) {
            return this.get(oldName);
        }
        ChildNodeEntry old = this.remove(oldName);
        if (old == null) {
            return null;
        }
        this.add(new ChildNodeEntry(newName, old.getId()));
        return old;
    }

    @Override
    public Iterator<ChildNodeEntry> getAdded(ChildNodeEntries other) {
        if (other instanceof ChildNodeEntriesHTree) {
            return this.top.getAdded(((ChildNodeEntriesHTree)other).top);
        }
        return new AbstractFilteringIterator<ChildNodeEntry>(other.getEntries(0, -1)){

            @Override
            protected boolean include(ChildNodeEntry entry) {
                return ChildNodeEntriesHTree.this.get(entry.getName()) == null;
            }
        };
    }

    @Override
    public Iterator<ChildNodeEntry> getRemoved(ChildNodeEntries other) {
        return other.getAdded(this);
    }

    @Override
    public Iterator<ChildNodeEntry> getModified(final ChildNodeEntries other) {
        if (other instanceof ChildNodeEntriesHTree) {
            return this.top.getModified(((ChildNodeEntriesHTree)other).top);
        }
        return new AbstractFilteringIterator<ChildNodeEntry>(this.getEntries(0, -1)){

            @Override
            protected boolean include(ChildNodeEntry entry) {
                ChildNodeEntry namesake = other.get(entry.getName());
                return namesake != null && !namesake.getId().equals(entry.getId());
            }
        };
    }

    @Override
    public void serialize(Binding binding) throws Exception {
        this.top.serialize(binding);
    }

    public void deserialize(Binding binding) throws Exception {
        this.top.deserialize(binding);
    }

    @Override
    public void prePersist(RevisionStore store, RevisionStore.PutToken token) throws Exception {
        this.top.prePersist(store, token);
    }

    @Override
    public void postPersist(RevisionStore store, RevisionStore.PutToken token) throws Exception {
    }

    @Override
    public int getMemory() {
        return this.top.getMemory();
    }
}

