/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.store.Binding;

public abstract class AbstractCommit
implements Commit {
    protected Id rootNodeId;
    protected long commitTS;
    protected String msg;
    protected String changes;
    protected Id parentId;
    protected Id branchRootId;

    protected AbstractCommit() {
    }

    protected AbstractCommit(Commit other) {
        this.parentId = other.getParentId();
        this.rootNodeId = other.getRootNodeId();
        this.msg = other.getMsg();
        this.changes = other.getChanges();
        this.commitTS = other.getCommitTS();
        this.branchRootId = other.getBranchRootId();
    }

    @Override
    public Id getParentId() {
        return this.parentId;
    }

    @Override
    public Id getRootNodeId() {
        return this.rootNodeId;
    }

    @Override
    public long getCommitTS() {
        return this.commitTS;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    @Override
    public String getChanges() {
        return this.changes;
    }

    @Override
    public Id getBranchRootId() {
        return this.branchRootId;
    }

    @Override
    public void serialize(Binding binding) throws Exception {
        binding.write("rootNodeId", this.rootNodeId.getBytes());
        binding.write("commitTS", this.commitTS);
        binding.write("msg", this.msg == null ? "" : this.msg);
        binding.write("changes", this.changes == null ? "" : this.changes);
        binding.write("parentId", this.parentId == null ? "" : this.parentId.toString());
        binding.write("branchRootId", this.branchRootId == null ? "" : this.branchRootId.toString());
    }
}

