/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.NodeState;
import org.apache.jackrabbit.mk.model.NodeStore;
import org.apache.jackrabbit.mk.model.PropertyState;
import org.apache.jackrabbit.mk.model.TraversingNodeDiffHandler;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class DiffBuilder {
    private final NodeState before;
    private final NodeState after;
    private final String path;
    private final String pathFilter;
    private final NodeStore store;

    public DiffBuilder(NodeState before, NodeState after, String path, NodeStore store, String pathFilter) {
        this.before = before;
        this.after = after;
        this.path = path;
        this.store = store;
        this.pathFilter = pathFilter == null || "".equals(pathFilter) ? "/" : pathFilter;
    }

    public String build() throws Exception {
        final JsopBuilder buff = new JsopBuilder();
        final HashMap addedNodes = new HashMap();
        final HashMap removedNodes = new HashMap();
        if (!PathUtils.isAncestor((String)this.path, (String)this.pathFilter) && !this.path.startsWith(this.pathFilter)) {
            return "";
        }
        if (this.before == null) {
            if (this.after != null) {
                buff.tag('+').key(this.path).object();
                this.toJson(buff, this.after);
                return buff.endObject().newline().toString();
            }
            return "";
        }
        if (this.after == null) {
            buff.tag('-');
            buff.value(this.path);
            return buff.newline().toString();
        }
        TraversingNodeDiffHandler diffHandler = new TraversingNodeDiffHandler(this.store){

            @Override
            public void propertyAdded(PropertyState after) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)after.getName());
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    buff.tag('+').key(p).encodedValue(after.getEncodedValue()).newline();
                }
            }

            @Override
            public void propertyChanged(PropertyState before, PropertyState after) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)after.getName());
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    buff.tag('^').key(p).encodedValue(after.getEncodedValue()).newline();
                }
            }

            @Override
            public void propertyDeleted(PropertyState before) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)before.getName());
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    buff.tag('^').key(p).value(null).newline();
                }
            }

            @Override
            public void childNodeAdded(String name, NodeState after) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    addedNodes.put(after, p);
                    buff.tag('+').key(p).object();
                    DiffBuilder.this.toJson(buff, after);
                    buff.endObject().newline();
                }
            }

            @Override
            public void childNodeDeleted(String name, NodeState before) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    removedNodes.put(before, p);
                    buff.tag('-');
                    buff.value(p);
                    buff.newline();
                }
            }

            @Override
            public void childNodeChanged(String name, NodeState before, NodeState after) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                if (PathUtils.isAncestor((String)p, (String)DiffBuilder.this.pathFilter) || p.startsWith(DiffBuilder.this.pathFilter)) {
                    super.childNodeChanged(name, before, after);
                }
            }
        };
        diffHandler.start(this.before, this.after, this.path);
        addedNodes.keySet().retainAll(removedNodes.keySet());
        if (!addedNodes.isEmpty()) {
            removedNodes.keySet().retainAll(addedNodes.keySet());
            buff.resetWriter();
            diffHandler = new TraversingNodeDiffHandler(this.store){

                @Override
                public void propertyAdded(PropertyState after) {
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)after.getName());
                    if (p.startsWith(DiffBuilder.this.pathFilter)) {
                        buff.tag('+').key(p).encodedValue(after.getEncodedValue()).newline();
                    }
                }

                @Override
                public void propertyChanged(PropertyState before, PropertyState after) {
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)after.getName());
                    if (p.startsWith(DiffBuilder.this.pathFilter)) {
                        buff.tag('^').key(p).encodedValue(after.getEncodedValue()).newline();
                    }
                }

                @Override
                public void propertyDeleted(PropertyState before) {
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)before.getName());
                    if (p.startsWith(DiffBuilder.this.pathFilter)) {
                        buff.tag('^').key(p).value(null).newline();
                    }
                }

                @Override
                public void childNodeAdded(String name, NodeState after) {
                    if (addedNodes.containsKey(after)) {
                        return;
                    }
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                    if (p.startsWith(DiffBuilder.this.pathFilter)) {
                        buff.tag('+').key(p).object();
                        DiffBuilder.this.toJson(buff, after);
                        buff.endObject().newline();
                    }
                }

                @Override
                public void childNodeDeleted(String name, NodeState before) {
                    if (addedNodes.containsKey(before)) {
                        return;
                    }
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                    if (p.startsWith(DiffBuilder.this.pathFilter)) {
                        buff.tag('-');
                        buff.value(p);
                        buff.newline();
                    }
                }

                @Override
                public void childNodeChanged(String name, NodeState before, NodeState after) {
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                    if (PathUtils.isAncestor((String)p, (String)DiffBuilder.this.pathFilter) || p.startsWith(DiffBuilder.this.pathFilter)) {
                        super.childNodeChanged(name, before, after);
                    }
                }
            };
            diffHandler.start(this.before, this.after, this.path);
            for (Map.Entry entry : addedNodes.entrySet()) {
                buff.tag('>').key((String)removedNodes.get(entry.getKey())).value((String)entry.getValue()).newline();
            }
        }
        return buff.toString();
    }

    private void toJson(JsopBuilder builder, NodeState node) {
        for (PropertyState propertyState : node.getProperties()) {
            builder.key(propertyState.getName()).encodedValue(propertyState.getEncodedValue());
        }
        for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries(0L, -1)) {
            builder.key(childNodeEntry.getName()).object();
            this.toJson(builder, childNodeEntry.getNode());
            builder.endObject();
        }
    }
}

