/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.store;

import java.util.HashSet;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.NodeState;
import org.apache.jackrabbit.mk.model.NodeStateDiff;
import org.apache.jackrabbit.mk.model.PropertyState;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.mk.store.StoredNodeAsState;

abstract class AbstractRevisionStore
implements RevisionStore {
    AbstractRevisionStore() {
    }

    @Override
    public NodeState getNodeState(StoredNode node) {
        return new StoredNodeAsState(node, this);
    }

    @Override
    public Id getId(NodeState node) {
        return ((StoredNodeAsState)node).getId();
    }

    @Override
    public NodeState getRoot() {
        Id id;
        try {
            id = this.getHeadCommitId();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access the head commit identifier", e);
        }
        try {
            return this.getNodeState(this.getRootNode(id));
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("Root node not found in revision " + id, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access the root node in revision " + id, e);
        }
    }

    @Override
    public void compare(NodeState before, NodeState after, NodeStateDiff diff) {
        this.compareProperties(before, after, diff);
        this.compareChildNodes(before, after, diff);
    }

    protected void compareProperties(NodeState before, NodeState after, NodeStateDiff diff) {
        HashSet<String> beforeProperties = new HashSet<String>();
        for (PropertyState propertyState : before.getProperties()) {
            String name = propertyState.getName();
            PropertyState afterProperty = after.getProperty(name);
            if (afterProperty == null) {
                diff.propertyDeleted(propertyState);
                continue;
            }
            beforeProperties.add(name);
            if (propertyState.equals(afterProperty)) continue;
            diff.propertyChanged(propertyState, afterProperty);
        }
        for (PropertyState propertyState : after.getProperties()) {
            if (beforeProperties.contains(propertyState.getName())) continue;
            diff.propertyAdded(propertyState);
        }
    }

    protected void compareChildNodes(NodeState before, NodeState after, NodeStateDiff diff) {
        String name;
        HashSet<String> beforeChildNodes = new HashSet<String>();
        for (ChildNodeEntry childNodeEntry : before.getChildNodeEntries(0L, -1)) {
            name = childNodeEntry.getName();
            NodeState beforeChild = childNodeEntry.getNode();
            NodeState afterChild = after.getChildNode(name);
            if (afterChild == null) {
                diff.childNodeDeleted(name, beforeChild);
                continue;
            }
            beforeChildNodes.add(name);
            if (beforeChild.equals(afterChild)) continue;
            diff.childNodeChanged(name, beforeChild, afterChild);
        }
        for (ChildNodeEntry childNodeEntry : after.getChildNodeEntries(0L, -1)) {
            name = childNodeEntry.getName();
            if (beforeChildNodes.contains(name)) continue;
            diff.childNodeAdded(name, childNodeEntry.getNode());
        }
    }
}

