/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.core;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.core.Repository;
import org.apache.jackrabbit.mk.json.JsonObject;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.json.JsopTokenizer;
import org.apache.jackrabbit.mk.model.CommitBuilder;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.tree.ChildNode;
import org.apache.jackrabbit.mk.model.tree.DiffBuilder;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mk.model.tree.PropertyState;
import org.apache.jackrabbit.mk.util.CommitGate;
import org.apache.jackrabbit.mk.util.NameFilter;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class MicroKernelImpl
implements MicroKernel {
    protected Repository rep;
    private final CommitGate gate = new CommitGate();

    public MicroKernelImpl(String homeDir) throws MicroKernelException {
        this.init(homeDir);
    }

    public MicroKernelImpl() {
        this(new Repository());
    }

    public MicroKernelImpl(Repository rep) {
        this.rep = rep;
    }

    protected void init(String homeDir) throws MicroKernelException {
        try {
            this.rep = new Repository(homeDir);
            this.rep.init();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public void dispose() {
        this.gate.commit("end");
        if (this.rep != null) {
            try {
                this.rep.shutDown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rep = null;
        }
    }

    public String getHeadRevision() throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        return this.getHeadRevisionId().toString();
    }

    private Id getHeadRevisionId() throws MicroKernelException {
        try {
            return this.rep.getHeadRevision();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public String getRevisionHistory(long since, int maxEntries, String path) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        path = path == null || "".equals(path) != false ? "/" : path;
        filtered = "/".equals(path) == false;
        maxEntries = maxEntries < 0 ? 0x7FFFFFFF : maxEntries;
        history = new ArrayList<StoredCommit>();
        try {
            commit = this.rep.getHeadCommit();
            while (commit != null && history.size() < maxEntries && commit.getCommitTS() >= since) {
                if (filtered) {
                    try {
                        diff = new DiffBuilder(this.rep.getNodeState(commit.getParentId(), "/"), this.rep.getNodeState(commit.getId(), "/"), "/", -1, this.rep.getRevisionStore(), path).build();
                        if (diff.isEmpty()) ** GOTO lbl21
                        history.add(commit);
                    }
                    catch (Exception e) {
                        throw new MicroKernelException((Throwable)e);
                    }
                } else {
                    history.add(commit);
                }
lbl21:
                // 3 sources

                commitId = commit.getParentId();
                if (commitId != null) {
                    commit = this.rep.getCommit(commitId);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
        buff = new JsopBuilder().array();
        for (i = history.size() - 1; i >= 0; --i) {
            commit = (StoredCommit)history.get(i);
            buff.object().key("id").value(commit.getId().toString()).key("ts").value(commit.getCommitTS()).key("msg").value(commit.getMsg()).endObject();
        }
        return buff.endArray().toString();
    }

    public String waitForCommit(String oldHeadRevisionId, long maxWaitMillis) throws MicroKernelException, InterruptedException {
        return this.gate.waitForCommit(oldHeadRevisionId, maxWaitMillis);
    }

    public String getJournal(String fromRevision, String toRevision, String path) throws MicroKernelException {
        StoredCommit commit;
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        path = path == null || "".equals(path) ? "/" : path;
        boolean filtered = !"/".equals(path);
        Id fromRevisionId = Id.fromString(fromRevision);
        Id toRevisionId = toRevision == null ? this.getHeadRevisionId() : Id.fromString(toRevision);
        ArrayList<StoredCommit> commits = new ArrayList<StoredCommit>();
        try {
            StoredCommit fromCommit;
            StoredCommit toCommit = this.rep.getCommit(toRevisionId);
            if (toCommit.getBranchRootId() != null) {
                throw new MicroKernelException("branch revisions are not supported: " + toRevisionId);
            }
            if (toRevisionId.equals(fromRevisionId)) {
                fromCommit = toCommit;
            } else {
                fromCommit = this.rep.getCommit(fromRevisionId);
                if (fromCommit.getCommitTS() > toCommit.getCommitTS()) {
                    return "[]";
                }
            }
            if (fromCommit.getBranchRootId() != null) {
                throw new MicroKernelException("branch revisions are not supported: " + fromRevisionId);
            }
            commit = toCommit;
            while (commit != null) {
                Id commitId;
                commits.add(commit);
                if (!commit.getId().equals(fromRevisionId) && (commitId = commit.getParentId()) != null && (commit = this.rep.getCommit(commitId)).getCommitTS() >= fromCommit.getCommitTS()) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
        JsopBuilder commitBuff = new JsopBuilder().array();
        for (int i = commits.size() - 1; i >= 0; --i) {
            commit = (StoredCommit)commits.get(i);
            if (commit.getParentId() == null) continue;
            String diff = commit.getChanges();
            if (filtered) {
                try {
                    diff = new DiffBuilder(this.rep.getNodeState(commit.getParentId(), "/"), this.rep.getNodeState(commit.getId(), "/"), "/", -1, this.rep.getRevisionStore(), path).build();
                    if (diff.isEmpty()) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new MicroKernelException((Throwable)e);
                }
            }
            commitBuff.object().key("id").value(commit.getId().toString()).key("ts").value(commit.getCommitTS()).key("msg").value(commit.getMsg()).key("changes").value(diff).endObject();
        }
        return commitBuff.endArray().toString();
    }

    public String diff(String fromRevision, String toRevision, String path, int depth) throws MicroKernelException {
        Id toRevisionId;
        Id fromRevisionId;
        String string = path = path == null || "".equals(path) ? "/" : path;
        if (depth < -1) {
            throw new IllegalArgumentException("depth");
        }
        if (fromRevision == null || toRevision == null) {
            Id head = this.getHeadRevisionId();
            fromRevisionId = fromRevision == null ? head : Id.fromString(fromRevision);
            toRevisionId = toRevision == null ? head : Id.fromString(toRevision);
        } else {
            fromRevisionId = Id.fromString(fromRevision);
            toRevisionId = Id.fromString(toRevision);
        }
        if (fromRevisionId.equals(toRevisionId)) {
            return "";
        }
        try {
            StoredCommit toCommit;
            if ("/".equals(path) && (toCommit = this.rep.getCommit(toRevisionId)).getParentId().equals(fromRevisionId)) {
                return toCommit.getChanges();
            }
            NodeState before = this.rep.getNodeState(fromRevisionId, path);
            NodeState after = this.rep.getNodeState(toRevisionId, path);
            return new DiffBuilder(before, after, path, depth, this.rep.getRevisionStore(), path).build();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public boolean nodeExists(String path, String revisionId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        try {
            return this.rep.nodeExists(revId, path);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public long getChildNodeCount(String path, String revisionId) throws MicroKernelException {
        NodeState nodeState;
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        try {
            nodeState = this.rep.getNodeState(revId, path);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
        if (nodeState != null) {
            return nodeState.getChildNodeCount();
        }
        throw new MicroKernelException("Path " + path + " not found in revision " + revisionId);
    }

    public String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) throws MicroKernelException {
        NodeFilter nodeFilter;
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        NodeFilter nodeFilter2 = nodeFilter = filter == null || filter.isEmpty() ? null : NodeFilter.parse(filter);
        if (offset > 0L && nodeFilter != null && nodeFilter.getChildNodeFilter() != null) {
            throw new IllegalArgumentException("offset > 0 with child node filter");
        }
        try {
            NodeState nodeState = this.rep.getNodeState(revId, path);
            if (nodeState == null) {
                return null;
            }
            JsopBuilder buf = new JsopBuilder().object();
            this.toJson(buf, nodeState, depth, (int)offset, maxChildNodes, true, nodeFilter);
            return buf.endObject().toString();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String commit(String path, String jsonDiff, String revisionId, String message) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        if (path.length() > 0 && !PathUtils.isAbsolute((String)path)) {
            throw new IllegalArgumentException("absolute path expected: " + path);
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        try {
            int r;
            JsopTokenizer t = new JsopTokenizer(jsonDiff);
            CommitBuilder cb = this.rep.getCommitBuilder(revId, message);
            block9: while ((r = t.read()) != 0) {
                switch (r) {
                    case 43: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        t.read(58);
                        if (t.matches(123)) {
                            String nodePath = PathUtils.concat((String)path, (String)subPath);
                            if (!PathUtils.isAbsolute((String)nodePath)) {
                                throw new Exception("absolute path expected: " + nodePath + ", pos: " + pos);
                            }
                            String parentPath = PathUtils.getParentPath((String)nodePath);
                            String nodeName = PathUtils.getName((String)nodePath);
                            cb.addNode(parentPath, nodeName, JsonObject.create(t));
                            continue block9;
                        }
                        String value = t.matches(5) ? null : t.readRawValue().trim();
                        String targetPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        String parentPath = PathUtils.getParentPath((String)targetPath);
                        String propName = PathUtils.getName((String)targetPath);
                        cb.setProperty(parentPath, propName, value);
                        continue block9;
                    }
                    case 45: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String targetPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.removeNode(targetPath);
                        continue block9;
                    }
                    case 94: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        t.read(58);
                        String value = t.matches(5) ? null : t.readRawValue().trim();
                        String targetPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        String parentPath = PathUtils.getParentPath((String)targetPath);
                        String propName = PathUtils.getName((String)targetPath);
                        cb.setProperty(parentPath, propName, value);
                        continue block9;
                    }
                    case 62: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String srcPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)srcPath)) {
                            throw new Exception("absolute path expected: " + srcPath + ", pos: " + pos);
                        }
                        t.read(58);
                        pos = t.getLastPos();
                        String targetPath = t.readString();
                        if (!PathUtils.isAbsolute((String)targetPath) && !PathUtils.isAbsolute((String)(targetPath = PathUtils.concat((String)path, (String)targetPath)))) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.moveNode(srcPath, targetPath);
                        continue block9;
                    }
                    case 42: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String srcPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)srcPath)) {
                            throw new Exception("absolute path expected: " + srcPath + ", pos: " + pos);
                        }
                        t.read(58);
                        pos = t.getLastPos();
                        String targetPath = t.readString();
                        if (!PathUtils.isAbsolute((String)targetPath) && !PathUtils.isAbsolute((String)(targetPath = PathUtils.concat((String)path, (String)targetPath)))) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.copyNode(srcPath, targetPath);
                        continue block9;
                    }
                }
                throw new AssertionError((Object)("token type: " + t.getTokenType()));
            }
            Id newHead = cb.doCommit();
            if (!newHead.equals(revId)) {
                this.gate.commit(newHead.toString());
            }
            return newHead.toString();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String branch(String trunkRevisionId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = trunkRevisionId == null ? this.getHeadRevisionId() : Id.fromString(trunkRevisionId);
        try {
            CommitBuilder cb = this.rep.getCommitBuilder(revId, "");
            return cb.doCommit(true).toString();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String merge(String branchRevisionId, String message) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = Id.fromString(branchRevisionId);
        try {
            return this.rep.getCommitBuilder(revId, message).doMerge().toString();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public long getLength(String blobId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().getBlobLength(blobId);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public int read(String blobId, long pos, byte[] buff, int off, int length) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().readBlob(blobId, pos, buff, off, length);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String write(InputStream in) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().writeBlob(in);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    void toJson(JsopBuilder builder, NodeState node, int depth, int offset, int maxChildNodes, boolean inclVirtualProps, NodeFilter filter) {
        for (PropertyState propertyState : node.getProperties()) {
            if (filter != null && !filter.includeProperty(propertyState.getName())) continue;
            builder.key(propertyState.getName()).encodedValue(propertyState.getEncodedValue());
        }
        long childCount = node.getChildNodeCount();
        if (inclVirtualProps) {
            NameFilter nf;
            if (filter == null || filter.includeProperty(":childNodeCount")) {
                builder.key(":childNodeCount").value(childCount);
            }
            if (filter != null && (nf = filter.getPropertyFilter()) != null && nf.getInclusionPatterns().contains(":hash") && !nf.getExclusionPatterns().contains(":hash")) {
                builder.key(":hash").value(this.rep.getRevisionStore().getId(node).toString());
            }
        }
        if (childCount > 0L && depth >= 0) {
            NameFilter childFilter;
            if (filter != null && (childFilter = filter.getChildNodeFilter()) != null && !childFilter.containsWildcard()) {
                int count = maxChildNodes == -1 ? Integer.MAX_VALUE : maxChildNodes;
                for (String string : childFilter.getInclusionPatterns()) {
                    NodeState child = node.getChildNode(string);
                    if (child == null) continue;
                    boolean incl = true;
                    for (String exclName : childFilter.getExclusionPatterns()) {
                        if (!string.equals(exclName)) continue;
                        incl = false;
                        break;
                    }
                    if (!incl) continue;
                    if (count-- <= 0) break;
                    builder.key(string).object();
                    if (depth > 0) {
                        this.toJson(builder, child, depth - 1, 0, maxChildNodes, inclVirtualProps, filter);
                    }
                    builder.endObject();
                }
                return;
            }
            int count = maxChildNodes;
            if (count != -1 && filter != null && filter.getChildNodeFilter() != null) {
                count = -1;
            }
            int numSiblings = 0;
            for (ChildNode childNode : node.getChildNodeEntries(offset, count)) {
                if (filter != null && !filter.includeNode(childNode.getName())) continue;
                if (maxChildNodes != -1 && ++numSiblings > maxChildNodes) break;
                builder.key(childNode.getName()).object();
                if (depth > 0) {
                    this.toJson(builder, childNode.getNode(), depth - 1, 0, maxChildNodes, inclVirtualProps, filter);
                }
                builder.endObject();
            }
        }
    }

    static class NodeFilter {
        NameFilter nodeFilter;
        NameFilter propFilter;

        private NodeFilter(NameFilter nodeFilter, NameFilter propFilter) {
            this.nodeFilter = nodeFilter;
            this.propFilter = propFilter;
        }

        static NodeFilter parse(String json) {
            JsopTokenizer t = new JsopTokenizer(json);
            t.read(123);
            NameFilter nodeFilter = null;
            NameFilter propFilter = null;
            do {
                String type = t.readString();
                t.read(58);
                String[] globs = NodeFilter.parseArray(t);
                if (type.equals("nodes")) {
                    nodeFilter = new NameFilter(globs);
                    continue;
                }
                if (type.equals("properties")) {
                    propFilter = new NameFilter(globs);
                    continue;
                }
                throw new IllegalArgumentException("illegal filter format");
            } while (t.matches(44));
            t.read(125);
            return new NodeFilter(nodeFilter, propFilter);
        }

        private static String[] parseArray(JsopTokenizer t) {
            ArrayList<String> l = new ArrayList<String>();
            t.read(91);
            do {
                l.add(t.readString());
            } while (t.matches(44));
            t.read(93);
            return l.toArray(new String[l.size()]);
        }

        NameFilter getChildNodeFilter() {
            return this.nodeFilter;
        }

        NameFilter getPropertyFilter() {
            return this.propFilter;
        }

        boolean includeNode(String name) {
            return this.nodeFilter == null || this.nodeFilter.matches(name);
        }

        boolean includeProperty(String name) {
            return this.propFilter == null || this.propFilter.matches(name);
        }
    }
}

