/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model.tree;

import java.util.Stack;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mk.model.tree.NodeStateDiff;
import org.apache.jackrabbit.mk.model.tree.NodeStore;
import org.apache.jackrabbit.oak.commons.PathUtils;

public abstract class TraversingNodeDiffHandler
implements NodeStateDiff {
    private final NodeStore store;
    protected Stack<String> paths = new Stack();

    public TraversingNodeDiffHandler(NodeStore store) {
        this.store = store;
    }

    public void start(NodeState before, NodeState after, String path) {
        this.paths.clear();
        this.paths.push(path);
        this.store.compare(before, after, this);
    }

    protected String getCurrentPath() {
        return this.paths.peek();
    }

    @Override
    public void childNodeChanged(String name, NodeState before, NodeState after) {
        this.paths.push(PathUtils.concat((String)this.getCurrentPath(), (String)name));
        this.store.compare(before, after, this);
        this.paths.pop();
    }
}

