/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.store;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.model.tree.AbstractChildNode;
import org.apache.jackrabbit.mk.model.tree.AbstractNodeState;
import org.apache.jackrabbit.mk.model.tree.AbstractPropertyState;
import org.apache.jackrabbit.mk.model.tree.ChildNode;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mk.model.tree.PropertyState;
import org.apache.jackrabbit.mk.store.RevisionProvider;

class StoredNodeAsState
extends AbstractNodeState {
    private final StoredNode node;
    private final RevisionProvider provider;

    public StoredNodeAsState(StoredNode node, RevisionProvider provider) {
        this.node = node;
        this.provider = provider;
    }

    Id getId() {
        return this.node.getId();
    }

    StoredNode unwrap() {
        return this.node;
    }

    @Override
    public PropertyState getProperty(String name) {
        String value = this.node.getProperties().get(name);
        if (value != null) {
            return new SimplePropertyState(name, value);
        }
        return null;
    }

    @Override
    public long getPropertyCount() {
        return this.node.getProperties().size();
    }

    public Iterable<PropertyState> getProperties() {
        return new Iterable<PropertyState>(){

            @Override
            public Iterator<PropertyState> iterator() {
                final Iterator<Map.Entry<String, String>> iterator = StoredNodeAsState.this.node.getProperties().entrySet().iterator();
                return new Iterator<PropertyState>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public PropertyState next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return new SimplePropertyState((String)entry.getKey(), (String)entry.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public NodeState getChildNode(String name) {
        ChildNodeEntry entry = this.node.getChildNodeEntry(name);
        if (entry != null) {
            return this.getChildNodeEntry(entry).getNode();
        }
        return null;
    }

    @Override
    public long getChildNodeCount() {
        return this.node.getChildNodeCount();
    }

    public Iterable<ChildNode> getChildNodeEntries(final long offset, final int count) {
        if (count < -1) {
            throw new IllegalArgumentException("Illegal count: " + count);
        }
        if (offset > Integer.MAX_VALUE) {
            return Collections.emptyList();
        }
        return new Iterable<ChildNode>(){

            @Override
            public Iterator<ChildNode> iterator() {
                final Iterator<ChildNodeEntry> iterator = StoredNodeAsState.this.node.getChildNodeEntries((int)offset, count);
                return new Iterator<ChildNode>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public ChildNode next() {
                        return StoredNodeAsState.this.getChildNodeEntry((ChildNodeEntry)iterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ChildNode getChildNodeEntry(final ChildNodeEntry entry) {
        return new AbstractChildNode(){

            @Override
            public String getName() {
                return entry.getName();
            }

            @Override
            public NodeState getNode() {
                try {
                    StoredNode child = StoredNodeAsState.this.provider.getNode(entry.getId());
                    return new StoredNodeAsState(child, StoredNodeAsState.this.provider);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error", e);
                }
            }
        };
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof StoredNodeAsState) {
            StoredNodeAsState other = (StoredNodeAsState)that;
            if (this.provider == other.provider && this.node.getId().equals(other.node.getId())) {
                return true;
            }
        }
        return super.equals(that);
    }

    private static class SimplePropertyState
    extends AbstractPropertyState {
        private final String name;
        private final String value;

        public SimplePropertyState(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getEncodedValue() {
            return this.value;
        }
    }
}

