/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.htree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.mk.htree.HashBucket;
import org.apache.jackrabbit.mk.model.ChildNodeEntries;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.store.Binding;
import org.apache.jackrabbit.mk.store.RevisionProvider;
import org.apache.jackrabbit.mk.store.RevisionStore;

class HashDirectory
implements ChildNodeEntries {
    private static final List<ChildNodeEntry> EMPTY = Collections.emptyList();
    private static final int MAX_CHILDREN = 256;
    private static final int BIT_SIZE = 8;
    private static final int MAX_DEPTH = 3;
    private final RevisionProvider provider;
    private final int depth;
    private int count;
    private IndexEntry[] index = new IndexEntry[256];

    public HashDirectory(RevisionProvider provider, int depth) {
        this.provider = provider;
        this.depth = depth;
    }

    public HashDirectory(HashDirectory other) {
        this.provider = other.provider;
        this.depth = other.depth;
        this.count = other.count;
        this.index = (IndexEntry[])other.index.clone();
    }

    @Override
    public Object clone() {
        HashDirectory clone = null;
        try {
            clone = (HashDirectory)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.index = (IndexEntry[])this.index.clone();
        return clone;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public ChildNodeEntry get(String name) {
        int hash = this.hashCode(name);
        IndexEntry ie = this.index[hash];
        if (ie == null) {
            return null;
        }
        if (ie instanceof ChildNodeEntry) {
            ChildNodeEntry cne = (ChildNodeEntry)((Object)ie);
            return cne.getName().equals(name) ? cne : null;
        }
        ChildNodeEntries container = ((ContainerEntry)ie).getContainer();
        if (container != null) {
            return container.get(name);
        }
        return null;
    }

    @Override
    public Iterator<ChildNodeEntry> getEntries(int offset, int count) {
        if (offset < 0 || count < -1) {
            throw new IllegalArgumentException();
        }
        if (offset >= this.count || count == 0) {
            return EMPTY.iterator();
        }
        int skipped = 0;
        if (count == -1 || offset + count > this.count) {
            count = this.count - offset;
        }
        ArrayList<ChildNodeEntry> list = new ArrayList<ChildNodeEntry>(count);
        for (IndexEntry ie : this.index) {
            if (ie == null) continue;
            if (skipped + ie.getSize() <= offset) {
                skipped += ie.getSize();
                continue;
            }
            if (ie instanceof ChildNodeEntry) {
                list.add((ChildNodeEntry)((Object)ie));
                continue;
            }
            ChildNodeEntries container = ((ContainerEntry)ie).getContainer();
            if (container != null) {
                Iterator<ChildNodeEntry> it = container.getEntries(offset - skipped, count - list.size());
                while (it.hasNext()) {
                    list.add(it.next());
                }
                skipped = offset;
            }
            if (list.size() == count) break;
        }
        return list.iterator();
    }

    @Override
    public ChildNodeEntry add(ChildNodeEntry entry) {
        int hash = this.hashCode(entry.getName());
        IndexEntry ie = this.index[hash];
        if (ie == null) {
            this.index[hash] = new NodeEntry(entry.getName(), entry.getId());
            ++this.count;
            return null;
        }
        if (ie instanceof ChildNodeEntry) {
            ChildNodeEntry existing = (ChildNodeEntry)((Object)ie);
            if (existing.getName().equals(entry.getName())) {
                this.index[hash] = new NodeEntry(entry.getName(), entry.getId());
                return existing;
            }
            ContainerEntry ce = this.createContainerEntry();
            ce.getContainer().add(existing);
            ce.getContainer().add(entry);
            this.index[hash] = ce;
            ++this.count;
            return null;
        }
        ContainerEntry ce = (ContainerEntry)ie;
        ChildNodeEntries container = ce.getContainer();
        ChildNodeEntry existing = container.add(entry);
        if (entry.equals(existing)) {
            return existing;
        }
        ce.setDirty(container);
        if (existing == null) {
            ++this.count;
        }
        return existing;
    }

    @Override
    public ChildNodeEntry remove(String name) {
        int hash = this.hashCode(name);
        IndexEntry ie = this.index[hash];
        if (ie == null) {
            return null;
        }
        if (ie instanceof ChildNodeEntry) {
            ChildNodeEntry existing = (ChildNodeEntry)((Object)ie);
            if (existing.getName().equals(name)) {
                this.index[hash] = null;
                --this.count;
                return existing;
            }
            return null;
        }
        ContainerEntry ce = (ContainerEntry)ie;
        ChildNodeEntries container = ce.getContainer();
        ChildNodeEntry existing = container.remove(name);
        if (existing == null) {
            return null;
        }
        if (container.getCount() == 0) {
            this.index[hash] = null;
        } else if (container.getCount() == 1) {
            ChildNodeEntry remaining = container.getEntries(0, 1).next();
            this.index[hash] = new NodeEntry(remaining.getName(), remaining.getId());
        } else {
            ce.setDirty(container);
        }
        --this.count;
        return existing;
    }

    @Override
    public Iterator<ChildNodeEntry> getAdded(ChildNodeEntries otherContainer) {
        if (!(otherContainer instanceof HashDirectory)) {
            return null;
        }
        HashDirectory other = (HashDirectory)otherContainer;
        ArrayList<ChildNodeEntry> added = new ArrayList<ChildNodeEntry>();
        for (int i = 0; i < this.index.length; ++i) {
            IndexEntry ie1 = this.index[i];
            IndexEntry ie2 = other.index[i];
            if (ie1 == null && ie2 == null || ie1 != null && ie1.equals(ie2)) continue;
            if (ie1 == null) {
                if (ie2 instanceof ChildNodeEntry) {
                    added.add((ChildNodeEntry)((Object)ie2));
                    continue;
                }
                ChildNodeEntries container = ((ContainerEntry)ie2).getContainer();
                Iterator<ChildNodeEntry> it = container.getEntries(0, -1);
                while (it.hasNext()) {
                    added.add(it.next());
                }
                continue;
            }
            if (ie1 instanceof ChildNodeEntry && ie2 instanceof ChildNodeEntry) {
                ChildNodeEntry cne1 = (ChildNodeEntry)((Object)ie1);
                ChildNodeEntry cne2 = (ChildNodeEntry)((Object)ie2);
                if (!cne2.getName().equals(cne1.getName())) continue;
                added.add(cne2);
                continue;
            }
            Iterator<ChildNodeEntry> it = ie1.getAdded(ie2);
            while (it.hasNext()) {
                added.add(it.next());
            }
        }
        return added.iterator();
    }

    @Override
    public Iterator<ChildNodeEntry> getModified(ChildNodeEntries otherContainer) {
        if (!(otherContainer instanceof HashDirectory)) {
            return null;
        }
        HashDirectory other = (HashDirectory)otherContainer;
        ArrayList<ChildNodeEntry> modified = new ArrayList<ChildNodeEntry>();
        for (int i = 0; i < this.index.length; ++i) {
            IndexEntry ie1 = this.index[i];
            IndexEntry ie2 = other.index[i];
            if (ie1 == null || ie2 == null || ie1.equals(ie2)) continue;
            if (ie1 instanceof ChildNodeEntry && ie2 instanceof ChildNodeEntry) {
                ChildNodeEntry cne1 = (ChildNodeEntry)((Object)ie1);
                ChildNodeEntry cne2 = (ChildNodeEntry)((Object)ie2);
                if (cne1.getName().equals(cne2.getName()) && !cne1.getId().equals(cne2.getId())) {
                    modified.add(cne1);
                    continue;
                }
            }
            Iterator<ChildNodeEntry> it = ie1.getModified(ie2);
            while (it.hasNext()) {
                modified.add(it.next());
            }
        }
        return modified.iterator();
    }

    private ContainerEntry createContainerEntry() {
        return this.depth < 2 ? new DirectoryEntry(this.depth + 1) : new BucketEntry();
    }

    private int hashCode(String name) {
        int hashMask = this.hashMask();
        int hash = name.hashCode();
        hash &= hashMask;
        hash >>>= (3 - this.depth) * 8;
        return hash %= 256;
    }

    int hashMask() {
        int bits = 255;
        int hashMask = bits << (3 - this.depth) * 8;
        return hashMask;
    }

    public void deserialize(Binding binding) throws Exception {
        this.count = binding.readIntValue(":count");
        Binding.StringEntryIterator iter = binding.readStringMap(":index");
        int pos = -1;
        while (iter.hasNext()) {
            Binding.StringEntry entry = (Binding.StringEntry)iter.next();
            assert (++pos == Integer.parseInt(entry.getKey()));
            if (entry.getValue().length() == 0) {
                this.index[pos] = null;
                continue;
            }
            switch (entry.getValue().charAt(0)) {
                case 'n': {
                    String value = entry.getValue().substring(1);
                    int i = value.indexOf(58);
                    String id = value.substring(0, i);
                    String name = value.substring(i + 1);
                    this.index[pos] = new NodeEntry(name, Id.fromString(id));
                    break;
                }
                case 'b': {
                    String value = entry.getValue().substring(1);
                    int i = value.indexOf(58);
                    String id = value.substring(0, i);
                    int count = Integer.parseInt(value.substring(i + 1));
                    this.index[pos] = new BucketEntry(this.provider, Id.fromString(id), count);
                    break;
                }
                case 'd': {
                    String value = entry.getValue().substring(1);
                    int i = value.indexOf(58);
                    String id = value.substring(0, i);
                    int count = Integer.parseInt(value.substring(i + 1));
                    this.index[pos] = new DirectoryEntry(this.provider, Id.fromString(id), count, this.depth + 1);
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashDirectory) {
            HashDirectory other = (HashDirectory)obj;
            return Arrays.equals(this.index, other.index);
        }
        return false;
    }

    public void prePersist(RevisionStore store, RevisionStore.PutToken token) throws Exception {
        for (int i = 0; i < this.index.length; ++i) {
            ContainerEntry ce;
            if (!(this.index[i] instanceof ContainerEntry) || !(ce = (ContainerEntry)this.index[i]).isDirty()) continue;
            ce.store(store, token);
        }
    }

    @Override
    public void serialize(Binding binding) throws Exception {
        final IndexEntry[] index = this.index;
        binding.write(":count", this.count);
        binding.writeMap(":index", index.length, new Binding.StringEntryIterator(){
            int pos = -1;

            @Override
            public boolean hasNext() {
                return this.pos < index.length - 1;
            }

            @Override
            public Binding.StringEntry next() {
                ++this.pos;
                if (this.pos >= index.length) {
                    throw new NoSuchElementException();
                }
                IndexEntry entry = index[this.pos];
                if (entry == null) {
                    return new Binding.StringEntry(Integer.toString(this.pos), "");
                }
                return new Binding.StringEntry(Integer.toString(this.pos), entry.toString());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Override
    public boolean inlined() {
        throw new NoSuchMethodError();
    }

    @Override
    public Iterator<String> getNames(int offset, int count) {
        throw new NoSuchMethodError();
    }

    @Override
    public ChildNodeEntry rename(String oldName, String newName) {
        throw new NoSuchMethodError();
    }

    @Override
    public Iterator<ChildNodeEntry> getRemoved(ChildNodeEntries other) {
        throw new NoSuchMethodError();
    }

    static class BucketEntry
    extends ContainerEntry {
        public BucketEntry(RevisionProvider provider, Id id, int count) {
            super(provider, id, count);
        }

        public BucketEntry() {
        }

        @Override
        public HashBucket getContainer() {
            if (this.container != null) {
                return (HashBucket)this.container;
            }
            try {
                return new HashBucket(this.provider.getCNEMap(this.id));
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public ChildNodeEntries createCompatibleContainer() {
            return new HashBucket();
        }

        public String toString() {
            return "b" + this.getId() + ":" + this.getSize();
        }
    }

    static class DirectoryEntry
    extends ContainerEntry {
        private final int depth;

        public DirectoryEntry(RevisionProvider provider, Id id, int count, int depth) {
            super(provider, id, count);
            this.depth = depth;
        }

        public DirectoryEntry(int depth) {
            this.depth = depth;
        }

        @Override
        public ChildNodeEntries getContainer() {
            if (this.container != null) {
                return this.container;
            }
            try {
                return new HashDirectory(this.provider, this.depth);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public ChildNodeEntries createCompatibleContainer() {
            return new HashDirectory(this.provider, this.depth);
        }

        public String toString() {
            return "d" + this.getId() + ":" + this.getSize();
        }

        @Override
        public void store(RevisionStore store, RevisionStore.PutToken token) throws Exception {
            ((HashDirectory)this.container).prePersist(store, token);
            super.store(store, token);
        }
    }

    static abstract class ContainerEntry
    implements IndexEntry {
        protected RevisionProvider provider;
        protected Id id;
        protected int count;
        protected ChildNodeEntries container;

        public ContainerEntry(RevisionProvider provider, Id id, int count) {
            this.provider = provider;
            this.id = id;
            this.count = count;
        }

        public ContainerEntry() {
        }

        public abstract ChildNodeEntries getContainer();

        public abstract ChildNodeEntries createCompatibleContainer();

        public boolean isDirty() {
            return this.container != null;
        }

        public void setDirty(ChildNodeEntries container) {
            this.container = container;
        }

        public Id getId() {
            return this.id;
        }

        @Override
        public int getSize() {
            if (this.container != null) {
                return this.container.getCount();
            }
            return this.count;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ContainerEntry) {
                ContainerEntry ce = (ContainerEntry)other;
                if (this.container != null && ce.container != null) {
                    return this.container.equals(ce.container);
                }
                if (this.container == null && ce.container == null) {
                    return this.count == ce.count && this.id == null ? ce.id == null : this.id.equals(ce.id);
                }
            }
            return false;
        }

        @Override
        public Iterator<ChildNodeEntry> getAdded(IndexEntry other) {
            if (other == null) {
                return null;
            }
            if (other instanceof ChildNodeEntry) {
                ChildNodeEntries container = ((ContainerEntry)other).createCompatibleContainer();
                container.add((ChildNodeEntry)((Object)other));
                return this.getContainer().getAdded(container);
            }
            return this.getContainer().getAdded(((ContainerEntry)other).getContainer());
        }

        @Override
        public Iterator<ChildNodeEntry> getModified(IndexEntry other) {
            if (other == null) {
                return null;
            }
            if (other instanceof ChildNodeEntry) {
                ChildNodeEntries container = ((ContainerEntry)other).createCompatibleContainer();
                container.add((ChildNodeEntry)((Object)other));
                return this.getContainer().getModified(container);
            }
            return this.getContainer().getModified(((ContainerEntry)other).getContainer());
        }

        public void store(RevisionStore store, RevisionStore.PutToken token) throws Exception {
            store.putCNEMap(token, this.container);
        }
    }

    static class NodeEntry
    extends ChildNodeEntry
    implements IndexEntry {
        public NodeEntry(String name, Id id) {
            super(name, id);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public Iterator<ChildNodeEntry> getAdded(IndexEntry other) {
            if (other == null) {
                return null;
            }
            ChildNodeEntries container = ((ContainerEntry)other).createCompatibleContainer();
            container.add(this);
            return container.getAdded(((ContainerEntry)other).getContainer());
        }

        @Override
        public Iterator<ChildNodeEntry> getModified(IndexEntry other) {
            if (other == null) {
                return null;
            }
            ChildNodeEntries container = ((ContainerEntry)other).createCompatibleContainer();
            container.add(this);
            return container.getModified(((ContainerEntry)other).getContainer());
        }

        public String toString() {
            return "n" + this.getId() + ":" + this.getName();
        }
    }

    static interface IndexEntry {
        public int getSize();

        public Iterator<ChildNodeEntry> getAdded(IndexEntry var1);

        public Iterator<ChildNodeEntry> getModified(IndexEntry var1);
    }
}

