/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.mk.model.ChildNodeEntries;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.store.Binding;
import org.apache.jackrabbit.mk.store.CacheObject;
import org.apache.jackrabbit.mk.store.RevisionProvider;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.mk.util.AbstractFilteringIterator;
import org.apache.jackrabbit.mk.util.AbstractRangeIterator;

public class ChildNodeEntriesTree
implements ChildNodeEntries,
CacheObject {
    protected static final List<ChildNodeEntry> EMPTY = Collections.emptyList();
    protected int count;
    protected RevisionProvider revProvider;
    protected IndexEntry[] index = new IndexEntry[1024];

    ChildNodeEntriesTree(RevisionProvider revProvider) {
        this.revProvider = revProvider;
    }

    @Override
    public boolean inlined() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ChildNodeEntriesTree) {
            ChildNodeEntriesTree other = (ChildNodeEntriesTree)obj;
            return Arrays.equals(this.index, other.index);
        }
        return false;
    }

    @Override
    public Object clone() {
        ChildNodeEntriesTree clone = null;
        try {
            clone = (ChildNodeEntriesTree)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.index = (IndexEntry[])this.index.clone();
        return clone;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public ChildNodeEntry get(String name) {
        IndexEntry entry = this.index[this.keyToIndex(name)];
        if (entry == null) {
            return null;
        }
        if (entry instanceof ChildNodeEntry) {
            ChildNodeEntry cne = (ChildNodeEntry)((Object)entry);
            return cne.getName().equals(name) ? cne : null;
        }
        if (entry instanceof BucketInfo) {
            BucketInfo bi = (BucketInfo)entry;
            ChildNodeEntriesMap entries = this.retrieveBucket(bi.getId());
            return entries == null ? null : entries.get(name);
        }
        Bucket bucket = (Bucket)entry;
        return bucket.get(name);
    }

    @Override
    public Iterator<String> getNames(int offset, int cnt) {
        if (offset < 0 || cnt < -1) {
            throw new IllegalArgumentException();
        }
        if (offset >= this.count || cnt == 0) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        if (cnt == -1 || offset + cnt > this.count) {
            cnt = this.count - offset;
        }
        return new AbstractRangeIterator<String>(this.getEntries(offset, cnt), 0, -1){

            @Override
            protected String doNext() {
                ChildNodeEntry cne = (ChildNodeEntry)this.it.next();
                return cne.getName();
            }
        };
    }

    @Override
    public Iterator<ChildNodeEntry> getEntries(int offset, int cnt) {
        if (offset < 0 || cnt < -1) {
            throw new IllegalArgumentException();
        }
        if (offset >= this.count || cnt == 0) {
            return EMPTY.iterator();
        }
        int skipped = 0;
        if (cnt == -1 || offset + cnt > this.count) {
            cnt = this.count - offset;
        }
        ArrayList<ChildNodeEntry> list = new ArrayList<ChildNodeEntry>(cnt);
        for (IndexEntry e : this.index) {
            if (e == null) continue;
            if (skipped + e.getSize() <= offset) {
                skipped += e.getSize();
                continue;
            }
            if (e instanceof NodeInfo) {
                list.add((NodeInfo)e);
            } else if (e instanceof BucketInfo) {
                BucketInfo bi = (BucketInfo)e;
                ChildNodeEntriesMap bucket = this.retrieveBucket(bi.getId());
                Iterator<ChildNodeEntry> it = bucket.getEntries(offset - skipped, cnt - list.size());
                while (it.hasNext()) {
                    list.add(it.next());
                }
                skipped = offset;
            } else {
                Bucket bucket = (Bucket)e;
                Iterator<ChildNodeEntry> it = bucket.getEntries(offset - skipped, cnt - list.size());
                while (it.hasNext()) {
                    list.add(it.next());
                }
                skipped = offset;
            }
            if (list.size() == cnt) break;
        }
        return list.iterator();
    }

    @Override
    public ChildNodeEntry add(ChildNodeEntry entry) {
        Bucket bucket;
        int idx = this.keyToIndex(entry.getName());
        IndexEntry ie = this.index[idx];
        if (ie == null) {
            this.index[idx] = new NodeInfo(entry.getName(), entry.getId());
            ++this.count;
            return null;
        }
        if (ie instanceof ChildNodeEntry) {
            ChildNodeEntry existing = (ChildNodeEntry)((Object)ie);
            if (existing.getName().equals(entry.getName())) {
                this.index[idx] = new NodeInfo(entry.getName(), entry.getId());
                return existing;
            }
            Bucket bucket2 = new Bucket();
            bucket2.add(existing);
            bucket2.add(entry);
            this.index[idx] = bucket2;
            ++this.count;
            return null;
        }
        if (ie instanceof BucketInfo) {
            BucketInfo bi = (BucketInfo)ie;
            bucket = new Bucket(this.retrieveBucket(bi.getId()));
        } else {
            bucket = (Bucket)ie;
        }
        ChildNodeEntry existing = bucket.add(entry);
        if (entry.equals(existing)) {
            return existing;
        }
        this.index[idx] = bucket;
        if (existing == null) {
            ++this.count;
        }
        return existing;
    }

    @Override
    public ChildNodeEntry remove(String name) {
        Bucket bucket;
        int idx = this.keyToIndex(name);
        IndexEntry ie = this.index[idx];
        if (ie == null) {
            return null;
        }
        if (ie instanceof ChildNodeEntry) {
            ChildNodeEntry existing = (ChildNodeEntry)((Object)ie);
            if (existing.getName().equals(name)) {
                this.index[idx] = null;
                --this.count;
                return existing;
            }
            return null;
        }
        if (ie instanceof BucketInfo) {
            BucketInfo bi = (BucketInfo)ie;
            bucket = new Bucket(this.retrieveBucket(bi.getId()));
        } else {
            bucket = (Bucket)ie;
        }
        ChildNodeEntry existing = bucket.remove(name);
        if (existing == null) {
            return null;
        }
        if (bucket.getCount() == 0) {
            this.index[idx] = null;
        } else if (bucket.getCount() == 1) {
            ChildNodeEntry remaining = bucket.getEntries(0, 1).next();
            this.index[idx] = new NodeInfo(remaining.getName(), remaining.getId());
        } else {
            this.index[idx] = bucket;
        }
        --this.count;
        return existing;
    }

    @Override
    public ChildNodeEntry rename(String oldName, String newName) {
        if (oldName.equals(newName)) {
            return this.get(oldName);
        }
        ChildNodeEntry old = this.remove(oldName);
        if (old == null) {
            return null;
        }
        this.add(new ChildNodeEntry(newName, old.getId()));
        return old;
    }

    @Override
    public Iterator<ChildNodeEntry> getAdded(ChildNodeEntries other) {
        if (other instanceof ChildNodeEntriesTree) {
            ArrayList<ChildNodeEntry> added = new ArrayList<ChildNodeEntry>();
            ChildNodeEntriesTree otherEntries = (ChildNodeEntriesTree)other;
            for (int i = 0; i < this.index.length; ++i) {
                ChildNodeEntriesMap bucket2;
                ChildNodeEntriesMap bucket1;
                Iterator<ChildNodeEntry> it;
                IndexEntry ie1 = this.index[i];
                IndexEntry ie2 = otherEntries.index[i];
                if (ie1 != null ? ie1.equals(ie2) : ie2 == null) continue;
                if (ie1 == null) {
                    if (ie2 instanceof NodeInfo) {
                        added.add((ChildNodeEntry)((Object)ie2));
                        continue;
                    }
                    if (ie2 instanceof BucketInfo) {
                        BucketInfo bi = (BucketInfo)ie2;
                        ChildNodeEntriesMap bucket = this.retrieveBucket(bi.getId());
                        it = bucket.getEntries(0, -1);
                        while (it.hasNext()) {
                            added.add(it.next());
                        }
                        continue;
                    }
                    Bucket bucket = (Bucket)ie2;
                    Iterator<ChildNodeEntry> it2 = bucket.getEntries(0, -1);
                    while (it2.hasNext()) {
                        added.add(it2.next());
                    }
                    continue;
                }
                if (ie2 == null) continue;
                if (ie1 instanceof NodeInfo) {
                    bucket1 = new ChildNodeEntriesMap();
                    bucket1.add((ChildNodeEntry)((Object)ie1));
                } else if (ie1 instanceof BucketInfo) {
                    BucketInfo bi = (BucketInfo)ie1;
                    bucket1 = this.retrieveBucket(bi.getId());
                } else {
                    bucket1 = (Bucket)ie1;
                }
                if (ie2 instanceof NodeInfo) {
                    bucket2 = new ChildNodeEntriesMap();
                    bucket2.add((ChildNodeEntry)((Object)ie2));
                } else if (ie2 instanceof BucketInfo) {
                    BucketInfo bi = (BucketInfo)ie2;
                    bucket2 = this.retrieveBucket(bi.getId());
                } else {
                    bucket2 = (Bucket)ie2;
                }
                it = bucket1.getAdded(bucket2);
                while (it.hasNext()) {
                    added.add(it.next());
                }
            }
            return added.iterator();
        }
        return new AbstractFilteringIterator<ChildNodeEntry>(other.getEntries(0, -1)){

            @Override
            protected boolean include(ChildNodeEntry entry) {
                return ChildNodeEntriesTree.this.get(entry.getName()) == null;
            }
        };
    }

    @Override
    public Iterator<ChildNodeEntry> getRemoved(final ChildNodeEntries other) {
        if (other instanceof ChildNodeEntriesTree) {
            ArrayList<ChildNodeEntry> removed = new ArrayList<ChildNodeEntry>();
            ChildNodeEntriesTree otherEntries = (ChildNodeEntriesTree)other;
            for (int i = 0; i < this.index.length; ++i) {
                ChildNodeEntriesMap bucket2;
                ChildNodeEntriesMap bucket1;
                Iterator<ChildNodeEntry> it;
                IndexEntry ie1 = this.index[i];
                IndexEntry ie2 = otherEntries.index[i];
                if (ie1 != null ? ie1.equals(ie2) : ie2 == null) continue;
                if (ie2 == null) {
                    if (ie1 instanceof NodeInfo) {
                        removed.add((ChildNodeEntry)((Object)ie1));
                        continue;
                    }
                    if (ie1 instanceof BucketInfo) {
                        BucketInfo bi = (BucketInfo)ie1;
                        ChildNodeEntriesMap bucket = this.retrieveBucket(bi.getId());
                        it = bucket.getEntries(0, -1);
                        while (it.hasNext()) {
                            removed.add(it.next());
                        }
                        continue;
                    }
                    Bucket bucket = (Bucket)ie1;
                    Iterator<ChildNodeEntry> it2 = bucket.getEntries(0, -1);
                    while (it2.hasNext()) {
                        removed.add(it2.next());
                    }
                    continue;
                }
                if (ie1 == null) continue;
                if (ie1 instanceof NodeInfo) {
                    bucket1 = new ChildNodeEntriesMap();
                    bucket1.add((ChildNodeEntry)((Object)ie1));
                } else if (ie1 instanceof BucketInfo) {
                    BucketInfo bi = (BucketInfo)ie1;
                    bucket1 = this.retrieveBucket(bi.getId());
                } else {
                    bucket1 = (Bucket)ie1;
                }
                if (ie2 instanceof NodeInfo) {
                    bucket2 = new ChildNodeEntriesMap();
                    bucket2.add((ChildNodeEntry)((Object)ie2));
                } else if (ie2 instanceof BucketInfo) {
                    BucketInfo bi = (BucketInfo)ie2;
                    bucket2 = this.retrieveBucket(bi.getId());
                } else {
                    bucket2 = (Bucket)ie2;
                }
                it = bucket1.getRemoved(bucket2);
                while (it.hasNext()) {
                    removed.add(it.next());
                }
            }
            return removed.iterator();
        }
        return new AbstractFilteringIterator<ChildNodeEntry>(this.getEntries(0, -1)){

            @Override
            protected boolean include(ChildNodeEntry entry) {
                return other.get(entry.getName()) == null;
            }
        };
    }

    @Override
    public Iterator<ChildNodeEntry> getModified(final ChildNodeEntries other) {
        if (other instanceof ChildNodeEntriesTree) {
            ArrayList<ChildNodeEntry> modified = new ArrayList<ChildNodeEntry>();
            ChildNodeEntriesTree otherEntries = (ChildNodeEntriesTree)other;
            for (int i = 0; i < this.index.length; ++i) {
                ChildNodeEntriesMap bucket2;
                ChildNodeEntriesMap bucket1;
                IndexEntry ie1 = this.index[i];
                IndexEntry ie2 = otherEntries.index[i];
                if (ie1 == null || ie2 == null || ie1.equals(ie2)) continue;
                if (ie1 instanceof NodeInfo && ie2 instanceof NodeInfo) {
                    NodeInfo ni1 = (NodeInfo)ie1;
                    NodeInfo ni2 = (NodeInfo)ie2;
                    if (ni1.getName().equals(ni2.getName()) && !ni1.getId().equals(ni2.getId())) {
                        modified.add(ni1);
                        continue;
                    }
                }
                if (ie1 instanceof NodeInfo) {
                    bucket1 = new ChildNodeEntriesMap();
                    bucket1.add((ChildNodeEntry)((Object)ie1));
                } else if (ie1 instanceof BucketInfo) {
                    BucketInfo bi = (BucketInfo)ie1;
                    bucket1 = this.retrieveBucket(bi.getId());
                } else {
                    bucket1 = (Bucket)ie1;
                }
                if (ie2 instanceof NodeInfo) {
                    bucket2 = new ChildNodeEntriesMap();
                    bucket2.add((ChildNodeEntry)((Object)ie2));
                } else if (ie2 instanceof BucketInfo) {
                    BucketInfo bi = (BucketInfo)ie2;
                    bucket2 = this.retrieveBucket(bi.getId());
                } else {
                    bucket2 = (Bucket)ie2;
                }
                Iterator<ChildNodeEntry> it = bucket1.getModified(bucket2);
                while (it.hasNext()) {
                    modified.add(it.next());
                }
            }
            return modified.iterator();
        }
        return new AbstractFilteringIterator<ChildNodeEntry>(this.getEntries(0, -1)){

            @Override
            protected boolean include(ChildNodeEntry entry) {
                ChildNodeEntry namesake = other.get(entry.getName());
                return namesake != null && !namesake.getId().equals(entry.getId());
            }
        };
    }

    protected void persistDirtyBuckets(RevisionStore store, RevisionStore.PutToken token) throws Exception {
        for (int i = 0; i < this.index.length; ++i) {
            if (!(this.index[i] instanceof Bucket)) continue;
            Bucket bucket = (Bucket)this.index[i];
            Id id = store.putCNEMap(token, bucket);
            this.index[i] = new BucketInfo(id, bucket.getSize());
        }
    }

    protected int keyToIndex(String key) {
        int hash = key.hashCode();
        return (hash & Integer.MAX_VALUE) % this.index.length;
    }

    protected ChildNodeEntriesMap retrieveBucket(Id id) {
        try {
            return this.revProvider.getCNEMap(id);
        }
        catch (Exception e) {
            return new ChildNodeEntriesMap();
        }
    }

    @Override
    public void serialize(Binding binding) throws Exception {
        binding.write(":count", this.count);
        binding.writeMap(":index", this.index.length, new Binding.StringEntryIterator(){
            int pos = -1;

            @Override
            public boolean hasNext() {
                return this.pos < ChildNodeEntriesTree.this.index.length - 1;
            }

            @Override
            public Binding.StringEntry next() {
                ++this.pos;
                if (this.pos >= ChildNodeEntriesTree.this.index.length) {
                    throw new NoSuchElementException();
                }
                IndexEntry entry = ChildNodeEntriesTree.this.index[this.pos];
                if (entry == null) {
                    return new Binding.StringEntry(Integer.toString(this.pos), "");
                }
                if (entry instanceof NodeInfo) {
                    NodeInfo ni = (NodeInfo)entry;
                    return new Binding.StringEntry(Integer.toString(this.pos), "n" + ni.getId() + ":" + ni.getName());
                }
                BucketInfo bi = (BucketInfo)entry;
                return new Binding.StringEntry(Integer.toString(this.pos), "b" + bi.getId() + ":" + bi.getSize());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    static ChildNodeEntriesTree deserialize(RevisionProvider provider, Binding binding) throws Exception {
        ChildNodeEntriesTree newInstance = new ChildNodeEntriesTree(provider);
        newInstance.count = binding.readIntValue(":count");
        Binding.StringEntryIterator iter = binding.readStringMap(":index");
        int pos = -1;
        while (iter.hasNext()) {
            String id;
            int i;
            String value;
            Binding.StringEntry entry = (Binding.StringEntry)iter.next();
            assert (++pos == Integer.parseInt(entry.getKey()));
            if (entry.getValue().length() == 0) {
                newInstance.index[pos] = null;
                continue;
            }
            if (entry.getValue().charAt(0) == 'n') {
                value = entry.getValue().substring(1);
                i = value.indexOf(58);
                id = value.substring(0, i);
                String name = value.substring(i + 1);
                newInstance.index[pos] = new NodeInfo(name, Id.fromString(id));
                continue;
            }
            value = entry.getValue().substring(1);
            i = value.indexOf(58);
            id = value.substring(0, i);
            int count = Integer.parseInt(value.substring(i + 1));
            newInstance.index[pos] = new BucketInfo(Id.fromString(id), count);
        }
        return newInstance;
    }

    @Override
    public int getMemory() {
        int memory = 100100;
        return memory;
    }

    protected static class NodeInfo
    extends ChildNodeEntry
    implements IndexEntry {
        public NodeInfo(String name, Id id) {
            super(name, id);
        }

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof NodeInfo) {
                return super.equals(obj);
            }
            return false;
        }
    }

    protected static class Bucket
    extends ChildNodeEntriesMap
    implements IndexEntry {
        protected Bucket() {
        }

        protected Bucket(ChildNodeEntriesMap other) {
            super(other);
        }

        @Override
        public int getSize() {
            return this.getCount();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Bucket) {
                return super.equals(obj);
            }
            return false;
        }
    }

    protected static class BucketInfo
    implements IndexEntry {
        private final Id id;
        private final int size;

        protected BucketInfo(Id id, int size) {
            this.id = id;
            this.size = size;
        }

        public Id getId() {
            return this.id;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BucketInfo) {
                BucketInfo other = (BucketInfo)obj;
                return this.size == other.size && this.id == null ? other.id == null : this.id.equals(other.id);
            }
            return false;
        }
    }

    protected static interface IndexEntry {
        public int getSize();
    }
}

