/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.Iterator;
import org.apache.jackrabbit.mk.model.AbstractNode;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesTree;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.store.PersistHook;
import org.apache.jackrabbit.mk.store.RevisionProvider;
import org.apache.jackrabbit.mk.store.RevisionStore;

public class MutableNode
extends AbstractNode
implements PersistHook {
    public MutableNode(RevisionProvider provider) {
        super(provider);
    }

    public MutableNode(Node other, RevisionProvider provider) {
        super(other, provider);
    }

    public ChildNodeEntry add(ChildNodeEntry newEntry) {
        ChildNodeEntry existing = this.childEntries.add(newEntry);
        if (this.childEntries.getCount() > 1000 && this.childEntries.inlined()) {
            ChildNodeEntriesTree entries = new ChildNodeEntriesTree(this.provider);
            Iterator<ChildNodeEntry> iter = this.childEntries.getEntries(0, -1);
            while (iter.hasNext()) {
                entries.add(iter.next());
            }
            this.childEntries = entries;
        }
        return existing;
    }

    public ChildNodeEntry remove(String name) {
        return this.childEntries.remove(name);
    }

    public ChildNodeEntry rename(String oldName, String newName) {
        return this.childEntries.rename(oldName, newName);
    }

    @Override
    public void prePersist(RevisionStore store, RevisionStore.PutToken token) throws Exception {
        if (!this.childEntries.inlined()) {
            ((ChildNodeEntriesTree)this.childEntries).persistDirtyBuckets(store, token);
        }
    }

    @Override
    public void postPersist(RevisionStore store, RevisionStore.PutToken token) throws Exception {
    }
}

