/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class CommitGate {
    private volatile String currentHead;
    private volatile AtomicReference<CountDownLatch> latchRef = new AtomicReference();

    public String waitForCommit(String lastHead, long millis) throws InterruptedException {
        CountDownLatch old;
        if (millis == 0L || this.currentHead != null && !this.currentHead.equals(lastHead)) {
            return this.currentHead;
        }
        CountDownLatch latch = this.latchRef.get();
        if (latch == null && (old = this.latchRef.getAndSet(latch = new CountDownLatch(1))) != null) {
            old.countDown();
        }
        latch.await(millis, TimeUnit.MILLISECONDS);
        return this.currentHead;
    }

    public void commit(String newHead) {
        this.currentHead = newHead;
        CountDownLatch latch = this.latchRef.get();
        if (latch != null) {
            latch.countDown();
            latch = this.latchRef.getAndSet(null);
            if (latch != null) {
                latch.countDown();
            }
        }
    }
}

