/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.Arrays;
import org.apache.jackrabbit.oak.commons.StringUtils;

public class Id
implements Comparable<Id> {
    private final byte[] raw;

    public Id(byte[] raw) {
        this.raw = raw;
    }

    public static Id fromString(String s) {
        return new Id(StringUtils.convertHexToBytes((String)s));
    }

    public static Id fromLong(long value) {
        byte[] raw = new byte[8];
        for (int i = raw.length - 1; i >= 0 && value != 0L; value >>>= 8, --i) {
            raw[i] = (byte)(value & 0xFFL);
        }
        return new Id(raw);
    }

    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Id) {
            Id other = (Id)obj;
            return Arrays.equals(this.raw, other.raw);
        }
        return false;
    }

    public String toString() {
        return StringUtils.convertBytesToHex((byte[])this.raw);
    }

    @Override
    public int compareTo(Id o) {
        byte[] other = o.getBytes();
        int len = Math.min(this.raw.length, other.length);
        for (int i = 0; i < len; ++i) {
            if (this.raw[i] == other[i]) continue;
            int rawValue = this.raw[i] & 0xFF;
            int otherValue = other[i] & 0xFF;
            return rawValue - otherValue;
        }
        return this.raw.length - other.length;
    }

    public byte[] getBytes() {
        return this.raw;
    }
}

