/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.MutableNode;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.NodeDelta;
import org.apache.jackrabbit.mk.model.NodeDiffHandler;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsonObject;

public class StagedNodeTree {
    private final RevisionStore store;
    private StagedNode root;
    private Id baseRevisionId;

    public StagedNodeTree(RevisionStore store, Id baseRevisionId) {
        this.store = store;
        this.baseRevisionId = baseRevisionId;
    }

    public void reset(Id newBaseRevisionId) {
        this.root = null;
        this.baseRevisionId = newBaseRevisionId;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public Id persist(RevisionStore.PutToken token) throws Exception {
        return this.root != null ? this.root.persist(token) : null;
    }

    public Id rebase(Id baseId, Id fromId, Id toId, RevisionStore.PutToken token) throws Exception {
        this.reset(baseId);
        StoredNode baseRoot = this.store.getRootNode(baseId);
        StoredNode fromRoot = this.store.getRootNode(fromId);
        StoredNode toRoot = this.store.getRootNode(toId);
        this.rebaseNode(baseRoot, fromRoot, toRoot, "/");
        return this.persist(token);
    }

    public Id merge(StoredNode ourRoot, Id newBaseRevisionId, Id commonAncestorRevisionId, RevisionStore.PutToken token) throws Exception {
        this.reset(newBaseRevisionId);
        StoredNode baseRoot = this.store.getRootNode(commonAncestorRevisionId);
        StoredNode theirRoot = this.store.getRootNode(newBaseRevisionId);
        this.mergeNode(baseRoot, ourRoot, theirRoot, "/");
        return this.persist(token);
    }

    public void add(String parentNodePath, String nodeName, JsonObject nodeData) throws Exception {
        if (nodeName.isEmpty()) {
            throw new Exception("cannot add a node with an empty name");
        }
        StagedNode parent = this.getStagedNode(parentNodePath, true);
        if (parent.getChildNodeEntry(nodeName) != null) {
            throw new Exception("there's already a child node with name '" + nodeName + "'");
        }
        parent.add(nodeName, nodeData);
    }

    public void remove(String nodePath) throws Exception {
        String parentPath = PathUtils.getParentPath((String)nodePath);
        String nodeName = PathUtils.getName((String)nodePath);
        StagedNode parent = this.getStagedNode(parentPath, true);
        if (parent.remove(nodeName) == null) {
            throw new NotFoundException(nodePath);
        }
        this.unstageNode(nodePath);
    }

    public void setProperty(String nodePath, String propName, String propValue) throws Exception {
        if (propName.isEmpty()) {
            throw new Exception("cannot set a property with an empty name");
        }
        StagedNode node = this.getStagedNode(nodePath, true);
        Map<String, String> properties = node.getProperties();
        if (propValue == null) {
            properties.remove(propName);
        } else {
            properties.put(propName, propValue);
        }
    }

    public void move(String srcPath, String destPath) throws Exception {
        if (PathUtils.isAncestor((String)srcPath, (String)destPath)) {
            throw new Exception("target path cannot be descendant of source path: " + destPath);
        }
        String srcParentPath = PathUtils.getParentPath((String)srcPath);
        String srcNodeName = PathUtils.getName((String)srcPath);
        String destParentPath = PathUtils.getParentPath((String)destPath);
        String destNodeName = PathUtils.getName((String)destPath);
        StagedNode srcParent = this.getStagedNode(srcParentPath, true);
        if (srcParent.getChildNodeEntry(srcNodeName) == null) {
            throw new NotFoundException(srcPath);
        }
        StagedNode destParent = this.getStagedNode(destParentPath, true);
        if (destParent.getChildNodeEntry(destNodeName) != null) {
            throw new Exception("node already exists at move destination path: " + destPath);
        }
        if (srcParentPath.equals(destParentPath)) {
            srcParent.rename(srcNodeName, destNodeName);
        } else {
            srcParent.move(srcNodeName, destPath);
        }
    }

    public void copy(String srcPath, String destPath) throws Exception {
        String srcParentPath = PathUtils.getParentPath((String)srcPath);
        String srcNodeName = PathUtils.getName((String)srcPath);
        String destParentPath = PathUtils.getParentPath((String)destPath);
        String destNodeName = PathUtils.getName((String)destPath);
        StagedNode srcParent = this.getStagedNode(srcParentPath, false);
        if (srcParent == null) {
            ChildNodeEntry entry = this.getStoredNode(srcParentPath).getChildNodeEntry(srcNodeName);
            if (entry == null) {
                throw new NotFoundException(srcPath);
            }
            StagedNode destParent = this.getStagedNode(destParentPath, true);
            if (destParent.getChildNodeEntry(destNodeName) != null) {
                throw new Exception("node already exists at copy destination path: " + destPath);
            }
            destParent.add(new ChildNodeEntry(destNodeName, entry.getId()));
            return;
        }
        ChildNodeEntry srcEntry = srcParent.getChildNodeEntry(srcNodeName);
        if (srcEntry == null) {
            throw new NotFoundException(srcPath);
        }
        StagedNode destParent = this.getStagedNode(destParentPath, true);
        StagedNode srcNode = this.getStagedNode(srcPath, false);
        if (srcNode != null) {
            destParent.add(destNodeName, srcNode.copy());
        } else {
            destParent.add(new ChildNodeEntry(destNodeName, srcEntry.getId()));
        }
    }

    private StagedNode getStagedNode(String path, boolean createIfNotStaged) throws Exception {
        assert (PathUtils.isAbsolute((String)path));
        if (this.root == null) {
            if (!createIfNotStaged) {
                return null;
            }
            this.root = new StagedNode(this.store.getRootNode(this.baseRevisionId), this.store);
        }
        if (PathUtils.denotesRoot((String)path)) {
            return this.root;
        }
        StagedNode parent = this.root;
        StagedNode node = null;
        for (String name : PathUtils.elements((String)path)) {
            node = parent.getStagedChildNode(name, createIfNotStaged);
            if (node == null) {
                return null;
            }
            parent = node;
        }
        return node;
    }

    private StagedNode unstageNode(String path) throws Exception {
        assert (PathUtils.isAbsolute((String)path));
        if (PathUtils.denotesRoot((String)path)) {
            StagedNode unstaged = this.root;
            this.root = null;
            return unstaged;
        }
        String parentPath = PathUtils.getParentPath((String)path);
        String name = PathUtils.getName((String)path);
        StagedNode parent = this.getStagedNode(parentPath, false);
        if (parent == null) {
            return null;
        }
        return parent.unstageChildNode(name);
    }

    private StoredNode getStoredNode(String path) throws Exception {
        assert (PathUtils.isAbsolute((String)path));
        if (PathUtils.denotesRoot((String)path)) {
            return this.store.getRootNode(this.baseRevisionId);
        }
        StoredNode parent = this.store.getRootNode(this.baseRevisionId);
        StoredNode node = null;
        for (String name : PathUtils.elements((String)path)) {
            ChildNodeEntry entry = parent.getChildNodeEntry(name);
            if (entry == null) {
                throw new NotFoundException(path);
            }
            node = this.store.getNode(entry.getId());
            if (node == null) {
                throw new NotFoundException(path);
            }
            parent = node;
        }
        return node;
    }

    private void rebaseNode(StoredNode base, StoredNode from, StoredNode to, String path) throws Exception {
        Id ourId;
        String theirValue;
        String ourValue;
        String name;
        assert (from != null);
        assert (to != null);
        assert (base != null);
        NodeDelta theirDelta = new NodeDelta(from, base);
        NodeDelta ourDelta = new NodeDelta(from, to);
        StagedNode stagedNode = this.getStagedNode(path, true);
        for (Map.Entry<String, String> entry : ourDelta.getAddedProperties().entrySet()) {
            name = entry.getKey();
            ourValue = entry.getValue();
            theirValue = theirDelta.getAddedProperties().get(name);
            if (theirValue != null && !theirValue.equals(ourValue)) {
                this.markConflict(stagedNode, "addExistingProperty", name, ourValue);
                continue;
            }
            stagedNode.getProperties().put(name, ourValue);
        }
        for (Map.Entry<String, String> entry : ourDelta.getRemovedProperties().entrySet()) {
            name = entry.getKey();
            ourValue = entry.getValue();
            if (theirDelta.getRemovedProperties().containsKey(name)) {
                this.markConflict(stagedNode, "deleteDeletedProperty", name, ourValue);
                continue;
            }
            if (theirDelta.getChangedProperties().containsKey(name)) {
                this.markConflict(stagedNode, "deleteChangedProperty", name, ourValue);
                continue;
            }
            stagedNode.getProperties().remove(name);
        }
        for (Map.Entry<String, String> entry : ourDelta.getChangedProperties().entrySet()) {
            name = entry.getKey();
            ourValue = entry.getValue();
            theirValue = theirDelta.getChangedProperties().get(name);
            if (theirDelta.getRemovedProperties().containsKey(name)) {
                this.markConflict(stagedNode, "changeDeletedProperty", name, ourValue);
                continue;
            }
            if (theirValue != null && !theirValue.equals(ourValue)) {
                this.markConflict(stagedNode, "changeChangedProperty", name, ourValue);
                continue;
            }
            stagedNode.getProperties().put(name, ourValue);
        }
        for (Map.Entry<String, Object> entry : ourDelta.getAddedChildNodes().entrySet()) {
            name = entry.getKey();
            ourId = (Id)entry.getValue();
            Id theirId = theirDelta.getAddedChildNodes().get(name);
            if (theirId != null && !theirId.equals(ourId)) {
                try {
                    StagedNode child = stagedNode.getStagedChildNode(name, true);
                    StoredNode addedTo = this.getStoredChildNode(to, name);
                    child.merge(addedTo, true);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            stagedNode.add(new ChildNodeEntry(name, ourId));
        }
        for (Map.Entry<String, Object> entry : ourDelta.getRemovedChildNodes().entrySet()) {
            name = entry.getKey();
            ourId = (Id)entry.getValue();
            if (theirDelta.getRemovedChildNodes().containsKey(name)) {
                this.markConflict(stagedNode, "deleteDeletedNode", name, ourId);
                continue;
            }
            if (theirDelta.getChangedChildNodes().containsKey(name)) {
                this.markConflict(stagedNode, "deleteChangedNode", name, ourId);
                continue;
            }
            stagedNode.remove(name);
        }
        for (Map.Entry<String, Object> entry : ourDelta.getChangedChildNodes().entrySet()) {
            name = entry.getKey();
            ourId = (Id)entry.getValue();
            StoredNode changedBase = this.getStoredChildNode(base, name);
            if (changedBase == null) {
                this.markConflict(stagedNode, "changeDeletedNode", name, ourId);
                continue;
            }
            StoredNode changedFrom = this.getStoredChildNode(from, name);
            StoredNode changedTo = this.getStoredChildNode(to, name);
            String changedPath = PathUtils.concat((String)path, (String)name);
            this.rebaseNode(changedBase, changedFrom, changedTo, changedPath);
        }
    }

    private void markConflict(StagedNode parent, String conflictType, String name, String ourValue) {
        StagedNode marker = this.getOrAddConflictMarker(parent, conflictType);
        marker.getProperties().put(name, ourValue);
    }

    private void markConflict(StagedNode parent, String conflictType, String name, Id ourId) {
        StagedNode marker = this.getOrAddConflictMarker(parent, conflictType);
        marker.add(new ChildNodeEntry(name, ourId));
    }

    private StagedNode getOrAddConflictMarker(StagedNode parent, String name) {
        StagedNode conflict = this.getOrAddNode(parent, ":conflict");
        return this.getOrAddNode(conflict, name);
    }

    private StagedNode getOrAddNode(StagedNode parent, String name) {
        ChildNodeEntry cne = parent.getChildNodeEntry(name);
        if (cne == null) {
            return parent.add(name, new StagedNode(this.store));
        }
        try {
            return parent.getStagedChildNode(name, true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private StoredNode getStoredChildNode(StoredNode parent, String name) throws Exception {
        ChildNodeEntry cne = parent.getChildNodeEntry(name);
        return cne == null ? null : this.store.getNode(cne.getId());
    }

    private void mergeNode(StoredNode baseNode, StoredNode ourNode, StoredNode theirNode, String path) throws Exception {
        NodeDelta theirChanges = new NodeDelta(baseNode, theirNode);
        NodeDelta ourChanges = new NodeDelta(baseNode, ourNode);
        StagedNode stagedNode = this.getStagedNode(path, true);
        stagedNode.getProperties().putAll(ourChanges.getAddedProperties());
        stagedNode.getProperties().putAll(ourChanges.getChangedProperties());
        for (String string : ourChanges.getRemovedProperties().keySet()) {
            stagedNode.getProperties().remove(string);
        }
        for (Map.Entry entry : ourChanges.getAddedChildNodes().entrySet()) {
            stagedNode.add(new ChildNodeEntry((String)entry.getKey(), (Id)entry.getValue()));
        }
        for (Map.Entry entry : ourChanges.getChangedChildNodes().entrySet()) {
            if (theirChanges.getChangedChildNodes().containsKey(entry.getKey())) continue;
            stagedNode.add(new ChildNodeEntry((String)entry.getKey(), (Id)entry.getValue()));
        }
        for (String string : ourChanges.getRemovedChildNodes().keySet()) {
            stagedNode.remove(string);
        }
        List<NodeDelta.Conflict> conflicts = theirChanges.listConflicts(ourChanges);
        for (NodeDelta.Conflict conflict : conflicts) {
            String conflictName = conflict.getName();
            String conflictPath = PathUtils.concat((String)path, (String)conflictName);
            switch (conflict.getType()) {
                case PROPERTY_VALUE_CONFLICT: {
                    throw new Exception("concurrent modification of property " + conflictPath + " with conflicting values: \"" + ourNode.getProperties().get(conflictName) + "\", \"" + theirNode.getProperties().get(conflictName));
                }
                case NODE_CONTENT_CONFLICT: {
                    if (ourChanges.getChangedChildNodes().containsKey(conflictName)) {
                        StoredNode baseChild = this.getStoredChildNode(baseNode, conflictName);
                        StoredNode ourChild = this.getStoredChildNode(ourNode, conflictName);
                        StoredNode theirChild = this.getStoredChildNode(theirNode, conflictName);
                        this.mergeNode(baseChild, ourChild, theirChild, PathUtils.concat((String)path, (String)conflictName));
                        break;
                    }
                    try {
                        StagedNode child = stagedNode.getStagedChildNode(conflictName, true);
                        StoredNode theirChild = this.getStoredChildNode(theirNode, conflictName);
                        child.merge(theirChild, false);
                        break;
                    }
                    catch (Exception e) {
                        throw new Exception(String.format("colliding concurrent node creation: '%s'\n%s", conflictPath, e.getMessage()));
                    }
                }
                case REMOVED_DIRTY_PROPERTY_CONFLICT: {
                    stagedNode.getProperties().remove(conflictName);
                    break;
                }
                case REMOVED_DIRTY_NODE_CONFLICT: {
                    stagedNode.remove(conflictName);
                }
            }
        }
    }

    private class StagedNode
    extends MutableNode {
        private final Map<String, StagedNode> stagedChildNodes;

        private StagedNode(RevisionStore store) {
            super(store);
            this.stagedChildNodes = new HashMap<String, StagedNode>();
        }

        private StagedNode(Node base, RevisionStore store) {
            super(base, store);
            this.stagedChildNodes = new HashMap<String, StagedNode>();
        }

        StagedNode getStagedChildNode(String name, boolean createIfNotStaged) throws Exception {
            StagedNode child = this.stagedChildNodes.get(name);
            if (child == null) {
                ChildNodeEntry entry = this.getChildNodeEntry(name);
                if (entry != null) {
                    if (createIfNotStaged) {
                        child = new StagedNode(StagedNodeTree.this.store.getNode(entry.getId()), StagedNodeTree.this.store);
                        this.stagedChildNodes.put(name, child);
                    }
                } else {
                    throw new NotFoundException(name);
                }
            }
            return child;
        }

        StagedNode unstageChildNode(String name) {
            return this.stagedChildNodes.remove(name);
        }

        StagedNode add(String name, StagedNode node) {
            this.stagedChildNodes.put(name, node);
            this.add(new ChildNodeEntry(name, null));
            return node;
        }

        StagedNode copy() {
            StagedNode copy = new StagedNode(this, StagedNodeTree.this.store);
            for (Map.Entry<String, StagedNode> entry : this.stagedChildNodes.entrySet()) {
                copy.add(entry.getKey(), entry.getValue().copy());
            }
            return copy;
        }

        StagedNode add(String name, JsonObject obj) {
            StagedNode node = new StagedNode(StagedNodeTree.this.store);
            node.getProperties().putAll(obj.getProperties());
            for (Map.Entry entry : obj.getChildren().entrySet()) {
                node.add((String)entry.getKey(), (JsonObject)entry.getValue());
            }
            this.stagedChildNodes.put(name, node);
            this.add(new ChildNodeEntry(name, null));
            return node;
        }

        void merge(final StoredNode other, final boolean markConflicts) throws Exception {
            final ArrayList conflicts = new ArrayList();
            final StagedNode thisNode = this;
            this.diff(other, new NodeDiffHandler(){

                @Override
                public void propAdded(String propName, String value) {
                    thisNode.getProperties().put(propName, value);
                }

                @Override
                public void propChanged(String propName, String oldValue, String newValue) {
                    if (oldValue != null && !oldValue.equals(newValue) || oldValue != newValue) {
                        if (markConflicts) {
                            StagedNodeTree.this.markConflict(thisNode, "addExistingProperty", propName, newValue);
                        } else {
                            conflicts.add(String.format("property '%s': conflictying values '%s' and '%s'", propName, oldValue, newValue));
                        }
                    }
                }

                @Override
                public void propDeleted(String propName, String value) {
                }

                @Override
                public void childNodeAdded(ChildNodeEntry added) {
                    thisNode.add(added);
                }

                @Override
                public void childNodeDeleted(ChildNodeEntry deleted) {
                }

                @Override
                public void childNodeChanged(ChildNodeEntry changed, Id newId) {
                    if (markConflicts && thisNode.getChildNodeEntry(":conflict") == null || !markConflicts && conflicts.isEmpty()) {
                        try {
                            StagedNode child = StagedNode.this.getStagedChildNode(changed.getName(), true);
                            StoredNode otherChild = StagedNodeTree.this.getStoredChildNode(other, changed.getName());
                            child.merge(otherChild, markConflicts);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
            });
            if (!markConflicts && !conflicts.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (String conflict : conflicts) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(conflict);
                }
                throw new Exception(sb.toString());
            }
        }

        void move(String name, String destPath) throws Exception {
            ChildNodeEntry srcEntry = this.getChildNodeEntry(name);
            assert (srcEntry != null);
            String destParentPath = PathUtils.getParentPath((String)destPath);
            String destName = PathUtils.getName((String)destPath);
            StagedNode destParent = StagedNodeTree.this.getStagedNode(destParentPath, true);
            StagedNode target = this.stagedChildNodes.get(name);
            this.remove(name);
            destParent.add(new ChildNodeEntry(destName, srcEntry.getId()));
            if (target != null) {
                destParent.add(destName, target);
            }
        }

        @Override
        public ChildNodeEntry remove(String name) {
            this.stagedChildNodes.remove(name);
            return super.remove(name);
        }

        @Override
        public ChildNodeEntry rename(String oldName, String newName) {
            StagedNode child = this.stagedChildNodes.remove(oldName);
            if (child != null) {
                this.stagedChildNodes.put(newName, child);
            }
            return super.rename(oldName, newName);
        }

        Id persist(RevisionStore.PutToken token) throws Exception {
            for (Map.Entry<String, StagedNode> entry : this.stagedChildNodes.entrySet()) {
                String name = entry.getKey();
                StagedNode childNode = entry.getValue();
                Id id = childNode.persist(token);
                this.add(new ChildNodeEntry(name, id));
            }
            return StagedNodeTree.this.store.putNode(token, this);
        }
    }
}

