/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.Stack;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.NodeDiffHandler;
import org.apache.jackrabbit.mk.store.RevisionProvider;
import org.apache.jackrabbit.oak.commons.PathUtils;

public abstract class TraversingNodeDiffHandler
implements NodeDiffHandler {
    protected Stack<String> paths = new Stack();
    protected final RevisionProvider rp;

    public TraversingNodeDiffHandler(RevisionProvider rp) {
        this.rp = rp;
    }

    public void start(Node before, Node after, String path) {
        this.paths.clear();
        this.paths.push(path);
        before.diff(after, this);
    }

    protected String getCurrentPath() {
        return this.paths.peek();
    }

    @Override
    public void childNodeChanged(ChildNodeEntry changed, Id newId) {
        this.paths.push(PathUtils.concat((String)this.getCurrentPath(), (String)changed.getName()));
        try {
            this.rp.getNode(changed.getId()).diff(this.rp.getNode(newId), this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.paths.pop();
    }
}

