/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mk.json.JsonObject;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.MutableNode;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.model.tree.NodeDelta;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class StagedNodeTree {
    private final RevisionStore store;
    private StagedNode root;
    private Id baseRevisionId;

    public StagedNodeTree(RevisionStore store, Id baseRevisionId) {
        this.store = store;
        this.baseRevisionId = baseRevisionId;
    }

    public void reset(Id newBaseRevisionId) {
        this.root = null;
        this.baseRevisionId = newBaseRevisionId;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public Id persist(RevisionStore.PutToken token) throws Exception {
        return this.root != null ? this.root.persist(token) : null;
    }

    public Id merge(StoredNode ourRoot, Id newBaseRevisionId, Id commonAncestorRevisionId, RevisionStore.PutToken token) throws Exception {
        this.reset(newBaseRevisionId);
        StoredNode baseRoot = this.store.getRootNode(commonAncestorRevisionId);
        StoredNode theirRoot = this.store.getRootNode(newBaseRevisionId);
        this.mergeNode(baseRoot, ourRoot, theirRoot, "/");
        return this.persist(token);
    }

    public void add(String parentNodePath, String nodeName, JsonObject nodeData) throws Exception {
        StagedNode parent = this.getStagedNode(parentNodePath, true);
        if (parent.getChildNodeEntry(nodeName) != null) {
            throw new Exception("there's already a child node with name '" + nodeName + "'");
        }
        parent.add(nodeName, nodeData);
    }

    public void remove(String nodePath) throws Exception {
        String parentPath = PathUtils.getParentPath((String)nodePath);
        String nodeName = PathUtils.getName((String)nodePath);
        StagedNode parent = this.getStagedNode(parentPath, true);
        if (parent.remove(nodeName) == null) {
            throw new NotFoundException(nodePath);
        }
        this.unstageNode(nodePath);
    }

    public void setProperty(String nodePath, String propName, String propValue) throws Exception {
        StagedNode node = this.getStagedNode(nodePath, true);
        Map<String, String> properties = node.getProperties();
        if (propValue == null) {
            properties.remove(propName);
        } else {
            properties.put(propName, propValue);
        }
    }

    public void move(String srcPath, String destPath) throws Exception {
        if (PathUtils.isAncestor((String)srcPath, (String)destPath)) {
            throw new Exception("target path cannot be descendant of source path: " + destPath);
        }
        String srcParentPath = PathUtils.getParentPath((String)srcPath);
        String srcNodeName = PathUtils.getName((String)srcPath);
        String destParentPath = PathUtils.getParentPath((String)destPath);
        String destNodeName = PathUtils.getName((String)destPath);
        StagedNode srcParent = this.getStagedNode(srcParentPath, true);
        if (srcParent.getChildNodeEntry(srcNodeName) == null) {
            throw new NotFoundException(srcPath);
        }
        StagedNode destParent = this.getStagedNode(destParentPath, true);
        if (destParent.getChildNodeEntry(destNodeName) != null) {
            throw new Exception("node already exists at move destination path: " + destPath);
        }
        if (srcParentPath.equals(destParentPath)) {
            srcParent.rename(srcNodeName, destNodeName);
        } else {
            srcParent.move(srcNodeName, destPath);
        }
    }

    public void copy(String srcPath, String destPath) throws Exception {
        String srcParentPath = PathUtils.getParentPath((String)srcPath);
        String srcNodeName = PathUtils.getName((String)srcPath);
        String destParentPath = PathUtils.getParentPath((String)destPath);
        String destNodeName = PathUtils.getName((String)destPath);
        StagedNode srcParent = this.getStagedNode(srcParentPath, false);
        if (srcParent == null) {
            ChildNodeEntry entry = this.getStoredNode(srcParentPath).getChildNodeEntry(srcNodeName);
            if (entry == null) {
                throw new NotFoundException(srcPath);
            }
            StagedNode destParent = this.getStagedNode(destParentPath, true);
            if (destParent.getChildNodeEntry(destNodeName) != null) {
                throw new Exception("node already exists at copy destination path: " + destPath);
            }
            destParent.add(new ChildNodeEntry(destNodeName, entry.getId()));
            return;
        }
        ChildNodeEntry srcEntry = srcParent.getChildNodeEntry(srcNodeName);
        if (srcEntry == null) {
            throw new NotFoundException(srcPath);
        }
        StagedNode destParent = this.getStagedNode(destParentPath, true);
        StagedNode srcNode = this.getStagedNode(srcPath, false);
        if (srcNode != null) {
            destParent.add(destNodeName, srcNode.copy());
        } else {
            destParent.add(new ChildNodeEntry(destNodeName, srcEntry.getId()));
        }
    }

    private StagedNode getStagedNode(String path, boolean createIfNotStaged) throws Exception {
        assert (PathUtils.isAbsolute((String)path));
        if (this.root == null) {
            if (!createIfNotStaged) {
                return null;
            }
            this.root = new StagedNode(this.store.getRootNode(this.baseRevisionId), this.store);
        }
        if (PathUtils.denotesRoot((String)path)) {
            return this.root;
        }
        StagedNode parent = this.root;
        StagedNode node = null;
        for (String name : PathUtils.elements((String)path)) {
            node = parent.getStagedChildNode(name, createIfNotStaged);
            if (node == null) {
                return null;
            }
            parent = node;
        }
        return node;
    }

    private StagedNode unstageNode(String path) throws Exception {
        assert (PathUtils.isAbsolute((String)path));
        if (PathUtils.denotesRoot((String)path)) {
            StagedNode unstaged = this.root;
            this.root = null;
            return unstaged;
        }
        String parentPath = PathUtils.getParentPath((String)path);
        String name = PathUtils.getName((String)path);
        StagedNode parent = this.getStagedNode(parentPath, false);
        if (parent == null) {
            return null;
        }
        return parent.unstageChildNode(name);
    }

    private StoredNode getStoredNode(String path) throws Exception {
        assert (PathUtils.isAbsolute((String)path));
        if (PathUtils.denotesRoot((String)path)) {
            return this.store.getRootNode(this.baseRevisionId);
        }
        StoredNode parent = this.store.getRootNode(this.baseRevisionId);
        StoredNode node = null;
        for (String name : PathUtils.elements((String)path)) {
            ChildNodeEntry entry = parent.getChildNodeEntry(name);
            if (entry == null) {
                throw new NotFoundException(path);
            }
            node = this.store.getNode(entry.getId());
            if (node == null) {
                throw new NotFoundException(path);
            }
            parent = node;
        }
        return node;
    }

    private void mergeNode(StoredNode baseNode, StoredNode ourNode, StoredNode theirNode, String path) throws Exception {
        NodeDelta theirChanges = new NodeDelta(this.store, this.store.getNodeState(baseNode), this.store.getNodeState(theirNode));
        NodeDelta ourChanges = new NodeDelta(this.store, this.store.getNodeState(baseNode), this.store.getNodeState(ourNode));
        StagedNode stagedNode = this.getStagedNode(path, true);
        stagedNode.getProperties().putAll(ourChanges.getAddedProperties());
        stagedNode.getProperties().putAll(ourChanges.getChangedProperties());
        for (String string : ourChanges.getRemovedProperties().keySet()) {
            stagedNode.getProperties().remove(string);
        }
        for (Map.Entry entry : ourChanges.getAddedChildNodes().entrySet()) {
            stagedNode.add(new ChildNodeEntry((String)entry.getKey(), (Id)entry.getValue()));
        }
        for (Map.Entry entry : ourChanges.getChangedChildNodes().entrySet()) {
            if (theirChanges.getChangedChildNodes().containsKey(entry.getKey())) continue;
            stagedNode.add(new ChildNodeEntry((String)entry.getKey(), (Id)entry.getValue()));
        }
        for (String string : ourChanges.getRemovedChildNodes().keySet()) {
            stagedNode.remove(string);
        }
        List<NodeDelta.Conflict> conflicts = theirChanges.listConflicts(ourChanges);
        for (NodeDelta.Conflict conflict : conflicts) {
            String conflictName = conflict.getName();
            String conflictPath = PathUtils.concat((String)path, (String)conflictName);
            switch (conflict.getType()) {
                case PROPERTY_VALUE_CONFLICT: {
                    throw new Exception("concurrent modification of property " + conflictPath + " with conflicting values: \"" + ourNode.getProperties().get(conflictName) + "\", \"" + theirNode.getProperties().get(conflictName));
                }
                case NODE_CONTENT_CONFLICT: {
                    if (ourChanges.getChangedChildNodes().containsKey(conflictName)) {
                        StoredNode baseChild = this.store.getNode(baseNode.getChildNodeEntry(conflictName).getId());
                        StoredNode ourChild = this.store.getNode(ourNode.getChildNodeEntry(conflictName).getId());
                        StoredNode theirChild = this.store.getNode(theirNode.getChildNodeEntry(conflictName).getId());
                        this.mergeNode(baseChild, ourChild, theirChild, PathUtils.concat((String)path, (String)conflictName));
                        break;
                    }
                    throw new Exception("colliding concurrent node creation: " + conflictPath);
                }
                case REMOVED_DIRTY_PROPERTY_CONFLICT: {
                    stagedNode.getProperties().remove(conflictName);
                    break;
                }
                case REMOVED_DIRTY_NODE_CONFLICT: {
                    stagedNode.remove(conflictName);
                }
            }
        }
    }

    private class StagedNode
    extends MutableNode {
        private final Map<String, StagedNode> stagedChildNodes;

        private StagedNode(RevisionStore store) {
            super(store);
            this.stagedChildNodes = new HashMap<String, StagedNode>();
        }

        private StagedNode(Node base, RevisionStore store) {
            super(base, store);
            this.stagedChildNodes = new HashMap<String, StagedNode>();
        }

        StagedNode getStagedChildNode(String name, boolean createIfNotStaged) throws Exception {
            StagedNode child = this.stagedChildNodes.get(name);
            if (child == null) {
                ChildNodeEntry entry = this.getChildNodeEntry(name);
                if (entry != null) {
                    if (createIfNotStaged) {
                        child = new StagedNode(StagedNodeTree.this.store.getNode(entry.getId()), StagedNodeTree.this.store);
                        this.stagedChildNodes.put(name, child);
                    }
                } else {
                    throw new NotFoundException(name);
                }
            }
            return child;
        }

        StagedNode unstageChildNode(String name) {
            return this.stagedChildNodes.remove(name);
        }

        StagedNode add(String name, StagedNode node) {
            this.stagedChildNodes.put(name, node);
            this.add(new ChildNodeEntry(name, null));
            return node;
        }

        StagedNode copy() {
            StagedNode copy = new StagedNode(this, StagedNodeTree.this.store);
            for (Map.Entry<String, StagedNode> entry : this.stagedChildNodes.entrySet()) {
                copy.add(entry.getKey(), entry.getValue().copy());
            }
            return copy;
        }

        StagedNode add(String name, JsonObject obj) {
            StagedNode node = new StagedNode(StagedNodeTree.this.store);
            node.getProperties().putAll(obj.getProperties());
            for (Map.Entry entry : obj.getChildren().entrySet()) {
                node.add((String)entry.getKey(), (JsonObject)entry.getValue());
            }
            this.stagedChildNodes.put(name, node);
            this.add(new ChildNodeEntry(name, null));
            return node;
        }

        void move(String name, String destPath) throws Exception {
            ChildNodeEntry srcEntry = this.getChildNodeEntry(name);
            assert (srcEntry != null);
            String destParentPath = PathUtils.getParentPath((String)destPath);
            String destName = PathUtils.getName((String)destPath);
            StagedNode destParent = StagedNodeTree.this.getStagedNode(destParentPath, true);
            StagedNode target = this.stagedChildNodes.get(name);
            this.remove(name);
            destParent.add(new ChildNodeEntry(destName, srcEntry.getId()));
            if (target != null) {
                destParent.add(destName, target);
            }
        }

        @Override
        public ChildNodeEntry remove(String name) {
            this.stagedChildNodes.remove(name);
            return super.remove(name);
        }

        @Override
        public ChildNodeEntry rename(String oldName, String newName) {
            StagedNode child = this.stagedChildNodes.remove(oldName);
            if (child != null) {
                this.stagedChildNodes.put(newName, child);
            }
            return super.rename(oldName, newName);
        }

        Id persist(RevisionStore.PutToken token) throws Exception {
            for (Map.Entry<String, StagedNode> entry : this.stagedChildNodes.entrySet()) {
                String name = entry.getKey();
                StagedNode childNode = entry.getValue();
                Id id = childNode.persist(token);
                this.add(new ChildNodeEntry(name, id));
            }
            return StagedNodeTree.this.store.putNode(token, this);
        }
    }
}

