/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl;

import java.io.InputStream;
import java.util.UUID;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.blobs.BlobStore;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.util.NodeFilter;
import org.apache.jackrabbit.mongomk.api.NodeStore;
import org.apache.jackrabbit.mongomk.api.model.Commit;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.mongomk.impl.MongoConnection;
import org.apache.jackrabbit.mongomk.impl.json.JsonUtil;
import org.apache.jackrabbit.mongomk.impl.model.CommitBuilder;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.tree.MongoNodeState;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class MongoMicroKernel
implements MicroKernel {
    private final MongoConnection mongoConnection;
    private final BlobStore blobStore;
    private final NodeStore nodeStore;

    public MongoMicroKernel(MongoConnection mongoConnection, NodeStore nodeStore, BlobStore blobStore) {
        this.mongoConnection = mongoConnection;
        this.nodeStore = nodeStore;
        this.blobStore = blobStore;
    }

    public void dispose() {
        this.mongoConnection.close();
    }

    public BlobStore getBlobStore() {
        return this.blobStore;
    }

    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    public String branch(String trunkRevisionId) throws MicroKernelException {
        String revId = trunkRevisionId == null ? this.getHeadRevision() : trunkRevisionId;
        try {
            MongoCommit commit = (MongoCommit)CommitBuilder.build("", "", revId, "This is an autogenerated initial commit");
            commit.setBranchId(revId + "-" + UUID.randomUUID().toString());
            return this.nodeStore.commit(commit);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String commit(String path, String jsonDiff, String revisionId, String message) throws MicroKernelException {
        if (path.length() > 0 && !PathUtils.isAbsolute((String)path)) {
            throw new IllegalArgumentException("Absolute path expected: " + path);
        }
        if (jsonDiff == null || jsonDiff.length() == 0) {
            return this.getHeadRevision();
        }
        try {
            Commit commit = CommitBuilder.build(path, jsonDiff, revisionId, message);
            return this.nodeStore.commit(commit);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String diff(String fromRevisionId, String toRevisionId, String path, int depth) throws MicroKernelException {
        try {
            return this.nodeStore.diff(fromRevisionId, toRevisionId, path, depth);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public long getChildNodeCount(String path, String revisionId) throws MicroKernelException {
        Node node;
        try {
            node = this.nodeStore.getNodes(path, revisionId, 0, 0L, -1, null);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
        if (node != null) {
            return node.getChildNodeCount();
        }
        throw new MicroKernelException("Path " + path + " not found in revision " + revisionId);
    }

    public String getHeadRevision() throws MicroKernelException {
        try {
            return this.nodeStore.getHeadRevision();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String getJournal(String fromRevisionId, String toRevisionId, String path) throws MicroKernelException {
        try {
            return this.nodeStore.getJournal(fromRevisionId, toRevisionId, path);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public long getLength(String blobId) throws MicroKernelException {
        try {
            return this.blobStore.getBlobLength(blobId);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) throws MicroKernelException {
        NodeFilter nodeFilter;
        NodeFilter nodeFilter2 = nodeFilter = filter == null || filter.isEmpty() ? null : NodeFilter.parse((String)filter);
        if (offset > 0L && nodeFilter != null && nodeFilter.getChildNodeFilter() != null) {
            throw new IllegalArgumentException("offset > 0 with child node filter");
        }
        try {
            Node rootNode = this.nodeStore.getNodes(path, revisionId, depth, offset, maxChildNodes, filter);
            if (rootNode == null) {
                return null;
            }
            JsopBuilder builder = new JsopBuilder().object();
            JsonUtil.toJson(builder, new MongoNodeState(rootNode), depth, (int)offset, maxChildNodes, true, nodeFilter);
            return builder.endObject().toString();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String getRevisionHistory(long since, int maxEntries, String path) throws MicroKernelException {
        try {
            return this.nodeStore.getRevisionHistory(since, maxEntries, path);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String merge(String branchRevisionId, String message) throws MicroKernelException {
        try {
            return this.nodeStore.merge(branchRevisionId, message);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public boolean nodeExists(String path, String revisionId) throws MicroKernelException {
        try {
            return this.nodeStore.nodeExists(path, revisionId);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public int read(String blobId, long pos, byte[] buff, int off, int length) throws MicroKernelException {
        try {
            return this.blobStore.readBlob(blobId, pos, buff, off, length);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String waitForCommit(String oldHeadRevisionId, long timeout) throws MicroKernelException, InterruptedException {
        try {
            return this.nodeStore.waitForCommit(oldHeadRevisionId, timeout);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String write(InputStream in) throws MicroKernelException {
        try {
            return this.blobStore.writeBlob(in);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }
}

