/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.Map;
import org.apache.jackrabbit.mk.util.SimpleLRUCache;
import org.apache.jackrabbit.mongomk.api.NodeStore;
import org.apache.jackrabbit.mongomk.api.command.CommandExecutor;
import org.apache.jackrabbit.mongomk.api.model.Commit;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitAction;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.impl.command.CommitCommandNew;
import org.apache.jackrabbit.mongomk.impl.command.DefaultCommandExecutor;
import org.apache.jackrabbit.mongomk.impl.command.DiffCommand;
import org.apache.jackrabbit.mongomk.impl.command.GetHeadRevisionCommand;
import org.apache.jackrabbit.mongomk.impl.command.GetJournalCommand;
import org.apache.jackrabbit.mongomk.impl.command.GetNodesCommandNew;
import org.apache.jackrabbit.mongomk.impl.command.GetRevisionHistoryCommand;
import org.apache.jackrabbit.mongomk.impl.command.MergeCommand;
import org.apache.jackrabbit.mongomk.impl.command.NodeExistsCommand;
import org.apache.jackrabbit.mongomk.impl.command.OneLevelDiffCommand;
import org.apache.jackrabbit.mongomk.impl.command.WaitForCommitCommand;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.MongoNode;
import org.apache.jackrabbit.mongomk.impl.model.MongoSync;
import org.apache.jackrabbit.mongomk.util.MongoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoNodeStore
implements NodeStore {
    public static final String INITIAL_COMMIT_MESSAGE = "This is an autogenerated initial commit";
    public static final String INITIAL_COMMIT_PATH = "";
    public static final String INITIAL_COMMIT_DIFF = "+\"/\" : {}";
    public static final String COLLECTION_COMMITS = "commits";
    public static final String COLLECTION_NODES = "nodes";
    public static final String COLLECTION_SYNC = "sync";
    private static final int COMMIT_CACHE_SIZE;
    private static final int NODE_CACHE_SIZE;
    private static final Logger LOG;
    private final CommandExecutor commandExecutor;
    private final DB db;
    private Map<Long, MongoCommit> commitCache = Collections.synchronizedMap(SimpleLRUCache.newInstance((int)COMMIT_CACHE_SIZE));
    private Map<String, MongoNode> nodeCache = Collections.synchronizedMap(SimpleLRUCache.newInstance((int)NODE_CACHE_SIZE));

    public MongoNodeStore(DB db) {
        this.commandExecutor = new DefaultCommandExecutor();
        this.db = db;
        this.init();
    }

    @Override
    public String commit(Commit commit) throws Exception {
        CommitCommandNew command = new CommitCommandNew(this, commit);
        Long revisionId = this.commandExecutor.execute(command);
        return MongoUtil.fromMongoRepresentation(revisionId);
    }

    @Override
    public String diff(String fromRevision, String toRevision, String path, int depth) throws Exception {
        BaseCommand command = depth == 0 ? new OneLevelDiffCommand(this, fromRevision, toRevision, path) : new DiffCommand(this, fromRevision, toRevision, path, depth);
        return this.commandExecutor.execute(command);
    }

    @Override
    public String getHeadRevision() throws Exception {
        GetHeadRevisionCommand command = new GetHeadRevisionCommand(this);
        long revisionId = this.commandExecutor.execute(command);
        return MongoUtil.fromMongoRepresentation(revisionId);
    }

    @Override
    public Node getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) throws Exception {
        GetNodesCommandNew command = new GetNodesCommandNew(this, path, MongoUtil.toMongoRepresentation(revisionId));
        command.setBranchId(this.getBranchId(revisionId));
        command.setDepth(depth);
        return this.commandExecutor.execute(command);
    }

    @Override
    public String merge(String branchRevisionId, String message) throws Exception {
        MergeCommand command = new MergeCommand(this, branchRevisionId, message);
        return this.commandExecutor.execute(command);
    }

    @Override
    public boolean nodeExists(String path, String revisionId) throws Exception {
        NodeExistsCommand command = new NodeExistsCommand(this, path, MongoUtil.toMongoRepresentation(revisionId));
        String branchId = this.getBranchId(revisionId);
        command.setBranchId(branchId);
        return this.commandExecutor.execute(command);
    }

    @Override
    public String getJournal(String fromRevisionId, String toRevisionId, String path) throws Exception {
        GetJournalCommand command = new GetJournalCommand(this, fromRevisionId, toRevisionId, path);
        return this.commandExecutor.execute(command);
    }

    @Override
    public String getRevisionHistory(long since, int maxEntries, String path) throws Exception {
        GetRevisionHistoryCommand command = new GetRevisionHistoryCommand(this, since, maxEntries, path);
        return this.commandExecutor.execute(command);
    }

    @Override
    public String waitForCommit(String oldHeadRevisionId, long timeout) throws Exception {
        WaitForCommitCommand command = new WaitForCommitCommand(this, oldHeadRevisionId, timeout);
        long revisionId = this.commandExecutor.execute(command);
        return MongoUtil.fromMongoRepresentation(revisionId);
    }

    public DBCollection getCommitCollection() {
        DBCollection commitCollection = this.db.getCollection(COLLECTION_COMMITS);
        commitCollection.setObjectClass(MongoCommit.class);
        return commitCollection;
    }

    public DBCollection getSyncCollection() {
        DBCollection syncCollection = this.db.getCollection(COLLECTION_SYNC);
        syncCollection.setObjectClass(MongoSync.class);
        return syncCollection;
    }

    public DBCollection getNodeCollection() {
        DBCollection nodeCollection = this.db.getCollection(COLLECTION_NODES);
        nodeCollection.setObjectClass(MongoNode.class);
        return nodeCollection;
    }

    public void cache(Commit commit) {
        LOG.debug("Adding commit {} to cache", (Object)commit.getRevisionId());
        this.commitCache.put(commit.getRevisionId(), (MongoCommit)commit);
    }

    public void evict(MongoCommit commit) {
        if (this.commitCache.remove(commit.getRevisionId()) != null) {
            LOG.debug("Removed commit {} from cache", (Object)commit.getRevisionId());
        }
    }

    public MongoCommit getFromCache(long revisionId) {
        MongoCommit commit = this.commitCache.get(revisionId);
        if (commit != null) {
            LOG.debug("Returning commit {} from cache", (Object)revisionId);
        }
        return commit;
    }

    public void cache(MongoNode node) {
        long revisionId = node.getRevisionId();
        String path = node.getPath();
        String branchId = node.getBranchId();
        String key = path + "*" + branchId + "*" + revisionId;
        if (!this.nodeCache.containsKey(key)) {
            LOG.debug("Adding node to cache: {}", (Object)key);
            this.nodeCache.put(key, node.copy());
        }
    }

    public MongoNode getFromCache(String path, String branchId, long revisionId) {
        String key = path + "*" + branchId + "*" + revisionId;
        MongoNode node = this.nodeCache.get(key);
        if (node == null) {
            return null;
        }
        LOG.debug("Returning node from cache: {}", (Object)key);
        return node.copy();
    }

    private void init() {
        this.initCommitCollection();
        this.initNodeCollection();
        this.initSyncCollection();
    }

    private void initCommitCollection() {
        if (this.db.collectionExists(COLLECTION_COMMITS)) {
            return;
        }
        DBCollection commitCollection = this.getCommitCollection();
        BasicDBObject index = new BasicDBObject();
        index.put("revId", (Object)1L);
        index.put("branchId", (Object)1L);
        BasicDBObject options = new BasicDBObject();
        options.put("unique", (Object)Boolean.TRUE);
        commitCollection.ensureIndex((DBObject)index, (DBObject)options);
        MongoCommit commit = new MongoCommit();
        commit.setAffectedPaths(Collections.singleton("/"));
        commit.setBaseRevisionId(0L);
        commit.setDiff(INITIAL_COMMIT_DIFF);
        commit.setMessage(INITIAL_COMMIT_MESSAGE);
        commit.setRevisionId(0L);
        commit.setPath(INITIAL_COMMIT_PATH);
        commitCollection.insert(new DBObject[]{commit});
    }

    private void initNodeCollection() {
        if (this.db.collectionExists(COLLECTION_NODES)) {
            return;
        }
        DBCollection nodeCollection = this.getNodeCollection();
        BasicDBObject index = new BasicDBObject();
        index.put("path", (Object)1L);
        index.put("revId", (Object)-1L);
        index.put("branchId", (Object)1L);
        BasicDBObject options = new BasicDBObject();
        options.put("unique", (Object)Boolean.TRUE);
        nodeCollection.ensureIndex((DBObject)index, (DBObject)options);
        MongoNode root = new MongoNode();
        root.setRevisionId(0L);
        root.setPath("/");
        nodeCollection.insert(new DBObject[]{root});
    }

    private void initSyncCollection() {
        if (this.db.collectionExists(COLLECTION_SYNC)) {
            return;
        }
        DBCollection headCollection = this.getSyncCollection();
        MongoSync headMongo = new MongoSync();
        headMongo.setHeadRevisionId(0L);
        headMongo.setNextRevisionId(1L);
        headCollection.insert(new DBObject[]{headMongo});
    }

    private String getBranchId(String revisionId) throws Exception {
        if (revisionId == null) {
            return null;
        }
        MongoCommit baseCommit = new FetchCommitAction(this, MongoUtil.toMongoRepresentation(revisionId)).execute();
        return baseCommit.getBranchId();
    }

    static {
        int commitCacheSize = 1000;
        try {
            commitCacheSize = Integer.parseInt(System.getProperty("mongomk.commitCacheSize", INITIAL_COMMIT_PATH + commitCacheSize));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        COMMIT_CACHE_SIZE = commitCacheSize;
        int nodeCacheSize = 10000;
        try {
            nodeCacheSize = Integer.parseInt(System.getProperty("mongomk.nodeCacheSize", INITIAL_COMMIT_PATH + nodeCacheSize));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        NODE_CACHE_SIZE = nodeCacheSize;
        LOG = LoggerFactory.getLogger(MongoNodeStore.class);
    }
}

