/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.action;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.BaseAction;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitsAction;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.MongoNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchNodesAction
extends BaseAction<Map<String, MongoNode>> {
    public static final int LIMITLESS_DEPTH = -1;
    private static final Logger LOG = LoggerFactory.getLogger(FetchNodesAction.class);
    private final Set<String> paths;
    private long revisionId = -1L;
    private String branchId;
    private List<MongoCommit> validCommits;
    private int depth = -1;

    public FetchNodesAction(MongoNodeStore nodeStore, String path, long revisionId) {
        super(nodeStore);
        this.paths = new HashSet<String>();
        this.paths.add(path);
        this.revisionId = revisionId;
    }

    public FetchNodesAction(MongoNodeStore nodeStore, Set<String> paths, long revisionId) {
        super(nodeStore);
        this.paths = paths;
        this.revisionId = revisionId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public void setValidCommits(List<MongoCommit> validCommits) {
        this.validCommits = validCommits;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public Map<String, MongoNode> execute() {
        if (this.paths.isEmpty()) {
            return Collections.emptyMap();
        }
        DBCursor dbCursor = this.performQuery();
        return this.getMostRecentValidNodes(dbCursor);
    }

    private DBCursor performQuery() {
        QueryBuilder queryBuilder = QueryBuilder.start((String)"path");
        if (this.paths.size() > 1) {
            queryBuilder = queryBuilder.in(this.paths);
        } else {
            String path = this.paths.toArray(new String[0])[0];
            if (this.depth == 0) {
                queryBuilder = queryBuilder.is((Object)path);
            } else {
                Pattern pattern = this.createPrefixRegExp(path);
                queryBuilder = queryBuilder.regex(pattern);
            }
        }
        if (this.revisionId > -1L) {
            queryBuilder = queryBuilder.and("revId").lessThanEquals((Object)this.revisionId);
        }
        if (this.branchId == null) {
            BasicDBObject query = new BasicDBObject("branchId", (Object)new BasicDBObject("$exists", (Object)false));
            queryBuilder = queryBuilder.and(new DBObject[]{query});
        } else {
            long headBranchRevisionId = Long.parseLong(this.branchId.substring(0, this.branchId.indexOf("-")));
            DBObject branchQuery = QueryBuilder.start().or(new DBObject[]{QueryBuilder.start((String)"branchId").is((Object)this.branchId).get(), QueryBuilder.start((String)"revId").lessThanEquals((Object)headBranchRevisionId).get()}).get();
            queryBuilder = queryBuilder.and(new DBObject[]{branchQuery});
        }
        BasicDBObject orderBy = new BasicDBObject();
        orderBy.put("path", (Object)1);
        orderBy.put("revId", (Object)-1);
        DBObject query = queryBuilder.get();
        LOG.debug("Executing query: {}", (Object)query);
        return this.nodeStore.getNodeCollection().find(query).sort((DBObject)orderBy);
    }

    private Pattern createPrefixRegExp(String path) {
        StringBuilder regex = new StringBuilder();
        regex.append("^");
        if (!"/".equals(path)) {
            regex.append(Pattern.quote(path));
        }
        regex.append("(/[^/]*)");
        regex.append("{0,");
        if (this.depth > 0) {
            regex.append(this.depth);
        }
        regex.append("}$");
        return Pattern.compile(regex.toString());
    }

    private Map<String, MongoNode> getMostRecentValidNodes(DBCursor dbCursor) {
        if (this.validCommits == null) {
            this.validCommits = new FetchCommitsAction(this.nodeStore, this.revisionId).execute();
        }
        List<Long> validRevisions = this.extractRevisionIds(this.validCommits);
        HashMap<String, MongoNode> nodeMongos = new HashMap<String, MongoNode>();
        while (dbCursor.hasNext()) {
            MongoNode nodeMongo = (MongoNode)dbCursor.next();
            String path = nodeMongo.getPath();
            long revisionId = nodeMongo.getRevisionId();
            LOG.debug("Converting node {} ({})", (Object)path, (Object)revisionId);
            if (!validRevisions.contains(revisionId)) {
                LOG.debug("Node will not be converted as it is not a valid commit {} ({})", (Object)path, (Object)revisionId);
                continue;
            }
            if (nodeMongos.containsKey(path)) {
                LOG.debug("Converted nodes @{} with path {} was not put into map because a newer version is available", (Object)revisionId, (Object)path);
                continue;
            }
            nodeMongos.put(path, nodeMongo);
            LOG.debug("Converted node @{} with path {} was put into map", (Object)revisionId, (Object)path);
        }
        dbCursor.close();
        return nodeMongos;
    }

    private List<Long> extractRevisionIds(List<MongoCommit> validCommits) {
        ArrayList<Long> validRevisions = new ArrayList<Long>(validCommits.size());
        for (MongoCommit commitMongo : validCommits) {
            validRevisions.add(commitMongo.getRevisionId());
        }
        return validRevisions;
    }
}

