/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.action;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.BaseAction;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitAction;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.MongoNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchNodesActionNew
extends BaseAction<Map<String, MongoNode>> {
    public static final int LIMITLESS_DEPTH = -1;
    private static final Logger LOG = LoggerFactory.getLogger(FetchNodesActionNew.class);
    private final Set<String> paths;
    private long revisionId = -1L;
    private String branchId;
    private int depth = -1;

    public FetchNodesActionNew(MongoNodeStore nodeStore, String path, int depth, long revisionId) {
        super(nodeStore);
        this.paths = new HashSet<String>();
        this.paths.add(path);
        this.depth = depth;
        this.revisionId = revisionId;
    }

    public FetchNodesActionNew(MongoNodeStore nodeStore, Set<String> paths, long revisionId) {
        super(nodeStore);
        this.paths = paths;
        this.revisionId = revisionId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    @Override
    public Map<String, MongoNode> execute() {
        String path;
        MongoNode node;
        if (this.paths.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.paths.size() == 1 && this.depth == 0 && (node = this.nodeStore.getFromCache(path = this.paths.toArray(new String[0])[0], this.branchId, this.revisionId)) != null) {
            HashMap<String, MongoNode> nodes = new HashMap<String, MongoNode>();
            nodes.put(node.getPath(), node);
            return nodes;
        }
        DBCursor dbCursor = this.performQuery();
        Map<String, MongoNode> nodes = this.getMostRecentValidNodes(dbCursor);
        for (MongoNode node2 : nodes.values()) {
            this.nodeStore.cache(node2);
        }
        return nodes;
    }

    private DBCursor performQuery() {
        QueryBuilder queryBuilder = QueryBuilder.start((String)"path");
        if (this.paths.size() > 1) {
            queryBuilder = queryBuilder.in(this.paths);
        } else {
            String path = this.paths.toArray(new String[0])[0];
            if (this.depth == 0) {
                queryBuilder = queryBuilder.is((Object)path);
            } else {
                Pattern pattern = this.createPrefixRegExp(path);
                queryBuilder = queryBuilder.regex(pattern);
            }
        }
        if (this.revisionId > -1L) {
            queryBuilder = queryBuilder.and("revId").lessThanEquals((Object)this.revisionId);
        }
        if (this.branchId == null) {
            BasicDBObject query = new BasicDBObject("branchId", (Object)new BasicDBObject("$exists", (Object)false));
            queryBuilder = queryBuilder.and(new DBObject[]{query});
        } else {
            long headBranchRevisionId = Long.parseLong(this.branchId.substring(0, this.branchId.indexOf("-")));
            DBObject branchQuery = QueryBuilder.start().or(new DBObject[]{QueryBuilder.start((String)"branchId").is((Object)this.branchId).get(), QueryBuilder.start().and(new DBObject[]{QueryBuilder.start((String)"revId").lessThanEquals((Object)headBranchRevisionId).get(), new BasicDBObject("branchId", (Object)new BasicDBObject("$exists", (Object)false))}).get()}).get();
            queryBuilder = queryBuilder.and(new DBObject[]{branchQuery});
        }
        BasicDBObject orderBy = new BasicDBObject();
        orderBy.put("path", (Object)1);
        orderBy.put("revId", (Object)-1);
        DBObject query = queryBuilder.get();
        LOG.debug("Executing query: {}", (Object)query);
        return this.nodeStore.getNodeCollection().find(query).sort((DBObject)orderBy);
    }

    private Pattern createPrefixRegExp(String path) {
        StringBuilder regex = new StringBuilder();
        regex.append("^");
        if (!"/".equals(path)) {
            regex.append(Pattern.quote(path));
        }
        regex.append("(/[^/]*)");
        regex.append("{0,");
        if (this.depth > 0) {
            regex.append(this.depth);
        }
        regex.append("}$");
        return Pattern.compile(regex.toString());
    }

    private Map<String, MongoNode> getMostRecentValidNodes(DBCursor dbCursor) {
        int numberOfNodesToFetch = -1;
        if (this.paths.size() > 1) {
            numberOfNodesToFetch = this.paths.size();
        } else if (this.depth == 0) {
            numberOfNodesToFetch = 1;
        }
        HashMap<String, MongoNode> nodes = new HashMap<String, MongoNode>();
        HashMap<Long, MongoCommit> commits = new HashMap<Long, MongoCommit>();
        while (dbCursor.hasNext() && (numberOfNodesToFetch == -1 || nodes.size() < numberOfNodesToFetch)) {
            MongoNode node = (MongoNode)dbCursor.next();
            String path = node.getPath();
            if (nodes.containsKey(path)) {
                LOG.debug("Converted node @{} with path {} was not put into map because a newer version is available", (Object)node.getRevisionId(), (Object)path);
                continue;
            }
            long revisionId = node.getRevisionId();
            LOG.debug("Converting node {} (@{})", (Object)path, (Object)revisionId);
            if (!commits.containsKey(revisionId) && this.nodeStore.getFromCache(revisionId) == null) {
                LOG.debug("Fetching commit @{}", (Object)revisionId);
                FetchCommitAction action = new FetchCommitAction(this.nodeStore, revisionId);
                try {
                    MongoCommit commit = action.execute();
                    commits.put(revisionId, commit);
                }
                catch (Exception e) {
                    LOG.debug("Node will not be converted as it is not part of a valid commit {} ({})", (Object)path, (Object)revisionId);
                    continue;
                }
            }
            nodes.put(path, node);
            LOG.debug("Converted node @{} with path {} was put into map", (Object)revisionId, (Object)path);
        }
        dbCursor.close();
        return nodes;
    }
}

