/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.jackrabbit.mk.model.tree.DiffBuilder;
import org.apache.jackrabbit.mongomk.api.model.Commit;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitAction;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitsAction;
import org.apache.jackrabbit.mongomk.impl.action.FetchHeadRevisionIdAction;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.impl.command.CommitCommandNew;
import org.apache.jackrabbit.mongomk.impl.command.GetNodesCommandNew;
import org.apache.jackrabbit.mongomk.impl.json.JsopParser;
import org.apache.jackrabbit.mongomk.impl.json.NormalizingJsopHandler;
import org.apache.jackrabbit.mongomk.impl.model.CommitBuilder;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.NodeImpl;
import org.apache.jackrabbit.mongomk.impl.model.tree.MongoNodeDelta;
import org.apache.jackrabbit.mongomk.impl.model.tree.MongoNodeState;
import org.apache.jackrabbit.mongomk.impl.model.tree.SimpleMongoNodeStore;
import org.apache.jackrabbit.mongomk.util.MongoUtil;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeCommand
extends BaseCommand<String> {
    private static final Logger LOG = LoggerFactory.getLogger(MergeCommand.class);
    private final String branchRevisionId;
    private final String message;

    public MergeCommand(MongoNodeStore nodeStore, String branchRevisionId, String message) {
        super(nodeStore);
        this.branchRevisionId = branchRevisionId;
        this.message = message;
    }

    @Override
    public String execute() throws Exception {
        Commit newCommit;
        MongoCommit commit = new FetchCommitAction(this.nodeStore, MongoUtil.toMongoRepresentation(this.branchRevisionId)).execute();
        String branchId = commit.getBranchId();
        if (branchId == null) {
            throw new Exception("Can only merge a private branch commit");
        }
        long rootNodeId = commit.getRevisionId();
        FetchHeadRevisionIdAction query2 = new FetchHeadRevisionIdAction(this.nodeStore);
        long currentHead = query2.execute();
        long branchRootId = Long.parseLong(branchId.substring(0, branchId.indexOf("-")));
        String diff = this.getNonConflictingCommitsDiff(Math.max(currentHead, commit.getRevisionId()), branchRootId, branchId);
        if (diff != null) {
            newCommit = CommitBuilder.build("/", diff.toString(), MongoUtil.fromMongoRepresentation(currentHead), this.message);
        } else {
            Node ourRoot = this.getNode("/", rootNodeId, branchId);
            Node currentHeadNode = this.getNode("/", currentHead);
            if (currentHead != branchRootId) {
                ourRoot = this.mergeNodes(ourRoot, currentHeadNode, branchRootId);
            }
            if ((diff = new DiffBuilder(MongoUtil.wrap(currentHeadNode), MongoUtil.wrap(ourRoot), "/", -1, new SimpleMongoNodeStore(), "").build()).isEmpty()) {
                LOG.debug("Merge of empty branch {} with differing content hashes encountered, ignore and keep current head {}", (Object)this.branchRevisionId, (Object)currentHead);
                return MongoUtil.fromMongoRepresentation(currentHead);
            }
            newCommit = CommitBuilder.build("", diff, MongoUtil.fromMongoRepresentation(currentHead), this.message);
        }
        CommitCommandNew command = new CommitCommandNew(this.nodeStore, newCommit);
        long revision = (Long)command.execute();
        return MongoUtil.fromMongoRepresentation(revision);
    }

    private String getNonConflictingCommitsDiff(long currentHead, long branchRootId, String branchId) {
        FetchCommitsAction action = new FetchCommitsAction(this.nodeStore, branchRootId + 1L, currentHead);
        Object commits = action.execute();
        HashSet<String> affectedPathsBranch = new HashSet<String>();
        HashSet<String> affectedPathsTrunk = new HashSet<String>();
        StringBuilder diff = new StringBuilder();
        for (int i = commits.size() - 1; i >= 0; --i) {
            MongoCommit commit = (MongoCommit)commits.get(i);
            SortedSet<String> affectedPaths = commit.getAffectedPaths();
            for (String affectedPath : affectedPaths) {
                if (branchId.equals(commit.getBranchId())) {
                    if (affectedPathsTrunk.contains(affectedPath)) {
                        return null;
                    }
                    affectedPathsBranch.add(affectedPath);
                    continue;
                }
                if (commit.getBranchId() != null) continue;
                if (affectedPathsBranch.contains(affectedPath)) {
                    return null;
                }
                affectedPathsTrunk.add(affectedPath);
            }
            if (!branchId.equals(commit.getBranchId())) continue;
            try {
                diff.append(this.normalizeDiff(commit.getPath(), commit.getDiff()));
                continue;
            }
            catch (Exception e) {
                LOG.error("Normalization error", (Throwable)e);
            }
        }
        return diff.length() > 0 ? diff.toString() : null;
    }

    private String normalizeDiff(String path, String diff) throws Exception {
        NormalizingJsopHandler handler = new NormalizingJsopHandler();
        new JsopParser(path, diff, handler).parse();
        return handler.getDiff();
    }

    private NodeImpl mergeNodes(Node ourRoot, Node theirRoot, Long commonAncestorRevisionId) throws Exception {
        Node baseRoot = this.getNode("/", commonAncestorRevisionId);
        NodeImpl theirRootCopy = this.copy(theirRoot);
        return this.mergeNode(baseRoot, ourRoot, theirRootCopy, "/");
    }

    private NodeImpl mergeNode(Node baseNode, Node ourNode, Node theirNode, String path) throws Exception {
        MongoNodeState nodeState;
        MongoNodeDelta theirChanges = new MongoNodeDelta(new SimpleMongoNodeStore(), MongoUtil.wrap(baseNode), MongoUtil.wrap(theirNode));
        MongoNodeDelta ourChanges = new MongoNodeDelta(new SimpleMongoNodeStore(), MongoUtil.wrap(baseNode), MongoUtil.wrap(ourNode));
        NodeImpl stagedNode = (NodeImpl)theirNode;
        stagedNode.getProperties().putAll(ourChanges.getAddedProperties());
        stagedNode.getProperties().putAll(ourChanges.getChangedProperties());
        for (String string : ourChanges.getRemovedProperties().keySet()) {
            stagedNode.getProperties().remove(string);
        }
        for (Map.Entry entry : ourChanges.getAddedChildNodes().entrySet()) {
            nodeState = (MongoNodeState)entry.getValue();
            stagedNode.addChildNodeEntry(nodeState.unwrap());
        }
        for (Map.Entry entry : ourChanges.getChangedChildNodes().entrySet()) {
            if (theirChanges.getChangedChildNodes().containsKey(entry.getKey())) continue;
            nodeState = (MongoNodeState)entry.getValue();
            stagedNode.addChildNodeEntry(nodeState.unwrap());
        }
        for (String string : ourChanges.getRemovedChildNodes().keySet()) {
            stagedNode.removeChildNodeEntry(string);
        }
        List<MongoNodeDelta.Conflict> conflicts = theirChanges.listConflicts(ourChanges);
        for (MongoNodeDelta.Conflict conflict : conflicts) {
            String conflictName = conflict.getName();
            String conflictPath = PathUtils.concat((String)path, (String)conflictName);
            switch (conflict.getType()) {
                case PROPERTY_VALUE_CONFLICT: {
                    throw new Exception("concurrent modification of property " + conflictPath + " with conflicting values: \"" + ourNode.getProperties().get(conflictName) + "\", \"" + theirNode.getProperties().get(conflictName));
                }
                case NODE_CONTENT_CONFLICT: {
                    if (ourChanges.getChangedChildNodes().containsKey(conflictName)) {
                        Node baseChild = baseNode.getChildNodeEntry(conflictName);
                        Node ourChild = ourNode.getChildNodeEntry(conflictName);
                        Node theirChild = theirNode.getChildNodeEntry(conflictName);
                        this.mergeNode(baseChild, ourChild, theirChild, PathUtils.concat((String)path, (String)conflictName));
                        break;
                    }
                    throw new Exception("colliding concurrent node creation: " + conflictPath);
                }
                case REMOVED_DIRTY_PROPERTY_CONFLICT: {
                    stagedNode.getProperties().remove(conflictName);
                    break;
                }
                case REMOVED_DIRTY_NODE_CONFLICT: {
                    stagedNode.removeChildNodeEntry(conflictName);
                }
            }
        }
        return stagedNode;
    }

    private Node getNode(String path, long revisionId) throws Exception {
        return this.getNode(path, revisionId, null);
    }

    private Node getNode(String path, long revisionId, String branchId) throws Exception {
        GetNodesCommandNew command = new GetNodesCommandNew(this.nodeStore, path, revisionId);
        command.setBranchId(branchId);
        return command.execute();
    }

    private NodeImpl copy(Node node) {
        NodeImpl copy = new NodeImpl(node.getPath());
        copy.setRevisionId(node.getRevisionId());
        for (Map.Entry<String, String> entry : node.getProperties().entrySet()) {
            copy.addProperty(entry.getKey(), entry.getValue());
        }
        Iterator<Node> it = node.getChildNodeEntries(0, -1);
        while (it.hasNext()) {
            Node child = it.next();
            copy.addChildNodeEntry(this.copy(child));
        }
        return copy;
    }
}

