/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.FetchNodesActionNew;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.impl.command.GetHeadRevisionCommand;
import org.apache.jackrabbit.mongomk.impl.model.MongoNode;

public class NodeExistsCommand
extends BaseCommand<Boolean> {
    private Long revisionId;
    private String branchId;
    private String path;
    private MongoNode node;

    public NodeExistsCommand(MongoNodeStore nodeStore, String path, Long revisionId) {
        super(nodeStore);
        this.path = path;
        this.revisionId = revisionId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    @Override
    public Boolean execute() throws Exception {
        if (this.revisionId == null) {
            this.revisionId = new GetHeadRevisionCommand(this.nodeStore).execute();
        }
        FetchNodesActionNew action = new FetchNodesActionNew(this.nodeStore, this.path, 0, this.revisionId);
        action.setBranchId(this.branchId);
        Object pathAndNodeMap = action.execute();
        this.node = (MongoNode)((Object)pathAndNodeMap.get(this.path));
        if (this.node != null && this.node.isDeleted()) {
            this.node = null;
        }
        return this.node != null;
    }

    public MongoNode getNode() {
        return this.node;
    }
}

