/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.FetchHeadRevisionIdAction;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.util.MongoUtil;

public class WaitForCommitCommand
extends BaseCommand<Long> {
    private static final long WAIT_FOR_COMMIT_POLL_MILLIS = 1000L;
    private final String oldHeadRevisionId;
    private final long timeout;

    public WaitForCommitCommand(MongoNodeStore nodeStore, String oldHeadRevisionId, long timeout) {
        super(nodeStore);
        this.oldHeadRevisionId = oldHeadRevisionId;
        this.timeout = timeout;
    }

    @Override
    public Long execute() throws Exception {
        long startTimestamp = System.currentTimeMillis();
        Long initialHeadRevisionId = this.getHeadRevision();
        if (this.timeout <= 0L) {
            return initialHeadRevisionId;
        }
        Long oldHeadRevision = MongoUtil.toMongoRepresentation(this.oldHeadRevisionId);
        if (oldHeadRevision != initialHeadRevisionId) {
            return initialHeadRevisionId;
        }
        long waitForCommitPollMillis = Math.min(1000L, this.timeout);
        while (true) {
            long headRevisionId = this.getHeadRevision();
            long now = System.currentTimeMillis();
            if (headRevisionId != initialHeadRevisionId || now - startTimestamp >= this.timeout) {
                return headRevisionId;
            }
            Thread.sleep(waitForCommitPollMillis);
        }
    }

    private long getHeadRevision() throws Exception {
        FetchHeadRevisionIdAction query = new FetchHeadRevisionIdAction(this.nodeStore);
        return query.execute();
    }
}

