/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.instruction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mongomk.api.instruction.Instruction;
import org.apache.jackrabbit.mongomk.api.instruction.InstructionVisitor;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.command.NodeExistsCommand;
import org.apache.jackrabbit.mongomk.impl.exception.NotFoundException;
import org.apache.jackrabbit.mongomk.impl.instruction.CopyNodeInstructionImpl;
import org.apache.jackrabbit.mongomk.impl.instruction.RemoveNodeInstructionImpl;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.MongoNode;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class CommitCommandInstructionVisitor
implements InstructionVisitor {
    private final long baseRevisionId;
    private final MongoNodeStore nodeStore;
    private final Map<String, MongoNode> pathNodeMap;
    private String branchId;

    public CommitCommandInstructionVisitor(MongoNodeStore nodeStore, long baseRevisionId, List<MongoCommit> validCommits) {
        this.nodeStore = nodeStore;
        this.baseRevisionId = baseRevisionId;
        this.pathNodeMap = new HashMap<String, MongoNode>();
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public Map<String, MongoNode> getPathNodeMap() {
        return this.pathNodeMap;
    }

    @Override
    public void visit(Instruction.AddNodeInstruction instruction) {
        String nodePath = instruction.getPath();
        this.checkAbsolutePath(nodePath);
        String nodeName = PathUtils.getName((String)nodePath);
        if (nodeName.isEmpty()) {
            this.getStagedNode(nodePath);
            return;
        }
        String parentNodePath = PathUtils.getParentPath((String)nodePath);
        MongoNode parent = this.getStoredNode(parentNodePath);
        if (parent.childExists(nodeName)) {
            throw new RuntimeException("There's already a child node with name '" + nodeName + "'");
        }
        this.getStagedNode(nodePath);
        parent.addChild(nodeName);
    }

    @Override
    public void visit(Instruction.SetPropertyInstruction instruction) {
        String key = instruction.getKey();
        Object value = instruction.getValue();
        MongoNode node = this.getStoredNode(instruction.getPath());
        if (value == null) {
            node.removeProp(key);
        } else {
            node.addProperty(key, value);
        }
    }

    @Override
    public void visit(Instruction.RemoveNodeInstruction instruction) {
        String nodePath = instruction.getPath();
        this.checkAbsolutePath(nodePath);
        String parentPath = PathUtils.getParentPath((String)nodePath);
        String nodeName = PathUtils.getName((String)nodePath);
        MongoNode parent = this.getStoredNode(parentPath);
        if (!parent.childExists(nodeName)) {
            throw new RuntimeException("Node " + nodeName + " does not exists at parent path: " + parentPath);
        }
        parent.removeChild(nodeName);
        this.markAsDeleted(nodePath);
    }

    @Override
    public void visit(Instruction.CopyNodeInstruction instruction) {
        String srcPath = instruction.getSourcePath();
        this.checkAbsolutePath(srcPath);
        String destPath = instruction.getDestPath();
        if (!PathUtils.isAbsolute((String)destPath)) {
            destPath = PathUtils.concat((String)instruction.getPath(), (String)destPath);
            this.checkAbsolutePath(destPath);
        }
        String srcParentPath = PathUtils.getParentPath((String)srcPath);
        String srcNodeName = PathUtils.getName((String)srcPath);
        String destParentPath = PathUtils.getParentPath((String)destPath);
        String destNodeName = PathUtils.getName((String)destPath);
        MongoNode srcParent = this.getStoredNode(srcParentPath, false);
        if (!srcParent.childExists(srcNodeName)) {
            throw new NotFoundException(srcPath);
        }
        MongoNode destParent = this.getStoredNode(destParentPath);
        if (destParent.childExists(destNodeName)) {
            throw new RuntimeException("Node already exists at copy destination path: " + destPath);
        }
        this.copy(this.getStoredNode(srcPath, false), destPath);
        destParent.addChild(destNodeName);
    }

    @Override
    public void visit(Instruction.MoveNodeInstruction instruction) {
        String srcPath = instruction.getSourcePath();
        String destPath = instruction.getDestPath();
        if (destPath.startsWith(srcPath + "/")) {
            throw new RuntimeException("Cannot move " + srcPath + " to " + destPath);
        }
        this.visit(new CopyNodeInstructionImpl(instruction.getPath(), srcPath, instruction.getDestPath()));
        this.visit(new RemoveNodeInstructionImpl(PathUtils.getParentPath((String)srcPath), PathUtils.getName((String)srcPath)));
    }

    private void checkAbsolutePath(String srcPath) {
        if (!PathUtils.isAbsolute((String)srcPath)) {
            throw new RuntimeException("Absolute path expected: " + srcPath);
        }
    }

    private MongoNode getStagedNode(String path) {
        MongoNode node = this.pathNodeMap.get(path);
        if (node == null) {
            node = new MongoNode();
            node.setPath(path);
            this.pathNodeMap.put(path, node);
        }
        return node;
    }

    private MongoNode getStoredNode(String path) {
        return this.getStoredNode(path, true);
    }

    private MongoNode getStoredNode(String path, boolean addToMap) {
        MongoNode node = this.pathNodeMap.get(path);
        if (node != null) {
            return node;
        }
        NodeExistsCommand existCommand = new NodeExistsCommand(this.nodeStore, path, this.baseRevisionId);
        existCommand.setBranchId(this.branchId);
        boolean exists = false;
        try {
            exists = existCommand.execute();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (!exists) {
            throw new NotFoundException(path + " @rev" + this.baseRevisionId);
        }
        node = existCommand.getNode();
        node.removeField("_id");
        if (addToMap) {
            this.pathNodeMap.put(path, node);
        }
        return node;
    }

    private void copy(MongoNode srcNode, String destPath) {
        MongoNode destNode = srcNode.copy();
        destNode.setPath(destPath);
        destNode.removeField("_id");
        this.copyAddedProperties(srcNode, destNode);
        this.copyRemovedProperties(srcNode, destNode);
        this.pathNodeMap.put(destPath, destNode);
        ArrayList<String> children = new ArrayList<String>();
        if (srcNode.getChildren() != null) {
            children.addAll(srcNode.getChildren());
        }
        if (srcNode.getRemovedChildren() != null) {
            for (String child : srcNode.getRemovedChildren()) {
                destNode.removeChild(child);
                children.remove(child);
            }
        }
        if (srcNode.getAddedChildren() != null) {
            for (String child : srcNode.getAddedChildren()) {
                destNode.addChild(child);
                children.add(child);
            }
        }
        for (String child : children) {
            String srcChildPath = PathUtils.concat((String)srcNode.getPath(), (String)child);
            String destChildPath = PathUtils.concat((String)destPath, (String)child);
            this.copy(this.getStoredNode(srcChildPath, false), destChildPath);
        }
    }

    private void copyAddedProperties(MongoNode srcNode, MongoNode destNode) {
        Map<String, Object> addedProps = srcNode.getAddedProps();
        if (addedProps == null || addedProps.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : addedProps.entrySet()) {
            destNode.addProperty(entry.getKey(), entry.getValue());
        }
    }

    private void copyRemovedProperties(MongoNode srcNode, MongoNode destNode) {
        Map<String, Object> removedProps = srcNode.getRemovedProps();
        if (removedProps == null || removedProps.isEmpty()) {
            return;
        }
        for (String key : removedProps.keySet()) {
            destNode.removeProp(key);
        }
    }

    private void markAsDeleted(String path) {
        MongoNode node = this.getStoredNode(path);
        node.setDeleted(true);
        ArrayList<String> children = new ArrayList<String>();
        if (node.getChildren() != null) {
            children.addAll(node.getChildren());
        }
        if (node.getAddedChildren() != null) {
            children.addAll(node.getAddedChildren());
        }
        for (String child : children) {
            this.markAsDeleted(PathUtils.concat((String)path, (String)child));
        }
        this.pathNodeMap.put(path, node);
    }
}

