/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.json;

import com.mongodb.BasicDBList;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.model.tree.ChildNode;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mk.model.tree.PropertyState;
import org.apache.jackrabbit.mk.util.NameFilter;
import org.apache.jackrabbit.mk.util.NodeFilter;
import org.apache.jackrabbit.mongomk.util.MongoUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonUtil {
    public static Object toJsonValue(String jsonValue) throws Exception {
        if (jsonValue == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject("{dummy : " + jsonValue + "}");
        Object obj = jsonObject.get("dummy");
        return JsonUtil.convertJsonValue(obj);
    }

    private static Object convertJsonValue(Object jsonObject) throws Exception {
        if (jsonObject == JSONObject.NULL) {
            return null;
        }
        if (jsonObject instanceof JSONArray) {
            BasicDBList elements = new BasicDBList();
            JSONArray dummyArray = (JSONArray)jsonObject;
            for (int i = 0; i < dummyArray.length(); ++i) {
                Object raw = dummyArray.get(i);
                Object parsed = JsonUtil.convertJsonValue(raw);
                elements.add(parsed);
            }
            return elements;
        }
        return jsonObject;
    }

    public static void toJson(JsopBuilder builder, NodeState node, int depth, int offset, int maxChildNodes, boolean inclVirtualProps, NodeFilter filter) {
        NameFilter childFilter;
        for (PropertyState propertyState : node.getProperties()) {
            if (filter != null && !filter.includeProperty(propertyState.getName())) continue;
            String propertyName = propertyState.getName();
            builder.key(MongoUtil.fromMongoPropertyKey(propertyName)).encodedValue(propertyState.getEncodedValue());
        }
        long childCount = node.getChildNodeCount();
        if (inclVirtualProps && (filter == null || filter.includeProperty(":childNodeCount"))) {
            builder.key(":childNodeCount").value(childCount);
        }
        if (childCount <= 0L || depth < 0) {
            return;
        }
        if (filter != null && (childFilter = filter.getChildNodeFilter()) != null && !childFilter.containsWildcard()) {
            int count = maxChildNodes == -1 ? Integer.MAX_VALUE : maxChildNodes;
            for (String string : childFilter.getInclusionPatterns()) {
                NodeState child = node.getChildNode(string);
                if (child == null) continue;
                boolean incl = true;
                for (String exclName : childFilter.getExclusionPatterns()) {
                    if (!string.equals(exclName)) continue;
                    incl = false;
                    break;
                }
                if (!incl) continue;
                if (count-- <= 0) break;
                builder.key(string).object();
                if (depth > 0) {
                    JsonUtil.toJson(builder, child, depth - 1, 0, maxChildNodes, inclVirtualProps, filter);
                }
                builder.endObject();
            }
            return;
        }
        int count = maxChildNodes;
        if (count != -1 && filter != null && filter.getChildNodeFilter() != null) {
            count = -1;
        }
        int numSiblings = 0;
        for (ChildNode childNode : node.getChildNodeEntries(offset, count)) {
            if (filter != null && !filter.includeNode(childNode.getName())) continue;
            if (maxChildNodes != -1 && ++numSiblings > maxChildNodes) break;
            builder.key(childNode.getName()).object();
            if (depth > 0) {
                JsonUtil.toJson(builder, childNode.getNode(), depth - 1, 0, maxChildNodes, inclVirtualProps, filter);
            }
            builder.endObject();
        }
    }
}

