/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.json;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mongomk.impl.json.DefaultJsopHandler;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class NormalizingJsopHandler
extends DefaultJsopHandler {
    private final StringBuilder builder = new StringBuilder();
    private Deque<String> commaStack = new ArrayDeque<String>(Collections.singleton(""));
    private Deque<String> pathStack = new ArrayDeque<String>(Collections.singleton("/"));

    public String getDiff() {
        this.scopeFor("/");
        return this.builder.toString();
    }

    @Override
    public void nodeAdded(String parentPath, String name) {
        String relPath = this.scopeFor(PathUtils.concat((String)parentPath, (String)name));
        if (this.pathStack.size() == 1) {
            this.builder.append("+");
        } else {
            this.maybeAppendComma();
        }
        if (relPath.length() > 0) {
            this.pathStack.addLast(relPath);
            this.commaStack.addLast("");
        }
        this.builder.append(JsopBuilder.encode((String)relPath));
        this.builder.append(":{");
        this.resetComma();
    }

    @Override
    public void nodeCopied(String rootPath, String oldPath, String newPath) {
        this.scopeFor("/");
        this.builder.append("*");
        this.builder.append(JsopBuilder.encode((String)PathUtils.relativize((String)"/", (String)oldPath)));
        this.builder.append(":");
        this.builder.append(JsopBuilder.encode((String)PathUtils.relativize((String)"/", (String)newPath)));
    }

    @Override
    public void nodeMoved(String rootPath, String oldPath, String newPath) {
        this.scopeFor("/");
        this.builder.append(">");
        this.builder.append(JsopBuilder.encode((String)PathUtils.relativize((String)"/", (String)oldPath)));
        this.builder.append(":");
        this.builder.append(JsopBuilder.encode((String)PathUtils.relativize((String)"/", (String)newPath)));
    }

    @Override
    public void nodeRemoved(String parentPath, String name) {
        this.scopeFor("/");
        this.builder.append("-");
        this.builder.append(JsopBuilder.encode((String)PathUtils.relativize((String)"/", (String)this.concatPath(parentPath, name))));
    }

    @Override
    public void propertySet(String path, String key, Object value, String rawValue) {
        String relPath = this.scopeFor(path);
        if (this.pathStack.size() == 1) {
            this.builder.append("^");
        } else {
            this.maybeAppendComma();
        }
        this.builder.append(JsopBuilder.encode((String)this.concatPath(relPath, key)));
        this.builder.append(":");
        this.builder.append(rawValue);
    }

    private String scopeFor(String path) {
        while (this.pathStack.size() > 1 && !path.equals(this.getCurrentPath()) && !PathUtils.isAncestor((String)this.getCurrentPath(), (String)path)) {
            this.pathStack.removeLast();
            this.commaStack.removeLast();
            this.builder.append("}");
        }
        return PathUtils.relativize((String)this.getCurrentPath(), (String)path);
    }

    private String getCurrentPath() {
        String path = "";
        for (String element : this.pathStack) {
            path = PathUtils.concat((String)path, (String)element);
        }
        return path;
    }

    private String concatPath(String parent, String child) {
        if (parent.length() == 0) {
            return child;
        }
        return PathUtils.concat((String)parent, (String)child);
    }

    private void resetComma() {
        this.commaStack.removeLast();
        this.commaStack.addLast("");
    }

    private void maybeAppendComma() {
        this.builder.append(this.commaStack.removeLast());
        this.commaStack.addLast(",");
    }
}

