/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.model.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mk.model.tree.NodeStateDiff;
import org.apache.jackrabbit.mk.model.tree.NodeStore;
import org.apache.jackrabbit.mk.model.tree.PropertyState;

public class MongoNodeDelta {
    private final NodeStore provider;
    private final NodeState node1;
    Map<String, String> addedProperties = new HashMap<String, String>();
    Map<String, String> removedProperties = new HashMap<String, String>();
    Map<String, String> changedProperties = new HashMap<String, String>();
    Map<String, NodeState> addedChildNodes = new HashMap<String, NodeState>();
    Map<String, Id> removedChildNodes = new HashMap<String, Id>();
    Map<String, NodeState> changedChildNodes = new HashMap<String, NodeState>();

    public MongoNodeDelta(NodeStore provider, NodeState node1, NodeState node2) {
        this.provider = provider;
        this.node1 = node1;
        this.provider.compare(node1, node2, new DiffHandler());
    }

    public Map<String, String> getAddedProperties() {
        return this.addedProperties;
    }

    public Map<String, String> getRemovedProperties() {
        return this.removedProperties;
    }

    public Map<String, String> getChangedProperties() {
        return this.changedProperties;
    }

    public Map<String, NodeState> getAddedChildNodes() {
        return this.addedChildNodes;
    }

    public Map<String, Id> getRemovedChildNodes() {
        return this.removedChildNodes;
    }

    public Map<String, NodeState> getChangedChildNodes() {
        return this.changedChildNodes;
    }

    public boolean conflictsWith(MongoNodeDelta other) {
        return !this.listConflicts(other).isEmpty();
    }

    public List<Conflict> listConflicts(MongoNodeDelta other) {
        if (!this.node1.equals(other.node1)) {
            throw new IllegalArgumentException("other and this NodeDelta object are expected to share common node1 instance");
        }
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        Map<String, String> otherAddedProps = other.getAddedProperties();
        for (Map.Entry<String, String> added : this.addedProperties.entrySet()) {
            String otherValue = otherAddedProps.get(added.getKey());
            if (otherValue == null || added.getValue().equals(otherValue)) continue;
            conflicts.add(new Conflict(ConflictType.PROPERTY_VALUE_CONFLICT, added.getKey()));
        }
        Map<String, String> otherChangedProps = other.getChangedProperties();
        Map<String, String> otherRemovedProps = other.getRemovedProperties();
        for (Map.Entry<String, String> changed : this.changedProperties.entrySet()) {
            String otherValue = otherChangedProps.get(changed.getKey());
            if (otherValue != null && !changed.getValue().equals(otherValue)) {
                conflicts.add(new Conflict(ConflictType.PROPERTY_VALUE_CONFLICT, changed.getKey()));
            }
            if (!otherRemovedProps.containsKey(changed.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_PROPERTY_CONFLICT, changed.getKey()));
        }
        for (Map.Entry<String, String> removed : this.removedProperties.entrySet()) {
            if (!otherChangedProps.containsKey(removed.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_PROPERTY_CONFLICT, removed.getKey()));
        }
        Map<String, NodeState> otherAddedChildNodes = other.getAddedChildNodes();
        for (Map.Entry<String, NodeState> added : this.addedChildNodes.entrySet()) {
            NodeState otherValue = otherAddedChildNodes.get(added.getKey());
            if (otherValue == null || added.getValue().equals(otherValue)) continue;
            conflicts.add(new Conflict(ConflictType.NODE_CONTENT_CONFLICT, added.getKey()));
        }
        Map<String, NodeState> otherChangedChildNodes = other.getChangedChildNodes();
        Map<String, Id> otherRemovedChildNodes = other.getRemovedChildNodes();
        for (Map.Entry<String, NodeState> entry : this.changedChildNodes.entrySet()) {
            NodeState otherValue = otherChangedChildNodes.get(entry.getKey());
            if (otherValue != null && !entry.getValue().equals(otherValue)) {
                conflicts.add(new Conflict(ConflictType.NODE_CONTENT_CONFLICT, entry.getKey()));
            }
            if (!otherRemovedChildNodes.containsKey(entry.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_NODE_CONFLICT, entry.getKey()));
        }
        for (Map.Entry<String, Object> entry : this.removedChildNodes.entrySet()) {
            if (!otherChangedChildNodes.containsKey(entry.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_NODE_CONFLICT, entry.getKey()));
        }
        return conflicts;
    }

    public static class Conflict {
        final ConflictType type;
        final String name;

        Conflict(ConflictType type, String name) {
            this.type = type;
            this.name = name;
        }

        public ConflictType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    private class DiffHandler
    implements NodeStateDiff {
        private DiffHandler() {
        }

        @Override
        public void propertyAdded(PropertyState after) {
            MongoNodeDelta.this.addedProperties.put(after.getName(), after.getEncodedValue());
        }

        @Override
        public void propertyChanged(PropertyState before, PropertyState after) {
            MongoNodeDelta.this.changedProperties.put(after.getName(), after.getEncodedValue());
        }

        @Override
        public void propertyDeleted(PropertyState before) {
            MongoNodeDelta.this.removedProperties.put(before.getName(), before.getEncodedValue());
        }

        @Override
        public void childNodeAdded(String name, NodeState after) {
            MongoNodeDelta.this.addedChildNodes.put(name, after);
        }

        @Override
        public void childNodeChanged(String name, NodeState before, NodeState after) {
            MongoNodeDelta.this.changedChildNodes.put(name, after);
        }

        @Override
        public void childNodeDeleted(String name, NodeState before) {
            MongoNodeDelta.this.removedChildNodes.put(name, null);
        }
    }

    public static enum ConflictType {
        PROPERTY_VALUE_CONFLICT,
        NODE_CONTENT_CONFLICT,
        REMOVED_DIRTY_PROPERTY_CONFLICT,
        REMOVED_DIRTY_NODE_CONFLICT;

    }
}

