/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.model.tree;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.mk.model.tree.AbstractChildNode;
import org.apache.jackrabbit.mk.model.tree.AbstractNodeState;
import org.apache.jackrabbit.mk.model.tree.AbstractPropertyState;
import org.apache.jackrabbit.mk.model.tree.ChildNode;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mk.model.tree.PropertyState;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class MongoNodeState
extends AbstractNodeState {
    private final Node node;

    public MongoNodeState(Node node) {
        this.node = node;
    }

    public Node unwrap() {
        return this.node;
    }

    @Override
    public Iterable<? extends PropertyState> getProperties() {
        return new Iterable<PropertyState>(){

            @Override
            public Iterator<PropertyState> iterator() {
                final Iterator<Map.Entry<String, String>> iterator = MongoNodeState.this.node.getProperties().entrySet().iterator();
                return new Iterator<PropertyState>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public PropertyState next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return new SimplePropertyState((String)entry.getKey(), (String)entry.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<? extends ChildNode> getChildNodeEntries(final long offset, final int count) {
        if (count < -1) {
            throw new IllegalArgumentException("Illegal count: " + count);
        }
        if (offset > Integer.MAX_VALUE) {
            return Collections.emptyList();
        }
        return new Iterable<ChildNode>(){

            @Override
            public Iterator<ChildNode> iterator() {
                final Iterator<Node> iterator = MongoNodeState.this.node.getChildNodeEntries((int)offset, count);
                return new Iterator<ChildNode>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public ChildNode next() {
                        return MongoNodeState.this.getChildNodeEntry((Node)iterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private ChildNode getChildNodeEntry(final Node entry) {
        return new AbstractChildNode(){

            @Override
            public String getName() {
                return PathUtils.getName((String)entry.getPath());
            }

            @Override
            public NodeState getNode() {
                try {
                    return new MongoNodeState(entry);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected error", e);
                }
            }
        };
    }

    private static class SimplePropertyState
    extends AbstractPropertyState {
        private final String name;
        private final String value;

        public SimplePropertyState(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getEncodedValue() {
            return this.value;
        }
    }
}

