/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.mongomk.impl.json.JsonUtil;
import org.apache.jackrabbit.mongomk.impl.model.NodeImpl;
import org.apache.jackrabbit.mongomk.util.MongoUtil;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NodeBuilder {
    public static Node build(String json) throws Exception {
        return NodeBuilder.build(json, "");
    }

    public static Node build(String json, String path) throws Exception {
        NodeBuilder nodeBuilder = new NodeBuilder();
        return nodeBuilder.doBuild(json, path);
    }

    private NodeBuilder() {
    }

    private Node doBuild(String json, String path) throws Exception {
        try {
            JSONObject jsonObject = new JSONObject(json);
            JSONArray names = jsonObject.names();
            if (names.length() != 1) {
                throw new IllegalArgumentException("JSON must contain exactly 1 root node");
            }
            String name = names.getString(0);
            JSONObject value = jsonObject.getJSONObject(name);
            return this.parseNode(PathUtils.concat((String)path, (String)name), value);
        }
        catch (JSONException e) {
            throw new Exception(e);
        }
    }

    private Node parseNode(String path, JSONObject jsonObject) throws Exception {
        String realPath = path;
        String revisionId = null;
        int index = path.lastIndexOf(35);
        if (index != -1) {
            realPath = path.substring(0, index);
            revisionId = path.substring(index + 1);
        }
        NodeImpl node = new NodeImpl(realPath);
        node.setRevisionId(MongoUtil.toMongoRepresentation(revisionId));
        HashMap<String, Object> properties = null;
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                String childPath = PathUtils.concat((String)realPath, (String)key);
                Node childNode = this.parseNode(childPath, (JSONObject)value);
                node.addChildNodeEntry(childNode);
                continue;
            }
            if (properties == null) {
                properties = new HashMap<String, Object>();
            }
            Object converted = JsonUtil.toJsonValue(value.toString());
            properties.put(key, converted);
        }
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                node.addProperty((String)entry.getKey(), this.convertObjectValue(entry.getValue()));
            }
        }
        return node;
    }

    private String convertObjectValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return JsopBuilder.encode((String)value.toString());
        }
        return value.toString();
    }
}

