/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.json.JsopStream;
import org.apache.jackrabbit.mk.json.JsopWriter;
import org.apache.jackrabbit.mongomk.Collision;
import org.apache.jackrabbit.mongomk.CollisionHandler;
import org.apache.jackrabbit.mongomk.DocumentStore;
import org.apache.jackrabbit.mongomk.MongoMK;
import org.apache.jackrabbit.mongomk.Node;
import org.apache.jackrabbit.mongomk.Revision;
import org.apache.jackrabbit.mongomk.UpdateOp;
import org.apache.jackrabbit.mongomk.util.Utils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commit {
    private static final Logger LOG = LoggerFactory.getLogger(Commit.class);
    private static final int MAX_DOCUMENT_SIZE = Integer.MAX_VALUE;
    private static final boolean PURGE_OLD_REVISIONS = true;
    private final MongoMK mk;
    private final Revision baseRevision;
    private final Revision revision;
    private HashMap<String, UpdateOp> operations = new HashMap();
    private JsopWriter diff = new JsopStream();
    private HashSet<String> changedNodes = new HashSet();
    private HashSet<String> addedNodes = new HashSet();
    private HashSet<String> removedNodes = new HashSet();

    Commit(MongoMK mk, Revision baseRevision, Revision revision) {
        this.baseRevision = baseRevision;
        this.revision = revision;
        this.mk = mk;
    }

    UpdateOp getUpdateOperationForNode(String path) {
        UpdateOp op = this.operations.get(path);
        if (op == null) {
            String id = Utils.getIdFromPath(path);
            op = new UpdateOp(path, id, false);
            this.operations.put(path, op);
        }
        return op;
    }

    public Revision getRevision() {
        return this.revision;
    }

    void addNodeDiff(Node n) {
        this.diff.tag('+').key(n.path);
        this.diff.object();
        n.append(this.diff, false);
        this.diff.endObject();
        this.diff.newline();
    }

    public void touchNode(String path) {
        UpdateOp op = this.getUpdateOperationForNode(path);
        op.setMapEntry("_lastRev", "" + this.revision.getClusterId(), this.revision.toString());
    }

    void updateProperty(String path, String propertyName, String value) {
        UpdateOp op = this.getUpdateOperationForNode(path);
        String key = Utils.escapePropertyName(propertyName);
        op.setMapEntry(key, this.revision.toString(), value);
        op.setMapEntry("_lastRev", "" + this.revision.getClusterId(), this.revision.toString());
    }

    void addNode(Node n) {
        if (this.operations.containsKey(n.path)) {
            String msg = "Node already added: " + n.path;
            LOG.error(msg);
            throw new MicroKernelException(msg);
        }
        this.operations.put(n.path, n.asOperation(true));
        this.addedNodes.add(n.path);
    }

    void apply() {
        if (!this.operations.isEmpty()) {
            this.applyToDocumentStore();
            this.applyToCache();
        }
    }

    void prepare(Revision baseRevision) {
        if (!this.operations.isEmpty()) {
            this.applyToDocumentStore(baseRevision);
            this.applyToCache();
        }
    }

    void applyToDocumentStore() {
        this.applyToDocumentStore(null);
    }

    void applyToDocumentStore(Revision baseRevision) {
        String commitValue = baseRevision != null ? baseRevision.toString() : "true";
        DocumentStore store = this.mk.getDocumentStore();
        String commitRootPath = null;
        if (baseRevision != null) {
            commitRootPath = "/";
        }
        ArrayList<UpdateOp> newNodes = new ArrayList<UpdateOp>();
        ArrayList<UpdateOp> changedNodes = new ArrayList<UpdateOp>();
        ArrayList<UpdateOp> done = new ArrayList<UpdateOp>();
        for (String p : this.operations.keySet()) {
            this.markChanged(p);
            if (commitRootPath == null) {
                commitRootPath = p;
                continue;
            }
            while (!PathUtils.isAncestor((String)commitRootPath, (String)p) && !PathUtils.denotesRoot((String)(commitRootPath = PathUtils.getParentPath((String)commitRootPath)))) {
            }
        }
        int commitRootDepth = PathUtils.getDepth((String)commitRootPath);
        UpdateOp commitRoot = this.getUpdateOperationForNode(commitRootPath);
        for (String p : this.operations.keySet()) {
            UpdateOp op = this.operations.get(p);
            op.setMapEntry("_lastRev", "" + this.revision.getClusterId(), this.revision.toString());
            if (op.isNew) {
                op.setMapEntry("_deleted", this.revision.toString(), "false");
            }
            if (op == commitRoot) continue;
            op.setMapEntry("_commitRoot", this.revision.toString(), commitRootDepth);
            if (op.isNew()) {
                newNodes.add(op);
                continue;
            }
            changedNodes.add(op);
        }
        if (changedNodes.size() == 0 && commitRoot.isNew) {
            commitRoot.setMapEntry("_revisions", this.revision.toString(), commitValue);
            newNodes.add(commitRoot);
        }
        try {
            if (newNodes.size() > 0 && !store.create(DocumentStore.Collection.NODES, newNodes)) {
                for (UpdateOp op : newNodes) {
                    if (op == commitRoot) {
                        commitRoot.unsetMapEntry("_revisions", this.revision.toString());
                    }
                    changedNodes.add(op);
                }
                newNodes.clear();
            }
            for (UpdateOp op : changedNodes) {
                op.setMapEntry("_commitRoot", this.revision.toString(), commitRootDepth);
                done.add(op);
                this.createOrUpdateNode(store, op);
            }
            if (changedNodes.size() > 0 || !commitRoot.isNew) {
                commitRoot.setMapEntry("_revisions", this.revision.toString(), commitValue);
                done.add(commitRoot);
                this.createOrUpdateNode(store, commitRoot);
                this.operations.put(commitRootPath, commitRoot);
            }
        }
        catch (MicroKernelException e) {
            this.rollback(newNodes, done);
            String msg = "Exception committing " + this.diff.toString();
            LOG.error(msg, (Throwable)e);
            throw new MicroKernelException(msg, (Throwable)e);
        }
    }

    private void rollback(ArrayList<UpdateOp> newDocuments, ArrayList<UpdateOp> changed) {
        DocumentStore store = this.mk.getDocumentStore();
        for (UpdateOp op : changed) {
            UpdateOp reverse = op.getReverseOperation();
            store.createOrUpdate(DocumentStore.Collection.NODES, reverse);
        }
        for (UpdateOp op : newDocuments) {
            store.remove(DocumentStore.Collection.NODES, op.key);
        }
    }

    private void createOrUpdateNode(DocumentStore store, UpdateOp op) {
        int size;
        Map<String, Object> map = store.createOrUpdate(DocumentStore.Collection.NODES, op);
        if (this.baseRevision != null) {
            final AtomicReference collisions = new AtomicReference();
            Revision newestRev = this.mk.getNewestRevision(map, this.revision, true, new CollisionHandler(){

                @Override
                void uncommittedModification(Revision uncommitted) {
                    if (collisions.get() == null) {
                        collisions.set(new ArrayList());
                    }
                    ((List)collisions.get()).add(uncommitted);
                }
            });
            if (newestRev == null) {
                if (op.isDelete || !op.isNew) {
                    throw new MicroKernelException("The node " + op.path + " does not exist or is already deleted " + "before " + this.revision + "; document " + map);
                }
            } else {
                if (op.isNew) {
                    throw new MicroKernelException("The node " + op.path + " was already added in revision " + newestRev + "; before " + this.revision + "; document " + map);
                }
                if (this.mk.isRevisionNewer(newestRev, this.baseRevision) && (op.isDelete || this.isConflicting(map, op))) {
                    throw new MicroKernelException("The node " + op.path + " was changed in revision " + newestRev + ", which was applied after the base revision " + this.baseRevision + "; before " + this.revision + "; document " + map);
                }
            }
            if (collisions.get() != null && this.isConflicting(map, op)) {
                for (Revision r : (List)collisions.get()) {
                    Collision c = new Collision(map, r, op, this.revision);
                    boolean success = c.mark(store);
                    if (success) continue;
                }
            }
        }
        if ((size = Utils.estimateMemoryUsage(map)) > Integer.MAX_VALUE) {
            UpdateOp main;
            UpdateOp[] split = this.splitDocument(map);
            UpdateOp old = split[0];
            if (old != null) {
                store.createOrUpdate(DocumentStore.Collection.NODES, old);
            }
            if ((main = split[1]) != null) {
                store.createOrUpdate(DocumentStore.Collection.NODES, main);
            }
        }
    }

    private boolean isConflicting(Map<String, Object> nodeMap, UpdateOp op) {
        if (this.baseRevision == null) {
            return false;
        }
        Map deleted = (Map)nodeMap.get("_deleted");
        if (deleted != null) {
            for (Map.Entry<Object, Object> entry : deleted.entrySet()) {
                if (!this.mk.isRevisionNewer(Revision.fromString((String)entry.getKey()), this.baseRevision)) continue;
                return true;
            }
        }
        for (Map.Entry<Object, Object> entry : op.changes.entrySet()) {
            Map changes;
            if (((UpdateOp.Operation)entry.getValue()).type != UpdateOp.Operation.Type.SET_MAP_ENTRY) continue;
            int idx = ((String)entry.getKey()).indexOf(46);
            String name = ((String)entry.getKey()).substring(0, idx);
            if ("_deleted".equals(name)) {
                return true;
            }
            if (!Utils.isPropertyName(name) || (changes = (Map)nodeMap.get(name)) == null) continue;
            for (String rev : changes.keySet()) {
                if (!this.mk.isRevisionNewer(Revision.fromString(rev), this.baseRevision)) continue;
                return true;
            }
        }
        return false;
    }

    private UpdateOp[] splitDocument(Map<String, Object> map) {
        String id = (String)map.get("_id");
        String path = Utils.getPathFromId(id);
        Long previous = (Long)map.get("_prev");
        if (previous == null) {
            previous = 0L;
        } else {
            Long l = previous;
            Long l2 = previous = Long.valueOf(previous + 1L);
        }
        UpdateOp old = new UpdateOp(path, id + "/" + previous, true);
        UpdateOp main = new UpdateOp(path, id, false);
        main.set("_prev", previous);
        for (Map.Entry<String, Object> e : map.entrySet()) {
            Revision propRev;
            String key = e.getKey();
            if (key.equals("_id") || key.equals("_prev")) continue;
            if (key.equals("_lastRev")) {
                main.setMap("_lastRev", "" + this.revision.getClusterId(), this.revision.toString());
                continue;
            }
            Map valueMap = (Map)e.getValue();
            Revision latestRev = null;
            for (String r : valueMap.keySet()) {
                propRev = Revision.fromString(r);
                if (latestRev != null && !this.mk.isRevisionNewer(propRev, latestRev)) continue;
                latestRev = propRev;
            }
            for (String r : valueMap.keySet()) {
                propRev = Revision.fromString(r);
                Object v = valueMap.get(r);
                if (propRev.equals(latestRev)) {
                    main.setMap(key, propRev.toString(), v);
                    continue;
                }
                old.setMapEntry(key, propRev.toString(), v);
            }
        }
        old = null;
        return new UpdateOp[]{old, main};
    }

    public void applyToCache() {
        HashMap<String, ArrayList<String>> nodesWithChangedChildren = new HashMap<String, ArrayList<String>>();
        ArrayList<String> addOrRemove = new ArrayList<String>();
        addOrRemove.addAll(this.addedNodes);
        addOrRemove.addAll(this.removedNodes);
        for (String p : addOrRemove) {
            String parent = PathUtils.getParentPath((String)p);
            ArrayList<String> list = (ArrayList<String>)nodesWithChangedChildren.get(parent);
            if (list == null) {
                list = new ArrayList<String>();
                nodesWithChangedChildren.put(parent, list);
            }
            list.add(p);
        }
        for (String path : this.changedNodes) {
            UpdateOp op;
            ArrayList<String> added = new ArrayList<String>();
            ArrayList<String> removed = new ArrayList<String>();
            ArrayList changed = (ArrayList)nodesWithChangedChildren.get(path);
            if (changed != null) {
                for (String s : changed) {
                    if (this.addedNodes.contains(s)) {
                        added.add(s);
                        continue;
                    }
                    if (!this.removedNodes.contains(s)) continue;
                    removed.add(s);
                }
            }
            boolean isNew = (op = this.operations.get(path)) != null && op.isNew;
            boolean isWritten = op != null;
            boolean isDelete = op != null && op.isDelete;
            this.mk.applyChanges(this.revision, path, isNew, isDelete, isWritten, added, removed);
        }
    }

    public void moveNode(String sourcePath, String targetPath) {
        this.diff.tag('>').key(sourcePath).value(targetPath);
    }

    public void copyNode(String sourcePath, String targetPath) {
        this.diff.tag('*').key(sourcePath).value(targetPath);
    }

    public JsopWriter getDiff() {
        return this.diff;
    }

    private void markChanged(String path) {
        if (!PathUtils.denotesRoot((String)path) && !PathUtils.isAbsolute((String)path)) {
            throw new IllegalArgumentException("path: " + path);
        }
        while (true) {
            this.changedNodes.add(path);
            if (PathUtils.denotesRoot((String)path)) break;
            path = PathUtils.getParentPath((String)path);
        }
    }

    public void updatePropertyDiff(String path, String propertyName, String value) {
        this.diff.tag('^').key(PathUtils.concat((String)path, (String)propertyName)).value(value);
    }

    public void removeNodeDiff(String path) {
        this.diff.tag('-').value(path).newline();
    }

    public void removeNode(String path) {
        this.removedNodes.add(path);
        UpdateOp op = this.getUpdateOperationForNode(path);
        op.setDelete(true);
        op.setMapEntry("_deleted", this.revision.toString(), "true");
        op.setMapEntry("_lastRev", "" + this.revision.getClusterId(), this.revision.toString());
    }
}

