/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mongomk.Branch;
import org.apache.jackrabbit.mongomk.DocumentStore;
import org.apache.jackrabbit.mongomk.Revision;
import org.apache.jackrabbit.mongomk.util.Utils;

class UnmergedBranches {
    private final List<Branch> branches = new ArrayList<Branch>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Revision.RevisionComparator comparator = new Revision.RevisionComparator();

    UnmergedBranches() {
    }

    void init(DocumentStore store, int clusterId) {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("already initialized");
        }
        Map<String, Object> nodeMap = store.find(DocumentStore.Collection.NODES, Utils.getIdFromPath("/"));
        Map valueMap = (Map)nodeMap.get("_revisions");
        if (valueMap != null) {
            TreeMap<Revision, Revision> tmp = new TreeMap<Revision, Revision>(this.comparator);
            for (Map.Entry commit : valueMap.entrySet()) {
                Revision r;
                if (((String)commit.getValue()).equals("true") || (r = Revision.fromString((String)commit.getKey())).getClusterId() != clusterId) continue;
                Revision b = Revision.fromString((String)commit.getValue());
                tmp.put(r, b);
            }
            while (!tmp.isEmpty()) {
                TreeSet<Revision> commits = new TreeSet<Revision>(this.comparator);
                Revision head = (Revision)tmp.lastKey();
                commits.add(head);
                Revision base = (Revision)tmp.remove(head);
                while (tmp.containsKey(base)) {
                    commits.add(base);
                    base = (Revision)tmp.remove(base);
                }
                this.branches.add(new Branch(commits, base));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Branch create(@Nonnull Revision base, @Nonnull Revision initial) {
        TreeSet<Revision> commits = new TreeSet<Revision>(this.comparator);
        commits.add((Revision)Preconditions.checkNotNull((Object)initial));
        Branch b = new Branch(commits, (Revision)Preconditions.checkNotNull((Object)base));
        List<Branch> list = this.branches;
        synchronized (list) {
            this.branches.add(b);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    Branch getBranch(@Nonnull Revision r) {
        List<Branch> list = this.branches;
        synchronized (list) {
            for (Branch b : this.branches) {
                if (!b.containsCommit(r)) continue;
                return b;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Branch b) {
        List<Branch> list = this.branches;
        synchronized (list) {
            for (int i = 0; i < this.branches.size(); ++i) {
                if (this.branches.get(i) != b) continue;
                this.branches.remove(i);
                return;
            }
        }
    }
}

