/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.util.StringUtils;
import org.apache.jackrabbit.mongomk.DocumentStore;
import org.apache.jackrabbit.mongomk.MongoDocumentStore;
import org.apache.jackrabbit.mongomk.UpdateOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentStore.class);
    private static final String RANDOM_PREFIX = "random:";
    private static final String ID_KEY = "_id";
    private static final String MACHINE_ID_KEY = "machine";
    private static final String INSTANCE_ID_KEY = "instance";
    private static final String LEASE_END_KEY = "leaseEnd";
    private static final String INFO_KEY = "info";
    private static final String MACHINE_ID = ClusterNodeInfo.getMachineId();
    private static final long PROCESS_ID = ClusterNodeInfo.getProcessId();
    private static final String WORKING_DIR = System.getProperty("user.dir", "");
    private long leaseTime = 60000L;
    private final int id;
    private final String machineId;
    private final String instanceId;
    private final DocumentStore store;
    private final long startTime;
    private final String uuid = UUID.randomUUID().toString();
    private long leaseEndTime;

    ClusterNodeInfo(int id, DocumentStore store, String machineId, String instanceId) {
        this.id = id;
        this.leaseEndTime = this.startTime = System.currentTimeMillis();
        this.store = store;
        this.machineId = machineId;
        this.instanceId = instanceId;
    }

    public int getId() {
        return this.id;
    }

    public static ClusterNodeInfo getInstance(DocumentStore store) {
        return ClusterNodeInfo.getInstance(store, MACHINE_ID, WORKING_DIR);
    }

    public static ClusterNodeInfo getInstance(DocumentStore store, String machineId, String instanceId) {
        if (machineId == null) {
            machineId = MACHINE_ID;
        }
        if (instanceId == null) {
            instanceId = WORKING_DIR;
        }
        for (int i = 0; i < 10; ++i) {
            ClusterNodeInfo clusterNode = ClusterNodeInfo.createInstance(store, machineId, instanceId);
            UpdateOp update = new UpdateOp(null, "" + clusterNode.id, true);
            update.set(ID_KEY, "" + clusterNode.id);
            update.set(MACHINE_ID_KEY, clusterNode.machineId);
            update.set(INSTANCE_ID_KEY, clusterNode.instanceId);
            update.set(LEASE_END_KEY, System.currentTimeMillis() + clusterNode.leaseTime);
            update.set(INFO_KEY, clusterNode.toString());
            boolean success = store.create(DocumentStore.Collection.CLUSTER_NODES, Collections.singletonList(update));
            if (!success) continue;
            return clusterNode;
        }
        throw new MicroKernelException("Could not get cluster node info");
    }

    private static ClusterNodeInfo createInstance(DocumentStore store, String machineId, String instanceId) {
        long now = System.currentTimeMillis();
        List<Map<String, Object>> list = store.query(DocumentStore.Collection.CLUSTER_NODES, "0", "a", Integer.MAX_VALUE);
        int clusterNodeId = 0;
        int maxId = 0;
        for (Map<String, Object> doc : list) {
            int id;
            String key = "" + doc.get(ID_KEY);
            try {
                id = Integer.parseInt(key);
            }
            catch (Exception e) {
                continue;
            }
            maxId = Math.max(maxId, id);
            Long leaseEnd = (Long)doc.get(LEASE_END_KEY);
            if (leaseEnd != null && leaseEnd > now) continue;
            String mId = "" + doc.get(MACHINE_ID_KEY);
            String iId = "" + doc.get(INSTANCE_ID_KEY);
            if (machineId.startsWith(RANDOM_PREFIX)) {
                store.remove(DocumentStore.Collection.CLUSTER_NODES, key);
                continue;
            }
            if (!mId.equals(machineId) || !iId.equals(instanceId)) continue;
            store.remove(DocumentStore.Collection.CLUSTER_NODES, key);
            if (clusterNodeId != 0 && id >= clusterNodeId) continue;
            clusterNodeId = id;
        }
        if (clusterNodeId == 0) {
            clusterNodeId = maxId + 1;
        }
        return new ClusterNodeInfo(clusterNodeId, store, machineId, instanceId);
    }

    public void renewLease(long nextCheckMillis) {
        long now = System.currentTimeMillis();
        if (now + nextCheckMillis + nextCheckMillis < this.leaseEndTime) {
            return;
        }
        UpdateOp update = new UpdateOp(null, "" + this.id, true);
        this.leaseEndTime = now + this.leaseTime;
        update.set(LEASE_END_KEY, this.leaseEndTime);
        this.store.createOrUpdate(DocumentStore.Collection.CLUSTER_NODES, update);
    }

    public void setLeaseTime(long leaseTime) {
        this.leaseTime = leaseTime;
    }

    public long getLeaseTime() {
        return this.leaseTime;
    }

    public void dispose() {
        UpdateOp update = new UpdateOp(null, "" + this.id, true);
        update.set(LEASE_END_KEY, null);
        this.store.createOrUpdate(DocumentStore.Collection.CLUSTER_NODES, update);
    }

    public String toString() {
        return "id: " + this.id + ",\n" + "startTime: " + this.startTime + ",\n" + "machineId: " + this.machineId + ",\n" + "instanceId: " + this.instanceId + ",\n" + "pid: " + PROCESS_ID + ",\n" + "uuid: " + this.uuid + "\n";
    }

    private static long getProcessId() {
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            return Long.parseLong(name.substring(0, name.indexOf(64)));
        }
        catch (Exception e) {
            LOG.warn("Could not get process id", (Throwable)e);
            return 0L;
        }
    }

    private static String getMachineId() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                String x = StringUtils.convertBytesToHex((byte[])mac);
                list.add(x);
            }
            if (list.size() > 0) {
                Collections.sort(list);
                return "mac:" + (String)list.get(0);
            }
        }
        catch (Exception e) {
            LOG.error("Error calculating the machine id", (Throwable)e);
        }
        return RANDOM_PREFIX + UUID.randomUUID().toString();
    }
}

