/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.QueryBuilder;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mongomk.DocumentStore;
import org.apache.jackrabbit.mongomk.MemoryDocumentStore;
import org.apache.jackrabbit.mongomk.UpdateOp;
import org.apache.jackrabbit.mongomk.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDocumentStore
implements DocumentStore {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentStore.class);
    private static final int CACHE_DOCUMENTS = Integer.getInteger("oak.mongoMK.cacheDocs", 20480);
    private static final boolean LOG_TIME = false;
    private final DBCollection nodes;
    private final DBCollection clusterNodes;
    private long timeSum;
    private final Cache<String, CachedDocument> nodesCache;

    public MongoDocumentStore(DB db) {
        this.nodes = db.getCollection(DocumentStore.Collection.NODES.toString());
        this.clusterNodes = db.getCollection(DocumentStore.Collection.CLUSTER_NODES.toString());
        this.nodesCache = CacheBuilder.newBuilder().maximumSize((long)CACHE_DOCUMENTS).build();
    }

    private static long start() {
        return 0L;
    }

    private void end(long start) {
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    @Override
    public void invalidateCache() {
        this.nodesCache.invalidateAll();
    }

    @Override
    public void invalidateCache(DocumentStore.Collection collection, String key) {
        if (collection == DocumentStore.Collection.NODES) {
            this.nodesCache.invalidate((Object)key);
        }
    }

    @Override
    public Map<String, Object> find(DocumentStore.Collection collection, String key) {
        return this.find(collection, key, Integer.MAX_VALUE);
    }

    @Override
    public Map<String, Object> find(final DocumentStore.Collection collection, final String key, int maxCacheAge) {
        if (collection != DocumentStore.Collection.NODES) {
            return this.findUncached(collection, key);
        }
        try {
            CachedDocument doc;
            if (maxCacheAge == 0) {
                this.nodesCache.invalidate((Object)key);
            }
            while (true) {
                doc = (CachedDocument)this.nodesCache.get((Object)key, (Callable)new Callable<CachedDocument>(){

                    @Override
                    public CachedDocument call() throws Exception {
                        Map<String, Object> map = MongoDocumentStore.this.findUncached(collection, key);
                        return new CachedDocument(map);
                    }
                });
                if (maxCacheAge == 0 || maxCacheAge == Integer.MAX_VALUE || System.currentTimeMillis() - doc.time < (long)maxCacheAge) break;
                this.nodesCache.invalidate((Object)key);
            }
            return doc.value;
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to load document with " + key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> findUncached(DocumentStore.Collection collection, String key) {
        DBCollection dbCollection = this.getDBCollection(collection);
        long start = MongoDocumentStore.start();
        try {
            DBObject doc = dbCollection.findOne(MongoDocumentStore.getByKeyQuery(key).get());
            if (doc == null) {
                Map<String, Object> map = null;
                return map;
            }
            Map<String, Object> map = MongoDocumentStore.convertFromDBObject(doc);
            return map;
        }
        finally {
            this.end(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<Map<String, Object>> query(DocumentStore.Collection collection, String fromKey, String toKey, int limit) {
        MongoDocumentStore.log("query", fromKey, toKey, limit);
        DBCollection dbCollection = this.getDBCollection(collection);
        QueryBuilder queryBuilder = QueryBuilder.start((String)"_id");
        queryBuilder.greaterThanEquals((Object)fromKey);
        queryBuilder.lessThan((Object)toKey);
        DBObject query = queryBuilder.get();
        long start = MongoDocumentStore.start();
        try {
            DBCursor cursor = dbCollection.find(query);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < limit && cursor.hasNext(); ++i) {
                DBObject o = cursor.next();
                Map<String, Object> map = MongoDocumentStore.convertFromDBObject(o);
                if (collection == DocumentStore.Collection.NODES) {
                    String key = (String)map.get("_id");
                    this.nodesCache.put((Object)key, (Object)new CachedDocument(map));
                }
                list.add(map);
            }
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        finally {
            this.end(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(DocumentStore.Collection collection, String key) {
        MongoDocumentStore.log("remove", key);
        DBCollection dbCollection = this.getDBCollection(collection);
        long start = MongoDocumentStore.start();
        try {
            WriteResult writeResult;
            if (collection == DocumentStore.Collection.NODES) {
                this.nodesCache.invalidate((Object)key);
            }
            if ((writeResult = dbCollection.remove(MongoDocumentStore.getByKeyQuery(key).get(), WriteConcern.SAFE)).getError() != null) {
                throw new MicroKernelException("Remove failed: " + writeResult.getError());
            }
        }
        finally {
            this.end(start);
        }
    }

    @CheckForNull
    private Map<String, Object> findAndModify(DocumentStore.Collection collection, UpdateOp updateOp, boolean upsert, boolean checkConditions) {
        String[] kv;
        DBCollection dbCollection = this.getDBCollection(collection);
        QueryBuilder query = MongoDocumentStore.getByKeyQuery(updateOp.key);
        BasicDBObject setUpdates = new BasicDBObject();
        BasicDBObject incUpdates = new BasicDBObject();
        BasicDBObject unsetUpdates = new BasicDBObject();
        for (Map.Entry<String, UpdateOp.Operation> entry : updateOp.changes.entrySet()) {
            String k = entry.getKey();
            if (k.equals("_id")) continue;
            UpdateOp.Operation op = entry.getValue();
            switch (op.type) {
                case SET: {
                    setUpdates.append(k, op.value);
                    break;
                }
                case INCREMENT: {
                    incUpdates.append(k, op.value);
                    break;
                }
                case SET_MAP_ENTRY: {
                    setUpdates.append(k, op.value);
                    break;
                }
                case REMOVE_MAP_ENTRY: {
                    unsetUpdates.append(k, (Object)"1");
                    break;
                }
                case SET_MAP: {
                    kv = k.split("\\.");
                    BasicDBObject sub = new BasicDBObject();
                    sub.put(kv[1], op.value);
                    setUpdates.append(kv[0], (Object)sub);
                    break;
                }
                case CONTAINS_MAP_ENTRY: {
                    if (!checkConditions) break;
                    query.and(k).exists(op.value);
                }
            }
        }
        BasicDBObject update = new BasicDBObject();
        if (!setUpdates.isEmpty()) {
            update.append("$set", (Object)setUpdates);
        }
        if (!incUpdates.isEmpty()) {
            update.append("$inc", (Object)incUpdates);
        }
        if (!unsetUpdates.isEmpty()) {
            update.append("$unset", (Object)unsetUpdates);
        }
        long start = MongoDocumentStore.start();
        try {
            DBObject oldNode = dbCollection.findAndModify(query.get(), null, null, false, (DBObject)update, false, upsert);
            if (checkConditions && oldNode == null) {
                kv = null;
                return kv;
            }
            Map<String, Object> map = MongoDocumentStore.convertFromDBObject(oldNode);
            if (collection == DocumentStore.Collection.NODES) {
                Map<String, Object> newMap = Utils.newMap();
                Utils.deepCopyMap(map, newMap);
                String key = updateOp.getKey();
                MemoryDocumentStore.applyChanges(newMap, updateOp);
                this.nodesCache.put((Object)key, (Object)new CachedDocument(newMap));
            }
            Map<String, Object> map2 = map;
            return map2;
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
        finally {
            this.end(start);
        }
    }

    @Override
    @Nonnull
    public Map<String, Object> createOrUpdate(DocumentStore.Collection collection, UpdateOp update) throws MicroKernelException {
        MongoDocumentStore.log("createOrUpdate", update);
        Map<String, Object> map = this.findAndModify(collection, update, true, false);
        MongoDocumentStore.log("createOrUpdate returns ", map);
        return map;
    }

    @Override
    public Map<String, Object> findAndUpdate(DocumentStore.Collection collection, UpdateOp update) throws MicroKernelException {
        MongoDocumentStore.log("findAndUpdate", update);
        Map<String, Object> map = this.findAndModify(collection, update, false, true);
        MongoDocumentStore.log("findAndUpdate returns ", map);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(DocumentStore.Collection collection, List<UpdateOp> updateOps) {
        MongoDocumentStore.log("create", updateOps);
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        DBObject[] inserts = new DBObject[updateOps.size()];
        for (int i = 0; i < updateOps.size(); ++i) {
            inserts[i] = new BasicDBObject();
            UpdateOp update = updateOps.get(i);
            Map<String, Object> target = Utils.newMap();
            MemoryDocumentStore.applyChanges(target, update);
            maps.add(target);
            for (Map.Entry<String, UpdateOp.Operation> entry : update.changes.entrySet()) {
                String string = entry.getKey();
                UpdateOp.Operation op = entry.getValue();
                switch (op.type) {
                    case SET: 
                    case INCREMENT: {
                        inserts[i].put(string, op.value);
                        break;
                    }
                    case SET_MAP_ENTRY: 
                    case SET_MAP: {
                        String[] kv = string.split("\\.");
                        BasicDBObject value = new BasicDBObject(kv[1], op.value);
                        inserts[i].put(kv[0], (Object)value);
                        break;
                    }
                    case REMOVE_MAP_ENTRY: {
                        break;
                    }
                }
            }
        }
        DBCollection dbCollection = this.getDBCollection(collection);
        long start = MongoDocumentStore.start();
        try {
            WriteResult writeResult = dbCollection.insert(inserts, WriteConcern.SAFE);
            if (writeResult.getError() != null) {
                boolean entry = false;
                return entry;
            }
            if (collection == DocumentStore.Collection.NODES) {
                for (Map map : maps) {
                    String id = (String)map.get("_id");
                    this.nodesCache.put((Object)id, (Object)new CachedDocument(map));
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (MongoException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.end(start);
        }
    }

    private static Map<String, Object> convertFromDBObject(DBObject n) {
        Map<String, Object> copy = Utils.newMap();
        if (n != null) {
            for (String key : n.keySet()) {
                Object o = n.get(key);
                if (o instanceof String) {
                    copy.put(key, o);
                    continue;
                }
                if (o instanceof Long) {
                    copy.put(key, o);
                    continue;
                }
                if (!(o instanceof BasicDBObject)) continue;
                copy.put(key, o);
            }
        }
        return copy;
    }

    private DBCollection getDBCollection(DocumentStore.Collection collection) {
        switch (collection) {
            case NODES: {
                return this.nodes;
            }
            case CLUSTER_NODES: {
                return this.clusterNodes;
            }
        }
        throw new IllegalArgumentException(collection.name());
    }

    private static QueryBuilder getByKeyQuery(String key) {
        return QueryBuilder.start((String)"_id").is((Object)key);
    }

    @Override
    public void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("MongoDB time: " + this.timeSum);
        }
        this.nodes.getDB().getMongo().close();
    }

    private static void log(String message, Object ... args) {
        if (LOG.isDebugEnabled()) {
            String argList = Arrays.toString(args);
            if (argList.length() > 10000) {
                argList = argList.length() + ": " + argList;
            }
            LOG.debug(message + argList);
        }
    }

    @Override
    public boolean isCached(DocumentStore.Collection collection, String key) {
        if (collection != DocumentStore.Collection.NODES) {
            return false;
        }
        return this.nodesCache.getIfPresent((Object)key) != null;
    }

    static class CachedDocument {
        final long time = System.currentTimeMillis();
        final Map<String, Object> value;

        CachedDocument(Map<String, Object> value) {
            this.value = value;
        }
    }
}

