/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mongodb.DB;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.blobs.BlobStore;
import org.apache.jackrabbit.mk.blobs.MemoryBlobStore;
import org.apache.jackrabbit.mk.json.JsopReader;
import org.apache.jackrabbit.mk.json.JsopStream;
import org.apache.jackrabbit.mk.json.JsopTokenizer;
import org.apache.jackrabbit.mk.json.JsopWriter;
import org.apache.jackrabbit.mongomk.Branch;
import org.apache.jackrabbit.mongomk.ClusterNodeInfo;
import org.apache.jackrabbit.mongomk.CollisionHandler;
import org.apache.jackrabbit.mongomk.Commit;
import org.apache.jackrabbit.mongomk.DocumentStore;
import org.apache.jackrabbit.mongomk.MemoryDocumentStore;
import org.apache.jackrabbit.mongomk.MongoDocumentStore;
import org.apache.jackrabbit.mongomk.Node;
import org.apache.jackrabbit.mongomk.Revision;
import org.apache.jackrabbit.mongomk.UnmergedBranches;
import org.apache.jackrabbit.mongomk.UpdateOp;
import org.apache.jackrabbit.mongomk.blob.MongoBlobStore;
import org.apache.jackrabbit.mongomk.util.Utils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoMK
implements MicroKernel {
    private static final Logger LOG = LoggerFactory.getLogger(MongoMK.class);
    private static final int CACHE_CHILDREN = Integer.getInteger("oak.mongoMK.cacheChildren", 1024);
    private static final int CACHE_NODES = Integer.getInteger("oak.mongoMK.cacheNodes", 1024);
    private static final int WARN_REVISION_AGE = Integer.getInteger("oak.mongoMK.revisionAge", 60000);
    private static final boolean ENABLE_BACKGROUND_OPS = Boolean.parseBoolean(System.getProperty("oak.mongoMK.backgroundOps", "true"));
    private static final int REMEMBER_REVISION_ORDER_MILLIS = 3600000;
    protected int asyncDelay = 1000;
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final DocumentStore store;
    private final BlobStore blobStore;
    private final ClusterNodeInfo clusterNodeInfo;
    private final int clusterId;
    private final Cache<String, Node> nodeCache;
    private final Cache<String, Node.Children> nodeChildrenCache;
    private final Map<String, Revision> unsavedLastRevisions = new ConcurrentHashMap<String, Revision>();
    private final Map<Integer, Revision> lastKnownRevision = new ConcurrentHashMap<Integer, Revision>();
    private volatile Revision headRevision;
    private Thread backgroundThread;
    private AtomicInteger simpleRevisionCounter;
    private final Revision.RevisionComparator revisionComparator;
    private final UnmergedBranches branches = new UnmergedBranches();
    private boolean stopBackground;

    MongoMK(Builder builder) {
        this.store = builder.getDocumentStore();
        this.blobStore = builder.getBlobStore();
        int cid = builder.getClusterId();
        cid = Integer.getInteger("oak.mongoMK.clusterId", cid);
        if (cid == 0) {
            this.clusterNodeInfo = ClusterNodeInfo.getInstance(this.store);
            cid = this.clusterNodeInfo.getId();
        } else {
            this.clusterNodeInfo = null;
        }
        this.clusterId = cid;
        this.revisionComparator = new Revision.RevisionComparator(this.clusterId);
        this.asyncDelay = builder.getAsyncDelay();
        this.nodeCache = CacheBuilder.newBuilder().maximumSize((long)CACHE_NODES).build();
        this.nodeChildrenCache = CacheBuilder.newBuilder().maximumSize((long)CACHE_CHILDREN).build();
        this.init();
        this.backgroundRead();
        this.revisionComparator.add(this.headRevision, Revision.newRevision(0));
        this.headRevision = this.newRevision();
        LOG.info("Initialized MongoMK with clusterNodeId: {}", (Object)this.clusterId);
    }

    void init() {
        this.backgroundThread = new Thread((Runnable)new BackgroundOperation(this, this.isDisposed), "MongoMK background thread");
        this.backgroundThread.setDaemon(true);
        this.backgroundThread.start();
        this.headRevision = this.newRevision();
        Node n = this.readNode("/", this.headRevision);
        if (n == null) {
            Commit commit = new Commit(this, null, this.headRevision);
            n = new Node("/", this.headRevision);
            commit.addNode(n);
            commit.applyToDocumentStore();
        } else {
            this.branches.init(this.store, this.clusterId);
        }
    }

    void useSimpleRevisions() {
        this.simpleRevisionCounter = new AtomicInteger(1);
        this.init();
    }

    Revision newRevision() {
        if (this.simpleRevisionCounter != null) {
            return new Revision(this.simpleRevisionCounter.getAndIncrement(), 0, this.clusterId);
        }
        return Revision.newRevision(this.clusterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runBackgroundOperations() {
        if (this.isDisposed.get()) {
            return;
        }
        this.backgroundRenewClusterIdLease();
        if (this.simpleRevisionCounter != null) {
            return;
        }
        if (!ENABLE_BACKGROUND_OPS || this.stopBackground) {
            return;
        }
        MongoMK mongoMK = this;
        synchronized (mongoMK) {
            try {
                this.backgroundWrite();
                this.backgroundRead();
            }
            catch (RuntimeException e) {
                if (this.isDisposed.get()) {
                    return;
                }
                LOG.warn("Background operation failed: " + e.toString(), (Throwable)e);
            }
        }
    }

    private void backgroundRenewClusterIdLease() {
        if (this.clusterNodeInfo == null) {
            return;
        }
        this.clusterNodeInfo.renewLease(this.asyncDelay);
    }

    void backgroundRead() {
        String id = Utils.getIdFromPath("/");
        Map<String, Object> map = this.store.find(DocumentStore.Collection.NODES, id, this.asyncDelay);
        Map lastRevMap = (Map)map.get("_lastRev");
        boolean hasNewRevisions = false;
        Revision headSeen = Revision.newRevision(0);
        Revision otherSeen = Revision.newRevision(0);
        for (Map.Entry e : lastRevMap.entrySet()) {
            int machineId = Integer.parseInt((String)e.getKey());
            if (machineId == this.clusterId) continue;
            Revision r = Revision.fromString((String)e.getValue());
            Revision last = this.lastKnownRevision.get(machineId);
            if (last != null && r.compareRevisionTime(last) <= 0) continue;
            this.lastKnownRevision.put(machineId, r);
            hasNewRevisions = true;
            this.revisionComparator.add(r, otherSeen);
        }
        if (hasNewRevisions) {
            this.store.invalidateCache();
            Revision r = Revision.newRevision(this.clusterId);
            this.revisionComparator.add(r, headSeen);
            this.headRevision = Revision.newRevision(this.clusterId);
        }
        this.revisionComparator.purge(Revision.getCurrentTimestamp() - 3600000L);
    }

    void backgroundWrite() {
        if (this.unsavedLastRevisions.size() == 0) {
            return;
        }
        ArrayList<String> paths = new ArrayList<String>(this.unsavedLastRevisions.keySet());
        Collections.sort(paths, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int d2;
                int d1 = Utils.pathDepth(o1);
                if (d1 != (d2 = Utils.pathDepth(o1))) {
                    return Integer.signum(d1 - d2);
                }
                return o1.compareTo(o2);
            }
        });
        long now = Revision.getCurrentTimestamp();
        for (String p : paths) {
            Revision r = this.unsavedLastRevisions.get(p);
            if (r == null || Revision.getTimestampDifference(now, r.getTimestamp()) < (long)this.asyncDelay) continue;
            Commit commit = new Commit(this, null, r);
            commit.touchNode(p);
            this.store.createOrUpdate(DocumentStore.Collection.NODES, commit.getUpdateOperationForNode(p));
            this.unsavedLastRevisions.remove(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.asyncDelay = 0;
        this.runBackgroundOperations();
        if (!this.isDisposed.getAndSet(true)) {
            AtomicBoolean atomicBoolean = this.isDisposed;
            synchronized (atomicBoolean) {
                this.isDisposed.notifyAll();
            }
            try {
                this.backgroundThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.clusterNodeInfo != null) {
                this.clusterNodeInfo.dispose();
            }
            this.store.dispose();
        }
    }

    Node getNode(String path, Revision rev) {
        this.checkRevisionAge(rev, path);
        String key = path + "@" + rev;
        Node node = (Node)this.nodeCache.getIfPresent((Object)key);
        if (node == null && (node = this.readNode(path, rev)) != null) {
            this.nodeCache.put((Object)key, (Object)node);
        }
        return node;
    }

    private void checkRevisionAge(Revision r, String path) {
        if (LOG.isDebugEnabled() && this.headRevision.getTimestamp() - r.getTimestamp() > (long)WARN_REVISION_AGE) {
            LOG.debug("Requesting an old revision for path " + path + ", " + (this.headRevision.getTimestamp() - r.getTimestamp()) / 1000L + " seconds old");
        }
    }

    private boolean includeRevision(Revision x, Revision requestRevision) {
        Branch b = this.branches.getBranch(x);
        if (b != null) {
            if (b.containsCommit(requestRevision)) {
                return x.equals(requestRevision) || this.isRevisionNewer(requestRevision, x);
            }
            return false;
        }
        b = this.branches.getBranch(requestRevision);
        if (b != null) {
            requestRevision = b.getBase();
        }
        return this.revisionComparator.compare(requestRevision, x) >= 0;
    }

    boolean isRevisionNewer(@Nonnull Revision x, @Nonnull Revision previous) {
        return this.revisionComparator.compare(x, previous) > 0;
    }

    boolean isValidRevision(@Nonnull Revision rev, @Nonnull Revision readRevision, @Nonnull Map<String, Object> nodeMap, @Nonnull Set<Revision> validRevisions) {
        Integer depth;
        if (validRevisions.contains(rev)) {
            return true;
        }
        Map revisions = (Map)nodeMap.get("_revisions");
        if (this.isCommitted(rev, readRevision, revisions)) {
            validRevisions.add(rev);
            return true;
        }
        if (revisions != null && revisions.containsKey(rev.toString())) {
            return false;
        }
        Map commitRoot = (Map)nodeMap.get("_commitRoot");
        String commitRootPath = null;
        if (commitRoot != null && (depth = (Integer)commitRoot.get(rev.toString())) != null) {
            String p = Utils.getPathFromId((String)nodeMap.get("_id"));
            commitRootPath = PathUtils.getAncestorPath((String)p, (int)(PathUtils.getDepth((String)p) - depth));
        }
        if (commitRootPath == null) {
            LOG.warn("Node {} does not have commit root reference for revision {}", nodeMap.get("_id"), (Object)rev);
            LOG.warn(nodeMap.toString());
            return false;
        }
        nodeMap = this.store.find(DocumentStore.Collection.NODES, Utils.getIdFromPath(commitRootPath));
        if (nodeMap == null) {
            return false;
        }
        Map rootRevisions = (Map)nodeMap.get("_revisions");
        if (this.isCommitted(rev, readRevision, rootRevisions)) {
            validRevisions.add(rev);
            return true;
        }
        return false;
    }

    private boolean isCommitted(@Nonnull Revision revision, @Nonnull Revision readRevision, @Nullable Map<String, String> revisions) {
        if (revision.equals(readRevision)) {
            return true;
        }
        if (revisions == null) {
            return false;
        }
        String value = revisions.get(revision.toString());
        if (value == null) {
            return false;
        }
        if (value.equals("true")) {
            if (this.branches.getBranch(readRevision) == null) {
                return true;
            }
        } else if (Revision.fromString(value).getClusterId() != this.clusterId) {
            return false;
        }
        return this.includeRevision(revision, readRevision);
    }

    public Node.Children getChildren(String path, Revision rev, int limit) {
        this.checkRevisionAge(rev, path);
        String key = path + "@" + rev;
        Node.Children children = (Node.Children)this.nodeChildrenCache.getIfPresent((Object)key);
        if (children == null && (children = this.readChildren(path, rev, limit)) != null) {
            this.nodeChildrenCache.put((Object)key, (Object)children);
        }
        return children;
    }

    Node.Children readChildren(String path, Revision rev, int limit) {
        String from = PathUtils.concat((String)path, (String)"a");
        from = Utils.getIdFromPath(from);
        from = from.substring(0, from.length() - 1);
        String to = PathUtils.concat((String)path, (String)"z");
        to = Utils.getIdFromPath(to);
        to = to.substring(0, to.length() - 2) + "0";
        List<Map<String, Object>> list = this.store.query(DocumentStore.Collection.NODES, from, to, limit);
        Node.Children c = new Node.Children(path, rev);
        HashSet<Revision> validRevisions = new HashSet<Revision>();
        for (Map<String, Object> e : list) {
            if (this.getLiveRevision(e, rev, validRevisions) == null) continue;
            String id = e.get("_id").toString();
            String p = Utils.getPathFromId(id);
            c.children.add(p);
        }
        return c;
    }

    private Node readNode(String path, Revision rev) {
        String id = Utils.getIdFromPath(path);
        Map<String, Object> map = this.store.find(DocumentStore.Collection.NODES, id);
        if (map == null) {
            return null;
        }
        Revision min = this.getLiveRevision(map, rev);
        if (min == null) {
            return null;
        }
        Node n = new Node(path, rev);
        Revision lastRevision = null;
        Revision revision = this.unsavedLastRevisions.get(path);
        if (revision != null) {
            if (this.isRevisionNewer(revision, rev)) {
                revision = rev;
            }
            lastRevision = revision;
        }
        for (String key : map.keySet()) {
            NavigableMap<String, String> valueMap;
            Object v;
            if (key.equals("_lastRev")) {
                v = map.get(key);
                valueMap = (NavigableMap<String, String>)v;
                for (String r : valueMap.keySet()) {
                    revision = Revision.fromString((String)valueMap.get(r));
                    if (this.isRevisionNewer(revision, rev)) {
                        revision = rev;
                    }
                    if (lastRevision != null && !this.isRevisionNewer(revision, lastRevision)) continue;
                    lastRevision = revision;
                }
            }
            if (!Utils.isPropertyName(key) || (valueMap = (Map)(v = map.get(key))) == null) continue;
            if (valueMap instanceof TreeMap) {
                valueMap = ((TreeMap)valueMap).descendingMap();
            }
            String value = this.getLatestValue(valueMap, min, rev);
            String propertyName = Utils.unescapePropertyName(key);
            n.setProperty(propertyName, value);
        }
        n.setLastRevision(lastRevision);
        return n;
    }

    private String getLatestValue(@Nonnull Map<String, String> valueMap, @Nullable Revision min, @Nonnull Revision max) {
        String value = null;
        Revision latestRev = null;
        for (String r : valueMap.keySet()) {
            Revision propRev = Revision.fromString(r);
            if (min != null && this.isRevisionNewer(min, propRev) || latestRev != null && !this.isRevisionNewer(propRev, latestRev) || !this.includeRevision(propRev, max)) continue;
            latestRev = propRev;
            value = valueMap.get(r);
        }
        return value;
    }

    public String getHeadRevision() throws MicroKernelException {
        return this.headRevision.toString();
    }

    public String getRevisionHistory(long since, int maxEntries, String path) throws MicroKernelException {
        throw new MicroKernelException("Not implemented");
    }

    public String waitForCommit(String oldHeadRevisionId, long timeout) throws MicroKernelException, InterruptedException {
        throw new MicroKernelException("Not implemented");
    }

    public String getJournal(String fromRevisionId, String toRevisionId, String path) throws MicroKernelException {
        throw new MicroKernelException("Not implemented");
    }

    public String diff(String fromRevisionId, String toRevisionId, String path, int depth) throws MicroKernelException {
        if (fromRevisionId.equals(toRevisionId)) {
            return "";
        }
        if (depth != 0) {
            throw new MicroKernelException("Only depth 0 is supported, depth is " + depth);
        }
        if (path == null || path.equals("")) {
            path = "/";
        }
        fromRevisionId = MongoMK.stripBranchRevMarker(fromRevisionId);
        toRevisionId = MongoMK.stripBranchRevMarker(toRevisionId);
        Node from = this.getNode(path, Revision.fromString(fromRevisionId));
        Node to = this.getNode(path, Revision.fromString(toRevisionId));
        if (from == null || to == null) {
            throw new MicroKernelException("Diff is only supported if the node exists in both cases");
        }
        JsopStream w = new JsopStream();
        for (String p : from.getPropertyNames()) {
            String toValue;
            String fromValue = from.getProperty(p);
            if (fromValue.equals(toValue = to.getProperty(p))) continue;
            w.tag('^').key(p);
            if (toValue == null) {
                w.value(toValue);
                continue;
            }
            w.encodedValue(toValue).newline();
        }
        for (String p : to.getPropertyNames()) {
            if (from.getProperty(p) != null) continue;
            w.tag('^').key(p).encodedValue(to.getProperty(p)).newline();
        }
        Revision fromRev = Revision.fromString(fromRevisionId);
        Revision toRev = Revision.fromString(toRevisionId);
        Node.Children fromChildren = this.getChildren(path, fromRev, Integer.MAX_VALUE);
        Node.Children toChildren = this.getChildren(path, toRev, Integer.MAX_VALUE);
        HashSet<String> childrenSet = new HashSet<String>(toChildren.children);
        for (String n : fromChildren.children) {
            if (!childrenSet.contains(n)) {
                w.tag('-').value(n).newline();
                continue;
            }
            Node n1 = this.getNode(n, fromRev);
            Node n2 = this.getNode(n, toRev);
            if (n1.getId().equals(n2.getId())) continue;
            w.tag('^').key(n).object().endObject().newline();
        }
        childrenSet = new HashSet<String>(fromChildren.children);
        for (String n : toChildren.children) {
            if (childrenSet.contains(n)) continue;
            w.tag('+').key(n).object().endObject().newline();
        }
        return w.toString();
    }

    public boolean nodeExists(String path, String revisionId) throws MicroKernelException {
        if (!PathUtils.isAbsolute((String)path)) {
            throw new MicroKernelException("Path is not absolute: " + path);
        }
        revisionId = revisionId != null ? revisionId : this.headRevision.toString();
        Revision rev = Revision.fromString(MongoMK.stripBranchRevMarker(revisionId));
        Node n = this.getNode(path, rev);
        return n != null;
    }

    public long getChildNodeCount(String path, String revisionId) throws MicroKernelException {
        throw new MicroKernelException("Not implemented");
    }

    public synchronized String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) throws MicroKernelException {
        Revision rev;
        Node n;
        if (depth != 0) {
            throw new MicroKernelException("Only depth 0 is supported, depth is " + depth);
        }
        String string = revisionId = revisionId != null ? revisionId : this.headRevision.toString();
        if (revisionId.startsWith("b")) {
            revisionId = MongoMK.stripBranchRevMarker(revisionId);
        }
        if ((n = this.getNode(path, rev = Revision.fromString(revisionId))) == null) {
            return null;
        }
        JsopStream json = new JsopStream();
        boolean includeId = filter != null && filter.contains(":id");
        boolean bl = filter != null && filter.contains(":hash");
        json.object();
        n.append((JsopWriter)json, includeId |= bl);
        if (maxChildNodes == -1) {
            maxChildNodes = Integer.MAX_VALUE;
        }
        Node.Children c = this.getChildren(path, rev, Integer.MAX_VALUE);
        for (long i = offset; i < (long)c.children.size() && maxChildNodes-- > 0; ++i) {
            String name = PathUtils.getName((String)c.children.get((int)i));
            json.key(name).object().endObject();
        }
        json.key(":childNodeCount").value((long)c.children.size());
        json.endObject();
        String result = json.toString();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String commit(String rootPath, String json, String baseRevId, String message) throws MicroKernelException {
        int r;
        Revision baseRev;
        if (baseRevId == null) {
            baseRev = this.headRevision;
            baseRevId = baseRev.toString();
        } else {
            baseRev = Revision.fromString(MongoMK.stripBranchRevMarker(baseRevId));
        }
        JsopTokenizer t = new JsopTokenizer(json);
        Revision rev = this.newRevision();
        Commit commit = new Commit(this, baseRev, rev);
        block10: while ((r = t.read()) != 0) {
            String path = PathUtils.concat((String)rootPath, (String)t.readString());
            switch (r) {
                case 43: {
                    t.read(58);
                    t.read(123);
                    MongoMK.parseAddNode(commit, (JsopReader)t, path);
                    continue block10;
                }
                case 45: {
                    commit.removeNode(path);
                    this.markAsDeleted(path, commit, true);
                    commit.removeNodeDiff(path);
                    continue block10;
                }
                case 94: {
                    t.read(58);
                    String value = t.matches(5) ? null : t.readRawValue().trim();
                    String p = PathUtils.getParentPath((String)path);
                    String propertyName = PathUtils.getName((String)path);
                    commit.updateProperty(p, propertyName, value);
                    commit.updatePropertyDiff(p, propertyName, value);
                    continue block10;
                }
                case 62: {
                    t.read(58);
                    String sourcePath = path;
                    String targetPath = t.readString();
                    if (!PathUtils.isAbsolute((String)targetPath)) {
                        targetPath = PathUtils.concat((String)rootPath, (String)targetPath);
                    }
                    if (!this.nodeExists(sourcePath, baseRevId)) {
                        throw new MicroKernelException("Node not found: " + sourcePath + " in revision " + baseRevId);
                    }
                    if (this.nodeExists(targetPath, baseRevId)) {
                        throw new MicroKernelException("Node already exists: " + targetPath + " in revision " + baseRevId);
                    }
                    commit.moveNode(sourcePath, targetPath);
                    this.moveNode(sourcePath, targetPath, baseRev, commit);
                    continue block10;
                }
                case 42: {
                    t.read(58);
                    String sourcePath = path;
                    String targetPath = t.readString();
                    if (!PathUtils.isAbsolute((String)targetPath)) {
                        targetPath = PathUtils.concat((String)rootPath, (String)targetPath);
                    }
                    if (!this.nodeExists(sourcePath, baseRevId)) {
                        throw new MicroKernelException("Node not found: " + sourcePath + " in revision " + baseRevId);
                    }
                    if (this.nodeExists(targetPath, baseRevId)) {
                        throw new MicroKernelException("Node already exists: " + targetPath + " in revision " + baseRevId);
                    }
                    commit.copyNode(sourcePath, targetPath);
                    this.copyNode(sourcePath, targetPath, baseRev, commit);
                    continue block10;
                }
            }
            throw new MicroKernelException("token: " + (char)t.getTokenType());
        }
        if (baseRevId.startsWith("b")) {
            Branch b = this.branches.getBranch(baseRev);
            if (b == null) {
                b = this.branches.create(baseRev, rev);
            } else {
                b.addCommit(rev);
            }
            boolean success = false;
            try {
                commit.prepare(baseRev);
                success = true;
            }
            finally {
                if (!success) {
                    b.removeCommit(rev);
                    if (b.getCommits().isEmpty()) {
                        this.branches.remove(b);
                    }
                }
            }
            return "b" + rev.toString();
        }
        commit.apply();
        this.headRevision = commit.getRevision();
        return rev.toString();
    }

    private void copyNode(String sourcePath, String targetPath, Revision baseRev, Commit commit) {
        this.moveOrCopyNode(false, sourcePath, targetPath, baseRev, commit);
    }

    private void moveNode(String sourcePath, String targetPath, Revision baseRev, Commit commit) {
        this.moveOrCopyNode(true, sourcePath, targetPath, baseRev, commit);
    }

    private void moveOrCopyNode(boolean move, String sourcePath, String targetPath, Revision baseRev, Commit commit) {
        Node n = this.getNode(sourcePath, baseRev);
        if (n == null) {
            return;
        }
        Node newNode = new Node(targetPath, commit.getRevision());
        n.copyTo(newNode);
        commit.addNode(newNode);
        if (move) {
            this.markAsDeleted(sourcePath, commit, false);
        }
        Node.Children c = this.getChildren(sourcePath, baseRev, Integer.MAX_VALUE);
        for (String srcChildPath : c.children) {
            String childName = PathUtils.getName((String)srcChildPath);
            String destChildPath = PathUtils.concat((String)targetPath, (String)childName);
            this.moveOrCopyNode(move, srcChildPath, destChildPath, baseRev, commit);
        }
    }

    private void markAsDeleted(String path, Commit commit, boolean subTreeAlso) {
        Revision rev = commit.getRevision();
        commit.removeNode(path);
        if (subTreeAlso) {
            Node n = this.getNode(path, rev);
            this.nodeCache.invalidate((Object)(path + "@" + rev));
            if (n != null) {
                Node.Children c = this.getChildren(path, rev, Integer.MAX_VALUE);
                for (String childPath : c.children) {
                    this.markAsDeleted(childPath, commit, true);
                }
                this.nodeChildrenCache.invalidate((Object)n.getId());
            }
        }
        this.nodeCache.invalidate((Object)(path + "@" + rev));
    }

    private Revision getLiveRevision(Map<String, Object> nodeMap, Revision maxRev) {
        return this.getLiveRevision(nodeMap, maxRev, new HashSet<Revision>());
    }

    private Revision getLiveRevision(Map<String, Object> nodeMap, Revision maxRev, Set<Revision> validRevisions) {
        NavigableMap valueMap = (NavigableMap)nodeMap.get("_deleted");
        if (valueMap == null) {
            return null;
        }
        Revision deletedRev = null;
        if (valueMap instanceof TreeMap) {
            valueMap = ((TreeMap)valueMap).descendingMap();
        }
        for (String r : valueMap.keySet()) {
            Revision propRev;
            String value = (String)valueMap.get(r);
            if (!"true".equals(value) || this.isRevisionNewer(propRev = Revision.fromString(r), maxRev) || !this.isValidRevision(propRev, maxRev, nodeMap, validRevisions) || deletedRev != null && !this.isRevisionNewer(propRev, deletedRev)) continue;
            deletedRev = propRev;
        }
        Revision liveRev = null;
        for (String r : valueMap.keySet()) {
            String value = (String)valueMap.get(r);
            if ("true".equals(value)) continue;
            Revision propRev = Revision.fromString(r);
            if (deletedRev != null && this.isRevisionNewer(deletedRev, propRev) || this.isRevisionNewer(propRev, maxRev) || !this.isValidRevision(propRev, maxRev, nodeMap, validRevisions) || liveRev != null && !this.isRevisionNewer(liveRev, propRev)) continue;
            liveRev = propRev;
        }
        return liveRev;
    }

    @Nullable
    Revision getNewestRevision(Map<String, Object> nodeMap, Revision changeRev, CollisionHandler handler) {
        String value;
        Map deletedMap;
        if (nodeMap == null) {
            return null;
        }
        TreeSet revisions = new TreeSet(Collections.reverseOrder());
        if (nodeMap.containsKey("_revisions")) {
            revisions.addAll(((Map)nodeMap.get("_revisions")).keySet());
        }
        if (nodeMap.containsKey("_commitRoot")) {
            revisions.addAll(((Map)nodeMap.get("_commitRoot")).keySet());
        }
        if ((deletedMap = (Map)nodeMap.get("_deleted")) != null) {
            revisions.addAll(deletedMap.keySet());
        }
        Revision newestRev = null;
        for (String r : revisions) {
            Revision propRev = Revision.fromString(r);
            if (this.isRevisionNewer(propRev, changeRev)) {
                this.publishRevision(propRev, changeRev);
            }
            if (newestRev != null && !this.isRevisionNewer(propRev, newestRev) || propRev.equals(changeRev)) continue;
            if (!this.isValidRevision(propRev, changeRev, nodeMap, new HashSet<Revision>())) {
                handler.uncommittedModification(propRev);
                continue;
            }
            newestRev = propRev;
        }
        if (newestRev == null) {
            return null;
        }
        if (deletedMap != null && "true".equals(value = (String)deletedMap.get(newestRev.toString()))) {
            return null;
        }
        return newestRev;
    }

    private void publishRevision(Revision foreignRevision, Revision changeRevision) {
        if (this.revisionComparator.compare(this.headRevision, foreignRevision) >= 0) {
            return;
        }
        int clusterNodeId = foreignRevision.getClusterId();
        if (clusterNodeId == this.clusterId) {
            return;
        }
        Revision headSeen = Revision.newRevision(0);
        Revision otherSeen = Revision.newRevision(0);
        Revision changeSeen = Revision.newRevision(0);
        this.revisionComparator.add(foreignRevision, otherSeen);
        this.store.invalidateCache();
        this.revisionComparator.add(this.headRevision, headSeen);
        this.revisionComparator.add(changeRevision, changeSeen);
        this.headRevision = Revision.newRevision(this.clusterId);
    }

    private static String stripBranchRevMarker(String revisionId) {
        if (revisionId.startsWith("b")) {
            return revisionId.substring(1);
        }
        return revisionId;
    }

    public static void parseAddNode(Commit commit, JsopReader t, String path) {
        Node n = new Node(path, commit.getRevision());
        if (!t.matches(125)) {
            do {
                String key = t.readString();
                t.read(58);
                if (t.matches(123)) {
                    String childPath = PathUtils.concat((String)path, (String)key);
                    MongoMK.parseAddNode(commit, t, childPath);
                    continue;
                }
                String value = t.readRawValue().trim();
                n.setProperty(key, value);
            } while (t.matches(44));
            t.read(125);
        }
        commit.addNode(n);
        commit.addNodeDiff(n);
    }

    public String branch(@Nullable String trunkRevisionId) throws MicroKernelException {
        String revisionId = trunkRevisionId != null ? trunkRevisionId : this.headRevision.toString();
        return "b" + revisionId;
    }

    public synchronized String merge(String branchRevisionId, String message) throws MicroKernelException {
        if (!branchRevisionId.startsWith("b")) {
            throw new MicroKernelException("Not a branch: " + branchRevisionId);
        }
        String revisionId = MongoMK.stripBranchRevMarker(branchRevisionId);
        UpdateOp op = new UpdateOp("/", Utils.getIdFromPath("/"), false);
        Revision revision = Revision.fromString(revisionId);
        Branch b = this.branches.getBranch(revision);
        if (b != null) {
            for (Revision rev : b.getCommits()) {
                op.setMapEntry("_revisions", rev.toString(), "true");
                op.containsMapEntry("_collisions", rev.toString(), false);
            }
            if (this.store.findAndUpdate(DocumentStore.Collection.NODES, op) != null) {
                this.branches.remove(b);
            } else {
                throw new MicroKernelException("Conflicting concurrent change");
            }
        }
        this.headRevision = this.newRevision();
        return this.headRevision.toString();
    }

    @Nonnull
    public String rebase(String branchRevisionId, String newBaseRevisionId) throws MicroKernelException {
        return branchRevisionId;
    }

    public long getLength(String blobId) throws MicroKernelException {
        try {
            return this.blobStore.getBlobLength(blobId);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public int read(String blobId, long pos, byte[] buff, int off, int length) throws MicroKernelException {
        try {
            return this.blobStore.readBlob(blobId, pos, buff, off, length);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String write(InputStream in) throws MicroKernelException {
        try {
            return this.blobStore.writeBlob(in);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public DocumentStore getDocumentStore() {
        return this.store;
    }

    public void setAsyncDelay(int delay) {
        this.asyncDelay = delay;
    }

    public int getAsyncDelay() {
        return this.asyncDelay;
    }

    public void applyChanges(Revision rev, String path, boolean isNew, boolean isDelete, boolean isWritten, ArrayList<String> added, ArrayList<String> removed) {
        if (!isWritten) {
            Revision prev = this.unsavedLastRevisions.put(path, rev);
            if (prev != null && this.isRevisionNewer(prev, rev)) {
                this.unsavedLastRevisions.put(path, prev);
                String msg = String.format("Attempt to update unsavedLastRevision for %s with %s, which is older than current %s.", path, rev, prev);
                throw new MicroKernelException(msg);
            }
        } else {
            this.unsavedLastRevisions.remove(path);
        }
        Node.Children c = (Node.Children)this.nodeChildrenCache.getIfPresent((Object)(path + "@" + rev));
        if (isNew || !isDelete && c != null) {
            String key = path + "@" + rev;
            Node.Children c2 = new Node.Children(path, rev);
            TreeSet<String> set = new TreeSet<String>();
            if (c != null) {
                set.addAll(c.children);
            }
            set.removeAll(removed);
            set.addAll(added);
            c2.children.addAll(set);
            this.nodeChildrenCache.put((Object)key, (Object)c2);
        }
    }

    public ClusterNodeInfo getClusterInfo() {
        return this.clusterNodeInfo;
    }

    public int getPendingWriteCount() {
        return this.unsavedLastRevisions.size();
    }

    public boolean isCached(String path) {
        return this.store.isCached(DocumentStore.Collection.NODES, Utils.getIdFromPath(path));
    }

    public void stopBackground() {
        this.stopBackground = true;
    }

    Revision.RevisionComparator getRevisionComparator() {
        return this.revisionComparator;
    }

    public static class Builder {
        private DocumentStore documentStore;
        private BlobStore blobStore;
        private int clusterId = Integer.getInteger("oak.mongoMK.clusterId", 0);
        private int asyncDelay = 1000;

        public Builder setMongoDB(DB db) {
            if (db != null) {
                this.documentStore = new MongoDocumentStore(db);
                this.blobStore = new MongoBlobStore(db);
            }
            return this;
        }

        public Builder setDocumentStore(DocumentStore documentStore) {
            this.documentStore = documentStore;
            return this;
        }

        public DocumentStore getDocumentStore() {
            if (this.documentStore == null) {
                this.documentStore = new MemoryDocumentStore();
            }
            return this.documentStore;
        }

        public Builder setBlobStore(BlobStore blobStore) {
            this.blobStore = blobStore;
            return this;
        }

        public BlobStore getBlobStore() {
            if (this.blobStore == null) {
                this.blobStore = new MemoryBlobStore();
            }
            return this.blobStore;
        }

        public Builder setClusterId(int clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public int getClusterId() {
            return this.clusterId;
        }

        public Builder setAsyncDelay(int asyncDelay) {
            this.asyncDelay = asyncDelay;
            return this;
        }

        public int getAsyncDelay() {
            return this.asyncDelay;
        }

        public MongoMK open() {
            return new MongoMK(this);
        }
    }

    static class BackgroundOperation
    implements Runnable {
        final WeakReference<MongoMK> ref;
        private final AtomicBoolean isDisposed;
        private int delay;

        BackgroundOperation(MongoMK mk, AtomicBoolean isDisposed) {
            this.ref = new WeakReference<MongoMK>(mk);
            this.delay = mk.getAsyncDelay();
            this.isDisposed = isDisposed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.delay != 0 && !this.isDisposed.get()) {
                AtomicBoolean atomicBoolean = this.isDisposed;
                synchronized (atomicBoolean) {
                    try {
                        this.isDisposed.wait(this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                MongoMK mk = (MongoMK)this.ref.get();
                if (mk == null) continue;
                mk.runBackgroundOperations();
                this.delay = mk.getAsyncDelay();
            }
        }
    }
}

