/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.mk.json.JsopWriter;
import org.apache.jackrabbit.mongomk.Revision;
import org.apache.jackrabbit.mongomk.UpdateOp;
import org.apache.jackrabbit.mongomk.util.Utils;

public class Node {
    final String path;
    final Revision rev;
    final Map<String, String> properties = Utils.newMap();
    Revision lastRevision;

    Node(String path, Revision rev) {
        this.path = path;
        this.rev = rev;
    }

    void setProperty(String propertyName, String value) {
        if (value == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, value);
        }
    }

    public String getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public void copyTo(Node newNode) {
        newNode.properties.putAll(this.properties);
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("path: ").append(this.path).append('\n');
        buff.append("rev: ").append(this.rev).append('\n');
        buff.append(this.properties);
        buff.append('\n');
        return buff.toString();
    }

    UpdateOp asOperation(boolean isNew) {
        String id = Utils.getIdFromPath(this.path);
        UpdateOp op = new UpdateOp(this.path, id, isNew);
        op.set("_id", id);
        op.setMapEntry("_deleted", this.rev.toString(), "false");
        op.setMapEntry("_lastRev", "" + this.rev.getClusterId(), this.rev.toString());
        for (String p : this.properties.keySet()) {
            String key = Utils.escapePropertyName(p);
            op.setMapEntry(key, this.rev.toString(), this.properties.get(p));
        }
        return op;
    }

    public String getId() {
        return this.path + "@" + this.lastRevision;
    }

    public void append(JsopWriter json, boolean includeId) {
        if (includeId) {
            json.key(":id").value(this.getId());
        }
        for (String p : this.properties.keySet()) {
            json.key(p).encodedValue(this.properties.get(p));
        }
    }

    public void setLastRevision(Revision lastRevision) {
        this.lastRevision = lastRevision;
    }

    public int getMemory() {
        int size = 180 + this.path.length() * 2;
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            size += 136 + e.getKey().length() * 2 + e.getValue().length() * 2;
        }
        return size;
    }

    static class Children {
        final String path;
        final Revision rev;
        final ArrayList<String> children = new ArrayList();

        Children(String path, Revision rev) {
            this.path = path;
            this.rev = rev;
        }

        public String toString() {
            return this.path + ": " + this.children.toString();
        }
    }
}

