/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.blob.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.jackrabbit.mongomk.blob.gridfs.BaseCommand;

public class WriteBlobCommandGridFS
extends BaseCommand<String> {
    private final GridFS gridFS;
    private final InputStream is;

    public WriteBlobCommandGridFS(GridFS gridFS, InputStream is) {
        this.gridFS = gridFS;
        this.is = is;
    }

    @Override
    public String execute() throws Exception {
        return this.saveBlob();
    }

    private String saveBlob() throws IOException {
        BufferedInputStream bis = new BufferedInputStream(this.is);
        String md5 = WriteBlobCommandGridFS.calculateMd5(bis);
        GridFSDBFile gridFile = this.gridFS.findOne((DBObject)new BasicDBObject("md5", (Object)md5));
        if (gridFile != null) {
            this.is.close();
            return md5;
        }
        GridFSInputFile gridFSInputFile = this.gridFS.createFile((InputStream)bis, true);
        gridFSInputFile.save();
        return gridFSInputFile.getMD5();
    }

    private static String calculateMd5(BufferedInputStream bis) throws IOException {
        bis.mark(Integer.MAX_VALUE);
        String md5 = DigestUtils.md5Hex((InputStream)bis);
        bis.reset();
        return md5;
    }
}

