/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.util;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mongomk.DocumentStore;
import org.apache.jackrabbit.mongomk.UpdateOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDocumentStoreWrapper
implements DocumentStore {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingDocumentStoreWrapper.class);
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("ds.debug", "true"));
    private final DocumentStore store;

    public LoggingDocumentStoreWrapper(DocumentStore store) {
        this.store = store;
    }

    @Override
    public Map<String, Object> find(DocumentStore.Collection collection, String key) {
        try {
            LoggingDocumentStoreWrapper.logMethod("find", new Object[]{collection, key});
            return LoggingDocumentStoreWrapper.logResult(this.store.find(collection, key));
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public Map<String, Object> find(DocumentStore.Collection collection, String key, int maxCacheAge) {
        try {
            LoggingDocumentStoreWrapper.logMethod("find", new Object[]{collection, key, maxCacheAge});
            return LoggingDocumentStoreWrapper.logResult(this.store.find(collection, key, maxCacheAge));
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    @Nonnull
    public List<Map<String, Object>> query(DocumentStore.Collection collection, String fromKey, String toKey, int limit) {
        try {
            LoggingDocumentStoreWrapper.logMethod("query", new Object[]{collection, fromKey, toKey, limit});
            return LoggingDocumentStoreWrapper.logResult(this.store.query(collection, fromKey, toKey, limit));
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public void remove(DocumentStore.Collection collection, String key) {
        try {
            LoggingDocumentStoreWrapper.logMethod("remove", new Object[]{collection, key});
            this.store.remove(collection, key);
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public boolean create(DocumentStore.Collection collection, List<UpdateOp> updateOps) {
        try {
            LoggingDocumentStoreWrapper.logMethod("create", new Object[]{collection, updateOps});
            return LoggingDocumentStoreWrapper.logResult(this.store.create(collection, updateOps));
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    @Nonnull
    public Map<String, Object> createOrUpdate(DocumentStore.Collection collection, UpdateOp update) throws MicroKernelException {
        try {
            LoggingDocumentStoreWrapper.logMethod("createOrUpdate", new Object[]{collection, update});
            return LoggingDocumentStoreWrapper.logResult(this.store.createOrUpdate(collection, update));
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public Map<String, Object> findAndUpdate(DocumentStore.Collection collection, UpdateOp update) throws MicroKernelException {
        try {
            LoggingDocumentStoreWrapper.logMethod("findAndUpdate", new Object[]{collection, update});
            return LoggingDocumentStoreWrapper.logResult(this.store.findAndUpdate(collection, update));
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public void invalidateCache() {
        try {
            LoggingDocumentStoreWrapper.logMethod("invalidateCache", new Object[0]);
            this.store.invalidateCache();
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public void invalidateCache(DocumentStore.Collection collection, String key) {
        try {
            LoggingDocumentStoreWrapper.logMethod("invalidateCache", new Object[]{collection, key});
            this.store.invalidateCache(collection, key);
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public void dispose() {
        try {
            LoggingDocumentStoreWrapper.logMethod("dispose", new Object[0]);
            this.store.dispose();
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    @Override
    public boolean isCached(DocumentStore.Collection collection, String key) {
        try {
            LoggingDocumentStoreWrapper.logMethod("isCached", new Object[]{collection, key});
            return LoggingDocumentStoreWrapper.logResult(this.store.isCached(collection, key));
        }
        catch (Exception e) {
            LoggingDocumentStoreWrapper.logException(e);
            throw LoggingDocumentStoreWrapper.convert(e);
        }
    }

    private static void logMethod(String methodName, Object ... args) {
        StringBuilder buff = new StringBuilder("ds");
        buff.append('.').append(methodName).append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(LoggingDocumentStoreWrapper.quote(args[i]));
        }
        buff.append(");");
        LoggingDocumentStoreWrapper.log(buff.toString());
    }

    public static String quote(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return JsopBuilder.encode((String)((String)o));
        }
        return o.toString();
    }

    private static RuntimeException convert(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        LoggingDocumentStoreWrapper.log("// unexpected exception type: " + e.getClass().getName());
        return new MicroKernelException("Unexpected exception: " + e.toString(), (Throwable)e);
    }

    private static void logException(Exception e) {
        LoggingDocumentStoreWrapper.log("// exception: " + e.toString());
    }

    private static <T> T logResult(T result) {
        LoggingDocumentStoreWrapper.log("// " + LoggingDocumentStoreWrapper.quote(result));
        return result;
    }

    private static void log(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
        LOG.info(message);
    }
}

