/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.json.JsopBuilder;

public class TimingWrapper
implements MicroKernel {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("mk.debug", "true"));
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    private final MicroKernel mk;
    private final int id = NEXT_ID.getAndIncrement();
    private long startTime;
    private final Map<String, Count> counts = new HashMap<String, Count>();
    private long lastLogTime;

    public TimingWrapper(MicroKernel mk) {
        this.mk = mk;
        this.counts.put("commit", new Count());
        this.counts.put("getHeadRevision", new Count());
        this.counts.put("getJournal", new Count());
        this.counts.put("diff", new Count());
        this.counts.put("getLength", new Count());
        this.counts.put("getNodes", new Count());
        this.counts.put("getRevisionHistory", new Count());
        this.counts.put("nodeExists", new Count());
        this.counts.put("getChildNodeCount", new Count());
        this.counts.put("read", new Count());
        this.counts.put("waitForCommit", new Count());
        this.counts.put("write", new Count());
        this.counts.put("branch", new Count());
        this.counts.put("merge", new Count());
    }

    public String commit(String path, String jsonDiff, String revisionId, String message) {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.commit(path, jsonDiff, revisionId, message);
            this.updateAndLogTimes("commit", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public void dispose() {
    }

    public String getHeadRevision() {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.getHeadRevision();
            this.updateAndLogTimes("getHeadRevision", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public String getJournal(String fromRevisionId, String toRevisionId, String path) {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.getJournal(fromRevisionId, toRevisionId, path);
            this.updateAndLogTimes("getJournal", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public String diff(String fromRevisionId, String toRevisionId, String path, int depth) {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.diff(fromRevisionId, toRevisionId, path, depth);
            this.updateAndLogTimes("diff", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public long getLength(String blobId) {
        try {
            long start = System.currentTimeMillis();
            long result = this.mk.getLength(blobId);
            this.updateAndLogTimes("getLength", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.getNodes(path, revisionId, depth, offset, maxChildNodes, filter);
            this.updateAndLogTimes("getNodes", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public String getRevisionHistory(long since, int maxEntries, String path) {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.getRevisionHistory(since, maxEntries, path);
            this.updateAndLogTimes("getRevisionHistory", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public boolean nodeExists(String path, String revisionId) {
        try {
            long start = System.currentTimeMillis();
            boolean result = this.mk.nodeExists(path, revisionId);
            this.updateAndLogTimes("nodeExists", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public long getChildNodeCount(String path, String revisionId) {
        try {
            long start = System.currentTimeMillis();
            long result = this.mk.getChildNodeCount(path, revisionId);
            this.updateAndLogTimes("getChildNodeCount", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public int read(String blobId, long pos, byte[] buff, int off, int length) {
        try {
            long start = System.currentTimeMillis();
            int result = this.mk.read(blobId, pos, buff, off, length);
            this.updateAndLogTimes("read", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public String waitForCommit(String oldHeadRevisionId, long maxWaitMillis) throws InterruptedException {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.waitForCommit(oldHeadRevisionId, maxWaitMillis);
            this.updateAndLogTimes("waitForCommit", start);
            return result;
        }
        catch (InterruptedException e) {
            this.logException(e);
            throw e;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public String write(InputStream in) {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.write(in);
            this.updateAndLogTimes("write", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public String branch(String trunkRevisionId) {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.branch(trunkRevisionId);
            this.updateAndLogTimes("branch", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public String merge(String branchRevisionId, String message) {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.merge(branchRevisionId, message);
            this.updateAndLogTimes("merge", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Nonnull
    public String rebase(@Nonnull String branchRevisionId, String newBaseRevisionId) {
        try {
            long start = System.currentTimeMillis();
            String result = this.mk.rebase(branchRevisionId, newBaseRevisionId);
            this.updateAndLogTimes("rebase", start);
            return result;
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    public static String quote(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return JsopBuilder.encode((String)((String)o));
        }
        return o.toString();
    }

    private RuntimeException convert(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        this.log("// unexpected exception type: " + e.getClass().getName());
        return new MicroKernelException("Unexpected exception: " + e.toString(), (Throwable)e);
    }

    private void logException(Exception e) {
        this.log("// exception: " + e.toString());
    }

    private void log(String message) {
        if (DEBUG) {
            System.out.println(this.id + " " + message);
        }
    }

    private void updateAndLogTimes(String operation, long start) {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        this.counts.get(operation).update(System.currentTimeMillis() - start);
        long now = System.currentTimeMillis();
        if (now - this.lastLogTime >= 2000L) {
            this.lastLogTime = now;
            for (Map.Entry<String, Count> count : this.counts.entrySet()) {
                double c = count.getValue().count;
                double max = count.getValue().max;
                double total = count.getValue().total;
                double avg = total / c;
                if (!(c > 0.0)) continue;
                this.log(count.getKey() + " --> count:" + c + " avg: " + avg + " max: " + max + " total: " + total);
            }
            System.out.println("Time: " + (now - this.startTime) / 1000L);
            System.out.println("------");
        }
    }

    static class Count {
        public long count;
        public long max;
        public long total;

        Count() {
        }

        void update(long time) {
            ++this.count;
            if (time > this.max) {
                this.max = time;
            }
            this.total += time;
        }
    }
}

