/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bson.types.ObjectId;

public class Utils {
    public static int pathDepth(String path) {
        if (path.equals("/")) {
            return 0;
        }
        int depth = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }

    public static <K, V> Map<K, V> newMap() {
        return new TreeMap();
    }

    public static <E> Set<E> newSet() {
        return new HashSet();
    }

    public static int estimateMemoryUsage(Map<String, Object> map) {
        if (map == null) {
            return 0;
        }
        int size = 0;
        for (Map.Entry<String, Object> e : map.entrySet()) {
            size += e.getKey().length();
            Object o = e.getValue();
            if (o instanceof String) {
                size += o.toString().length();
                continue;
            }
            if (o instanceof Long) {
                size += 8;
                continue;
            }
            if (!(o instanceof Map)) continue;
            size += 8 + Utils.estimateMemoryUsage((Map)o);
        }
        return size;
    }

    public static int getUniqueClusterId() {
        ObjectId objId = new ObjectId();
        return objId._machine();
    }

    public static String escapePropertyName(String propertyName) {
        int len = propertyName.length();
        if (len == 0) {
            return "_";
        }
        StringBuilder buff = null;
        char c = propertyName.charAt(0);
        int i = 0;
        if (c == '_' || c == '$') {
            buff = new StringBuilder(len + 1);
            buff.append('_').append(c);
            ++i;
        }
        while (i < len) {
            char rep;
            c = propertyName.charAt(i);
            switch (c) {
                case '.': {
                    rep = 'd';
                    break;
                }
                case '\\': {
                    rep = '\\';
                    break;
                }
                default: {
                    rep = '\u0000';
                }
            }
            if (rep != '\u0000') {
                if (buff == null) {
                    buff = new StringBuilder(propertyName.substring(0, i));
                }
                buff.append('\\').append(rep);
            } else if (buff != null) {
                buff.append(c);
            }
            ++i;
        }
        return buff == null ? propertyName : buff.toString();
    }

    public static String unescapePropertyName(String key) {
        int len = key.length();
        if (key.startsWith("_") && (key.startsWith("__") || key.startsWith("_$") || len == 1)) {
            key = key.substring(1);
            --len;
        }
        StringBuilder buff = null;
        for (int i = 0; i < len; ++i) {
            int c = key.charAt(i);
            if (c == 92) {
                if (buff == null) {
                    buff = new StringBuilder(key.substring(0, i));
                }
                if ((c = key.charAt(++i)) != 92 && c == 100) {
                    c = 46;
                }
                buff.append((char)c);
                continue;
            }
            if (buff == null) continue;
            buff.append((char)c);
        }
        return buff == null ? key : buff.toString();
    }

    public static boolean isPropertyName(String key) {
        return !key.startsWith("_") || key.startsWith("__") || key.startsWith("_$");
    }

    public static String getIdFromPath(String path) {
        int depth = Utils.pathDepth(path);
        return depth + ":" + path;
    }

    public static String getPathFromId(String id) {
        int index = id.indexOf(58);
        return id.substring(index + 1);
    }

    public static <K> void deepCopyMap(Map<K, Object> source, Map<K, Object> target) {
        for (Map.Entry<K, Object> e : source.entrySet()) {
            Map value = e.getValue();
            if (value instanceof Map) {
                Map old = value;
                Map c = Utils.newMap();
                Utils.deepCopyMap(old, c);
                value = c;
            }
            target.put(e.getKey(), value);
        }
    }
}

