/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.io.File;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class GetTermInfo {
    public static void main(String[] args) throws Exception {
        FSDirectory dir = null;
        String inputStr = null;
        String field = null;
        if (args.length == 3) {
            dir = FSDirectory.open(new File(args[0]));
            field = args[1];
            inputStr = args[2];
        } else {
            GetTermInfo.usage();
            System.exit(1);
        }
        GetTermInfo.getTermInfo(dir, new Term(field, inputStr));
    }

    public static void getTermInfo(Directory dir, Term term) throws Exception {
        DirectoryReader reader = DirectoryReader.open(dir);
        System.out.printf("%s:%s \t totalTF = %,d \t doc freq = %,d \n", term.field(), term.text(), ((IndexReader)reader).totalTermFreq(term), ((IndexReader)reader).docFreq(term));
    }

    private static void usage() {
        System.out.println("\n\nusage:\n\tjava " + GetTermInfo.class.getName() + " <index dir> field term \n\n");
    }
}

