/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClosableThread;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PlainIdRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverseerCollectionProcessor
implements Runnable,
ClosableThread {
    public static final String NUM_SLICES = "numShards";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String MAX_SHARDS_PER_NODE = "maxShardsPerNode";
    public static final String CREATE_NODE_SET = "createNodeSet";
    public static final String DELETECOLLECTION = "deletecollection";
    public static final String CREATECOLLECTION = "createcollection";
    public static final String RELOADCOLLECTION = "reloadcollection";
    public static final String CREATEALIAS = "createalias";
    public static final String DELETEALIAS = "deletealias";
    public static final String SPLITSHARD = "splitshard";
    public static final String DELETESHARD = "deleteshard";
    public static final String ROUTER = "router";
    public static final String SHARDS_PROP = "shards";
    public static final String CREATESHARD = "createshard";
    public static final String DELETEREPLICA = "deletereplica";
    public static final String MIGRATE = "migrate";
    public static final String COLL_CONF = "collection.configName";
    public static final String COLL_PROP_PREFIX = "property.";
    public static final Set<String> KNOWN_CLUSTER_PROPS = ImmutableSet.of((Object)"legacyCloud", (Object)"urlScheme");
    public static final Map<String, Object> COLL_PROPS = ZkNodeProps.makeMap("router", "compositeId", "replicationFactor", "1", "maxShardsPerNode", "1", "external", null);
    private static final String QUEUE_OPERATION = "operation";
    private static Logger log = LoggerFactory.getLogger(OverseerCollectionProcessor.class);
    private DistributedQueue workQueue;
    private String myId;
    private ShardHandler shardHandler;
    private String adminPath;
    private ZkStateReader zkStateReader;
    private boolean isClosed;

    public OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath) {
        this(zkStateReader, myId, shardHandler, adminPath, Overseer.getCollectionQueue(zkStateReader.getZkClient()));
    }

    protected OverseerCollectionProcessor(ZkStateReader zkStateReader, String myId, ShardHandler shardHandler, String adminPath, DistributedQueue workQueue) {
        this.zkStateReader = zkStateReader;
        this.myId = myId;
        this.shardHandler = shardHandler;
        this.adminPath = adminPath;
        this.workQueue = workQueue;
    }

    @Override
    public void run() {
        log.info("Process current queue of collection creations");
        Overseer.LeaderStatus isLeader = this.amILeader();
        while (isLeader == Overseer.LeaderStatus.DONT_KNOW) {
            log.debug("am_i_leader unclear {}", (Object)isLeader);
            isLeader = this.amILeader();
        }
        try {
            this.prioritizeOverseerNodes();
        }
        catch (Exception e) {
            log.error("Unable to prioritize overseer ", (Throwable)e);
        }
        while (!this.isClosed) {
            try {
                isLeader = this.amILeader();
                if (Overseer.LeaderStatus.NO == isLeader) break;
                if (Overseer.LeaderStatus.YES != isLeader) {
                    log.debug("am_i_leader unclear {}", (Object)isLeader);
                    continue;
                }
                DistributedQueue.QueueEvent head = this.workQueue.peek(true);
                ZkNodeProps message = ZkNodeProps.load(head.getBytes());
                log.info("Overseer Collection Processor: Get the message id:" + head.getId() + " message:" + message.toString());
                String operation = message.getStr(QUEUE_OPERATION);
                SolrResponse response = this.processMessage(message, operation);
                head.setBytes(SolrResponse.serializable(response));
                this.workQueue.remove(head);
                log.info("Overseer Collection Processor: Message id:" + head.getId() + " complete, response:" + response.getResponse().toString());
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.SESSIONEXPIRED || e.code() == KeeperException.Code.CONNECTIONLOSS) {
                    log.warn("Overseer cannot talk to ZK");
                    return;
                }
                SolrException.log(log, "", e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                SolrException.log(log, "", e);
            }
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    private void prioritizeOverseerNodes() throws KeeperException, InterruptedException {
        String s;
        int i;
        log.info("prioritizing overseer nodes");
        SolrZkClient zk = this.zkStateReader.getZkClient();
        if (!zk.exists("/roles.json", true).booleanValue()) {
            return;
        }
        Map m = (Map)ZkStateReader.fromJSON(zk.getData("/roles.json", null, new Stat(), true));
        List overseerDesignates = (List)m.get("overseer");
        if (overseerDesignates == null || overseerDesignates.isEmpty()) {
            return;
        }
        if (overseerDesignates.size() == 1 && overseerDesignates.contains(OverseerCollectionProcessor.getLeaderNode(zk))) {
            return;
        }
        log.info("overseer designates {}", (Object)overseerDesignates);
        List<String> nodeNames = OverseerCollectionProcessor.getSortedNodeNames(zk);
        if (nodeNames.size() < 2) {
            return;
        }
        ArrayList<String> nodesTobePushedBack = new ArrayList<String>();
        ArrayList<String> availableDesignates = new ArrayList<String>();
        log.info("sorted nodes {}", nodeNames);
        for (i = 0; i < nodeNames.size(); ++i) {
            s = nodeNames.get(i);
            if (overseerDesignates.contains(s)) {
                availableDesignates.add(s);
                for (int j = 0; j < i; ++j) {
                    if (overseerDesignates.contains(nodeNames.get(j)) || nodesTobePushedBack.contains(nodeNames.get(j))) continue;
                    nodesTobePushedBack.add(nodeNames.get(j));
                }
            }
            if (availableDesignates.size() > 1) break;
        }
        if (!availableDesignates.isEmpty()) {
            for (i = nodesTobePushedBack.size() - 1; i >= 0; --i) {
                s = (String)nodesTobePushedBack.get(i);
                log.info("pushing back {} ", (Object)s);
                this.invokeOverseerOp(s, "rejoin");
            }
            boolean prioritizationComplete = false;
            long timeout = System.currentTimeMillis() + 2500L;
            while (System.currentTimeMillis() < timeout) {
                List<String> currentNodeNames = OverseerCollectionProcessor.getSortedNodeNames(zk);
                int totalLeaders = 0;
                for (int i2 = 0; i2 < availableDesignates.size(); ++i2) {
                    if (!overseerDesignates.contains(currentNodeNames.get(i2))) continue;
                    ++totalLeaders;
                }
                if (totalLeaders == availableDesignates.size()) {
                    prioritizationComplete = true;
                    break;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    log.warn("Thread interrupted", (Throwable)e);
                    break;
                }
            }
            if (!prioritizationComplete) {
                log.warn("available designates and current state {} {} ", availableDesignates, OverseerCollectionProcessor.getSortedNodeNames(zk));
            }
        } else {
            log.warn("No overseer designates are available, overseerDesignates: {}, live nodes : {}", (Object)overseerDesignates, nodeNames);
            return;
        }
        String leaderNode = OverseerCollectionProcessor.getLeaderNode(this.zkStateReader.getZkClient());
        if (leaderNode == null) {
            return;
        }
        if (!overseerDesignates.contains(leaderNode) && !availableDesignates.isEmpty()) {
            String newLeader = (String)availableDesignates.get(0);
            log.info("I am not an overseerdesignate , forcing a new leader {} ", (Object)newLeader);
            this.invokeOverseerOp(newLeader, "leader");
        }
    }

    public static List<String> getSortedNodeNames(SolrZkClient zk) throws KeeperException, InterruptedException {
        List<String> children = null;
        try {
            children = zk.getChildren("/overseer_elect/election", null, true);
        }
        catch (Exception e) {
            log.warn("error ", (Throwable)e);
            return new ArrayList<String>();
        }
        LeaderElector.sortSeqs(children);
        ArrayList<String> nodeNames = new ArrayList<String>(children.size());
        for (String c : children) {
            nodeNames.add(LeaderElector.getNodeName(c));
        }
        return nodeNames;
    }

    public static String getLeaderNode(SolrZkClient zkClient) throws KeeperException, InterruptedException {
        byte[] data = new byte[]{};
        try {
            data = zkClient.getData("/overseer_elect/leader", null, new Stat(), true);
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        Map m = (Map)ZkStateReader.fromJSON(data);
        String s = (String)m.get("id");
        String nodeName = LeaderElector.getNodeName(s);
        return nodeName;
    }

    private void invokeOverseerOp(String nodeName, String op) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.OVERSEEROP.toString());
        params.set("op", op);
        params.set("qt", this.adminPath);
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1;
        String replica = nodeName.replaceFirst("_", "/");
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    protected Overseer.LeaderStatus amILeader() {
        try {
            ZkNodeProps props = ZkNodeProps.load(this.zkStateReader.getZkClient().getData("/overseer_elect/leader", null, null, true));
            if (this.myId.equals(props.getStr("id"))) {
                return Overseer.LeaderStatus.YES;
            }
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.CONNECTIONLOSS) {
                log.error("", (Throwable)e);
                return Overseer.LeaderStatus.DONT_KNOW;
            }
            if (e.code() == KeeperException.Code.SESSIONEXPIRED) {
                log.info("", (Throwable)e);
            } else {
                log.warn("", (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        log.info("According to ZK I (id=" + this.myId + ") am no longer a leader.");
        return Overseer.LeaderStatus.NO;
    }

    protected SolrResponse processMessage(ZkNodeProps message, String operation) {
        NamedList<Serializable> results;
        block14: {
            log.warn("OverseerCollectionProcessor.processMessage : " + operation + " , " + message.toString());
            results = new NamedList<Serializable>();
            try {
                if (CREATECOLLECTION.equals(operation)) {
                    this.createCollection(this.zkStateReader.getClusterState(), message, results);
                    break block14;
                }
                if (DELETECOLLECTION.equals(operation)) {
                    this.deleteCollection(message, results);
                    break block14;
                }
                if (RELOADCOLLECTION.equals(operation)) {
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", CoreAdminParams.CoreAdminAction.RELOAD.toString());
                    this.collectionCmd(this.zkStateReader.getClusterState(), message, params, results, "active");
                    break block14;
                }
                if (CREATEALIAS.equals(operation)) {
                    this.createAlias(this.zkStateReader.getAliases(), message);
                    break block14;
                }
                if (DELETEALIAS.equals(operation)) {
                    this.deleteAlias(this.zkStateReader.getAliases(), message);
                    break block14;
                }
                if (SPLITSHARD.equals(operation)) {
                    this.splitShard(this.zkStateReader.getClusterState(), message, results);
                    break block14;
                }
                if (CREATESHARD.equals(operation)) {
                    this.createShard(this.zkStateReader.getClusterState(), message, results);
                    break block14;
                }
                if (DELETESHARD.equals(operation)) {
                    this.deleteShard(this.zkStateReader.getClusterState(), message, results);
                    break block14;
                }
                if (DELETEREPLICA.equals(operation)) {
                    this.deleteReplica(this.zkStateReader.getClusterState(), message, results);
                    break block14;
                }
                if (MIGRATE.equals(operation)) {
                    this.migrate(this.zkStateReader.getClusterState(), message, results);
                    break block14;
                }
                if (CollectionParams.CollectionAction.CLUSTERPROP.toString().equalsIgnoreCase(operation)) {
                    this.handleProp(message, results);
                    break block14;
                }
                if (CollectionParams.CollectionAction.REMOVEROLE.toString().toLowerCase(Locale.ROOT).equals(operation) || CollectionParams.CollectionAction.ADDROLE.toString().toLowerCase(Locale.ROOT).equals(operation)) {
                    this.processRoleCommand(message, operation);
                    break block14;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown operation:" + operation);
            }
            catch (Exception e) {
                SolrException.log(log, "Collection " + operation + " of " + operation + " failed", e);
                results.add("Operation " + operation + " caused exception:", e);
                SimpleOrderedMap<Object> nl = new SimpleOrderedMap<Object>();
                nl.add("msg", e.getMessage());
                nl.add("rspCode", e instanceof SolrException ? ((SolrException)e).code() : -1);
                results.add("exception", nl);
            }
        }
        return new OverseerSolrResponse(results);
    }

    private void handleProp(ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String name = message.getStr("name");
        String val = message.getStr("val");
        Map m = this.zkStateReader.getClusterProps();
        if (val == null) {
            m.remove(name);
        } else {
            m.put(name, val);
        }
        if (this.zkStateReader.getZkClient().exists("/clusterprops.json", true).booleanValue()) {
            this.zkStateReader.getZkClient().setData("/clusterprops.json", ZkStateReader.toJSON(m), true);
        } else {
            this.zkStateReader.getZkClient().create("/clusterprops.json", ZkStateReader.toJSON(m), CreateMode.PERSISTENT, true);
        }
    }

    private void processRoleCommand(ZkNodeProps message, String operation) throws KeeperException, InterruptedException {
        SolrZkClient zkClient = this.zkStateReader.getZkClient();
        Map roles = null;
        String node = message.getStr("node");
        String roleName = message.getStr("role");
        boolean nodeExists = false;
        nodeExists = zkClient.exists("/roles.json", true);
        roles = nodeExists ? (Map)ZkStateReader.fromJSON(zkClient.getData("/roles.json", null, new Stat(), true)) : new LinkedHashMap(1);
        ArrayList<String> nodeList = (ArrayList<String>)roles.get(roleName);
        if (nodeList == null) {
            nodeList = new ArrayList<String>();
            roles.put(roleName, nodeList);
        }
        if (CollectionParams.CollectionAction.ADDROLE.toString().toLowerCase(Locale.ROOT).equals(operation)) {
            log.info("Overseer role added to {}", (Object)node);
            if (!nodeList.contains(node)) {
                nodeList.add(node);
            }
        } else if (CollectionParams.CollectionAction.REMOVEROLE.toString().toLowerCase(Locale.ROOT).equals(operation)) {
            log.info("Overseer role removed from {}", (Object)node);
            nodeList.remove(node);
        }
        if (nodeExists) {
            zkClient.setData("/roles.json", ZkStateReader.toJSON(roles), true);
        } else {
            zkClient.create("/roles.json", ZkStateReader.toJSON(roles), CreateMode.PERSISTENT, true);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    OverseerCollectionProcessor.this.prioritizeOverseerNodes();
                }
                catch (Exception e) {
                    log.error("Error in prioritizing Overseer", (Throwable)e);
                }
            }
        }.start();
    }

    private void deleteReplica(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        this.checkRequired(message, "collection", "shard", "replica");
        String collectionName = message.getStr("collection");
        String shard = message.getStr("shard");
        String replicaName = message.getStr("replica");
        DocCollection coll = clusterState.getCollection(collectionName);
        Slice slice = coll.getSlice(shard);
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid shard name : " + shard + " in collection : " + collectionName);
        }
        Replica replica = slice.getReplica(replicaName);
        if (replica == null) {
            ArrayList<String> l = new ArrayList<String>();
            for (Replica r : slice.getReplicas()) {
                l.add(r.getName());
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid replica : " + replicaName + " in shard/collection : " + shard + "/" + collectionName + " available replicas are " + StrUtils.join(l, ','));
        }
        String baseUrl = replica.getStr("base_url");
        String core = replica.getStr("core");
        Map<String, Object> m = ZkNodeProps.makeMap("qt", this.adminPath, "action", CoreAdminParams.CoreAdminAction.UNLOAD.toString(), "core", core);
        ShardRequest sreq = new ShardRequest();
        sreq.purpose = 1;
        sreq.shards = new String[]{baseUrl};
        sreq.actualShards = sreq.shards;
        sreq.params = new ModifiableSolrParams(new MapSolrParams(m));
        try {
            this.shardHandler.submit(sreq, baseUrl, sreq.params);
        }
        catch (Exception e) {
            log.warn("Exception trying to unload core " + sreq, (Throwable)e);
        }
        this.collectShardResponses(!Slice.ACTIVE.equals(replica.getStr(Slice.STATE)) ? new NamedList() : results, false, null);
        if (this.waitForCoreNodeGone(collectionName, shard, replicaName, 5000)) {
            return;
        }
        this.deleteCoreNode(collectionName, replicaName, replica, core);
        if (this.waitForCoreNodeGone(collectionName, shard, replicaName, 30000)) {
            return;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not  remove replica : " + collectionName + "/" + shard + "/" + replicaName);
    }

    private boolean waitForCoreNodeGone(String collectionName, String shard, String replicaName, int timeoutms) throws InterruptedException {
        long waitUntil = System.currentTimeMillis() + (long)timeoutms;
        boolean deleted = false;
        while (System.currentTimeMillis() < waitUntil) {
            Thread.sleep(100L);
            deleted = this.zkStateReader.getClusterState().getCollection(collectionName).getSlice(shard).getReplica(replicaName) == null;
            if (!deleted) continue;
            break;
        }
        return deleted;
    }

    private void deleteCoreNode(String collectionName, String replicaName, Replica replica, String core) throws KeeperException, InterruptedException {
        ZkNodeProps m = new ZkNodeProps(QUEUE_OPERATION, "deletecore", "core", core, "node_name", replica.getStr("node_name"), "collection", collectionName, "core_node_name", replicaName);
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON(m));
    }

    private void checkRequired(ZkNodeProps message, String ... props) {
        for (String prop : props) {
            if (message.get(prop) != null) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.join(Arrays.asList(props), ',') + " are required params");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCollection(ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collection = message.getStr("name");
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", CoreAdminParams.CoreAdminAction.UNLOAD.toString());
            params.set("deleteInstanceDir", true);
            params.set("deleteDataDir", true);
            this.collectionCmd(this.zkStateReader.getClusterState(), message, params, results, null);
            ZkNodeProps m = new ZkNodeProps(QUEUE_OPERATION, "removecollection", "name", collection);
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON(m));
            long now = System.currentTimeMillis();
            long timeout = now + 30000L;
            boolean removed = false;
            while (System.currentTimeMillis() < timeout) {
                Thread.sleep(100L);
                removed = !this.zkStateReader.getClusterState().hasCollection(message.getStr(collection));
                if (!removed) continue;
                Thread.sleep(300L);
                break;
            }
            if (!removed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + message.getStr("name"));
            }
        }
        finally {
            try {
                if (this.zkStateReader.getZkClient().exists("/collections/" + collection, true).booleanValue()) {
                    this.zkStateReader.getZkClient().clean("/collections/" + collection);
                }
            }
            catch (InterruptedException e) {
                SolrException.log(log, "Cleaning up collection in zk was interrupted:" + collection, e);
                Thread.currentThread().interrupt();
            }
            catch (KeeperException e) {
                SolrException.log(log, "Problem cleaning up collection in zk:" + collection, e);
            }
        }
    }

    private void createAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        String collections = message.getStr("collections");
        HashMap<String, Map<String, String>> newAliasesMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> newCollectionAliasesMap = new HashMap<String, String>();
        Map<String, String> prevColAliases = aliases.getCollectionAliasMap();
        if (prevColAliases != null) {
            newCollectionAliasesMap.putAll(prevColAliases);
        }
        newCollectionAliasesMap.put(aliasName, collections);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = ZkStateReader.toJSON(newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAlias(aliasName, collections);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForAlias(String name, String value) {
        long now = System.currentTimeMillis();
        long timeout = now + 30000L;
        boolean success = false;
        Aliases aliases = null;
        while (System.currentTimeMillis() < timeout) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections == null || !collections.equals(value)) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void checkForAliasAbsence(String name) {
        long now = System.currentTimeMillis();
        long timeout = now + 30000L;
        boolean success = false;
        Aliases aliases = null;
        while (System.currentTimeMillis() < timeout) {
            aliases = this.zkStateReader.getAliases();
            String collections = aliases.getCollectionAlias(name);
            if (collections != null) continue;
            success = true;
            break;
        }
        if (!success) {
            log.warn("Timeout waiting to be notified of Alias change...");
        }
    }

    private void deleteAlias(Aliases aliases, ZkNodeProps message) {
        String aliasName = message.getStr("name");
        HashMap<String, Map<String, String>> newAliasesMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> newCollectionAliasesMap = new HashMap<String, String>();
        newCollectionAliasesMap.putAll(aliases.getCollectionAliasMap());
        newCollectionAliasesMap.remove(aliasName);
        newAliasesMap.put("collection", newCollectionAliasesMap);
        Aliases newAliases = new Aliases(newAliasesMap);
        byte[] jsonBytes = null;
        if (newAliases.collectionAliasSize() > 0) {
            jsonBytes = ZkStateReader.toJSON(newAliases.getAliasMap());
        }
        try {
            this.zkStateReader.getZkClient().setData("/aliases.json", jsonBytes, true);
            this.checkForAliasAbsence(aliasName);
            Thread.sleep(100L);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.warn("", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private boolean createShard(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        ShardResponse srsp;
        log.info("Create shard invoked: {}", (Object)message);
        String collectionName = message.getStr("collection");
        String shard = message.getStr("shard");
        if (collectionName == null || shard == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'collection' and 'shard' are required parameters");
        }
        int numSlices = 1;
        DocCollection collection = clusterState.getCollection(collectionName);
        int maxShardsPerNode = collection.getInt(MAX_SHARDS_PER_NODE, 1);
        int repFactor = message.getInt(REPLICATION_FACTOR, collection.getInt(REPLICATION_FACTOR, 1));
        String createNodeSetStr = message.getStr(CREATE_NODE_SET);
        ArrayList<Assign.Node> sortedNodeList = Assign.getNodesForNewShard(clusterState, collectionName, numSlices, maxShardsPerNode, repFactor, createNodeSetStr);
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON(message));
        long waitUntil = System.currentTimeMillis() + 30000L;
        boolean created = false;
        while (System.currentTimeMillis() < waitUntil) {
            Thread.sleep(100L);
            created = this.zkStateReader.getClusterState().getCollection(collectionName).getSlice(shard) != null;
            if (!created) continue;
        }
        if (!created) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully create shard: " + message.getStr("name"));
        }
        String configName = message.getStr(COLL_CONF);
        String sliceName = shard;
        for (int j = 1; j <= repFactor; ++j) {
            String nodeName = sortedNodeList.get((int)((j - 1) % sortedNodeList.size())).nodeName;
            String shardName = collectionName + "_" + sliceName + "_replica" + j;
            log.info("Creating shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", CoreAdminParams.CoreAdminAction.CREATE.toString());
            params.set("name", shardName);
            params.set(COLL_CONF, configName);
            params.set("collection", collectionName);
            params.set("shard", sliceName);
            params.set(NUM_SLICES, numSlices);
            this.addPropertyParams(message, params);
            ShardRequest sreq = new ShardRequest();
            params.set("qt", this.adminPath);
            sreq.purpose = 1;
            String replica = this.zkStateReader.getBaseUrlForNodeName(nodeName);
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = params;
            this.shardHandler.submit(sreq, replica, sreq.params);
        }
        do {
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
        } while (srsp != null);
        log.info("Finished create command on all shards for collection: " + collectionName);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean splitShard(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        log.info("Split shard invoked");
        String collectionName = message.getStr("collection");
        String slice = message.getStr("shard");
        String splitKey = message.getStr("split.key");
        DocCollection collection = clusterState.getCollection(collectionName);
        DocRouter router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
        Slice parentSlice = null;
        if (slice == null) {
            if (!(router instanceof CompositeIdRouter)) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Split by route key can only be used with CompositeIdRouter or subclass. Found router: " + router.getClass().getName());
            Collection<Slice> searchSlices = router.getSearchSlicesSingle(splitKey, new ModifiableSolrParams(), collection);
            if (searchSlices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to find an active shard for split.key: " + splitKey);
            }
            if (searchSlices.size() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Splitting a split.key: " + splitKey + " which spans multiple shards is not supported");
            }
            parentSlice = searchSlices.iterator().next();
            slice = parentSlice.getName();
            log.info("Split by route.key: {}, parent shard is: {} ", (Object)splitKey, (Object)slice);
        } else {
            parentSlice = clusterState.getSlice(collectionName, slice);
        }
        if (parentSlice == null) {
            if (!clusterState.hasCollection(collectionName)) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collectionName);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with the specified name exists: " + slice);
        }
        Replica parentShardLeader = null;
        try {
            parentShardLeader = this.zkStateReader.getLeaderRetry(collectionName, slice, 10000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        DocRouter.Range range = parentSlice.getRange();
        if (range == null) {
            range = new PlainIdRouter().fullRange();
        }
        List<DocRouter.Range> subRanges = null;
        String rangesStr = message.getStr("ranges");
        if (rangesStr != null) {
            String[] ranges = rangesStr.split(",");
            if (ranges.length == 0 || ranges.length == 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There must be at least two ranges specified to split a shard");
            }
            subRanges = new ArrayList<DocRouter.Range>(ranges.length);
            for (int i = 0; i < ranges.length; ++i) {
                String r = ranges[i];
                try {
                    subRanges.add(DocRouter.DEFAULT.fromString(r));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception in parsing hexadecimal hash range: " + r, (Throwable)e);
                }
                if (subRanges.get(i).isSubsetOf(range)) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash range: " + r + " is not a subset of parent shard's range: " + range.toString());
            }
            ArrayList<DocRouter.Range> temp = new ArrayList<DocRouter.Range>(subRanges);
            Collections.sort(temp);
            if (!range.equals(new DocRouter.Range(((DocRouter.Range)temp.get((int)0)).min, ((DocRouter.Range)temp.get((int)(temp.size() - 1))).max))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " do not cover the entire range of parent shard: " + range);
            }
            for (int i = 1; i < temp.size(); ++i) {
                if (((DocRouter.Range)temp.get((int)(i - 1))).max + 1 == ((DocRouter.Range)temp.get((int)i)).min) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " either overlap with each other or " + "do not cover the entire range of parent shard: " + range);
            }
        } else if (splitKey != null) {
            if (router instanceof CompositeIdRouter) {
                CompositeIdRouter compositeIdRouter = (CompositeIdRouter)router;
                subRanges = compositeIdRouter.partitionRangeByKey(splitKey, range);
                if (subRanges.size() == 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " has a hash range that is exactly equal to hash range of shard: " + slice);
                }
                for (DocRouter.Range subRange : subRanges) {
                    if (subRange.min != subRange.max) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " must be a compositeId");
                }
                log.info("Partitioning parent shard " + slice + " range: " + parentSlice.getRange() + " yields: " + subRanges);
                rangesStr = "";
                for (int i = 0; i < subRanges.size(); ++i) {
                    DocRouter.Range subRange;
                    subRange = subRanges.get(i);
                    rangesStr = rangesStr + subRange.toString();
                    if (i >= subRanges.size() - 1) continue;
                    rangesStr = rangesStr + ',';
                }
            }
        } else {
            subRanges = router.partitionRange(2, range);
        }
        try {
            HashMap<String, Object> propMap;
            int i;
            String subShardName;
            String subSlice;
            int i2;
            ArrayList<String> subSlices = new ArrayList<String>(subRanges.size());
            ArrayList<String> subShardNames = new ArrayList<String>(subRanges.size());
            String nodeName = parentShardLeader.getNodeName();
            for (i2 = 0; i2 < subRanges.size(); ++i2) {
                subSlice = slice + "_" + i2;
                subSlices.add(subSlice);
                subShardName = collectionName + "_" + subSlice + "_replica1";
                subShardNames.add(subShardName);
                Slice oSlice = clusterState.getSlice(collectionName, subSlice);
                if (oSlice == null) continue;
                if (Slice.ACTIVE.equals(oSlice.getState())) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sub-shard: " + subSlice + " exists in active state. Aborting split shard.");
                }
                if (!Slice.CONSTRUCTION.equals(oSlice.getState()) && !Slice.RECOVERY.equals(oSlice.getState())) continue;
                for (String sub : subSlices) {
                    log.info("Sub-shard: {} already exists therefore requesting its deletion", (Object)sub);
                    HashMap<String, Object> propMap2 = new HashMap<String, Object>();
                    propMap2.put(QUEUE_OPERATION, DELETESHARD);
                    propMap2.put("collection", collectionName);
                    propMap2.put("shard", sub);
                    ZkNodeProps m = new ZkNodeProps(propMap2);
                    try {
                        this.deleteShard(clusterState, m, new NamedList());
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to delete already existing sub shard: " + sub, (Throwable)e);
                    }
                }
            }
            this.collectShardResponses(results, false, null);
            for (i2 = 0; i2 < subRanges.size(); ++i2) {
                subSlice = (String)subSlices.get(i2);
                subShardName = (String)subShardNames.get(i2);
                DocRouter.Range subRange = subRanges.get(i2);
                log.info("Creating shard " + subShardName + " as part of slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                HashMap<String, Object> propMap3 = new HashMap<String, Object>();
                propMap3.put(QUEUE_OPERATION, CREATESHARD);
                propMap3.put("shard", subSlice);
                propMap3.put("collection", collectionName);
                propMap3.put("shard_range", subRange.toString());
                propMap3.put("shard_state", Slice.CONSTRUCTION);
                propMap3.put("shard_parent", parentSlice.getName());
                ZkNodeProps m = new ZkNodeProps(propMap3);
                DistributedQueue inQueue = Overseer.getInQueue(this.zkStateReader.getZkClient());
                inQueue.offer(ZkStateReader.toJSON(m));
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", CoreAdminParams.CoreAdminAction.CREATE.toString());
                params.set("name", subShardName);
                params.set("collection", collectionName);
                params.set("shard", subSlice);
                this.addPropertyParams(message, params);
                this.sendShardRequest(nodeName, params);
            }
            this.collectShardResponses(results, true, "SPLTSHARD failed to create subshard leaders");
            for (String subShardName2 : subShardNames) {
                log.info("Asking parent leader to wait for: " + subShardName2 + " to be alive on: " + nodeName);
                String coreNodeName = this.waitForCoreNodeName(collection, this.zkStateReader.getBaseUrlForNodeName(nodeName), subShardName2);
                CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                cmd.setCoreName(subShardName2);
                cmd.setNodeName(nodeName);
                cmd.setCoreNodeName(coreNodeName);
                cmd.setState("active");
                cmd.setCheckLive(true);
                cmd.setOnlyIfLeader(true);
                this.sendShardRequest(nodeName, new ModifiableSolrParams(cmd.getParams()));
            }
            this.collectShardResponses(results, true, "SPLTSHARD timed out waiting for subshard leaders to come up");
            log.info("Successfully created all sub-shards for collection " + collectionName + " parent shard: " + slice + " on: " + parentShardLeader);
            log.info("Splitting shard " + parentShardLeader.getName() + " as part of slice " + slice + " of collection " + collectionName + " on " + parentShardLeader);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", CoreAdminParams.CoreAdminAction.SPLIT.toString());
            params.set("core", parentShardLeader.getStr("core"));
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                params.add("targetCore", subShardName);
            }
            params.set("ranges", rangesStr);
            this.sendShardRequest(parentShardLeader.getNodeName(), params);
            this.collectShardResponses(results, true, "SPLITSHARD failed to invoke SPLIT core admin command");
            log.info("Index on shard: " + nodeName + " split into two successfully");
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                log.info("Applying buffered updates on : " + subShardName);
                params = new ModifiableSolrParams();
                params.set("action", CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString());
                params.set("name", subShardName);
                this.sendShardRequest(nodeName, params);
            }
            this.collectShardResponses(results, true, "SPLITSHARD failed while asking sub shard leaders to apply buffered updates");
            log.info("Successfully applied buffered updates on : " + subShardNames);
            int repFactor = clusterState.getSlice(collectionName, slice).getReplicas().size();
            Set<String> nodes = clusterState.getLiveNodes();
            ArrayList<String> nodeList = new ArrayList<String>(nodes.size());
            nodeList.addAll(nodes);
            Collections.shuffle(nodeList);
            nodeList.remove(nodeName);
            for (int i3 = 1; i3 <= subSlices.size(); ++i3) {
                Collections.shuffle(nodeList);
                String sliceName = (String)subSlices.get(i3 - 1);
                for (int j = 2; j <= repFactor; ++j) {
                    String subShardNodeName = (String)nodeList.get((repFactor * (i3 - 1) + (j - 2)) % nodeList.size());
                    String shardName = collectionName + "_" + sliceName + "_replica" + j;
                    log.info("Creating replica shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + subShardNodeName);
                    params = new ModifiableSolrParams();
                    params.set("action", CoreAdminParams.CoreAdminAction.CREATE.toString());
                    params.set("name", shardName);
                    params.set("collection", collectionName);
                    params.set("shard", sliceName);
                    this.addPropertyParams(message, params);
                    this.sendShardRequest(subShardNodeName, params);
                    String coreNodeName = this.waitForCoreNodeName(collection, this.zkStateReader.getBaseUrlForNodeName(subShardNodeName), shardName);
                    log.info("Asking sub shard leader to wait for: " + shardName + " to be alive on: " + subShardNodeName);
                    CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                    cmd.setCoreName((String)subShardNames.get(i3 - 1));
                    cmd.setNodeName(subShardNodeName);
                    cmd.setCoreNodeName(coreNodeName);
                    cmd.setState("recovering");
                    cmd.setCheckLive(true);
                    cmd.setOnlyIfLeader(true);
                    this.sendShardRequest(nodeName, new ModifiableSolrParams(cmd.getParams()));
                }
            }
            this.collectShardResponses(results, true, "SPLTSHARD failed to create subshard replicas or timed out waiting for them to come up");
            log.info("Successfully created all replica shards for all sub-slices " + subSlices);
            this.commit(results, slice, parentShardLeader);
            if (repFactor == 1) {
                log.info("Replication factor is 1 so switching shard states");
                DistributedQueue inQueue = Overseer.getInQueue(this.zkStateReader.getZkClient());
                propMap = new HashMap<String, Object>();
                propMap.put(QUEUE_OPERATION, "updateshardstate");
                propMap.put(slice, Slice.INACTIVE);
                for (String subSlice2 : subSlices) {
                    propMap.put(subSlice2, Slice.ACTIVE);
                }
                propMap.put("collection", collectionName);
                ZkNodeProps m = new ZkNodeProps(propMap);
                inQueue.offer(ZkStateReader.toJSON(m));
                return true;
            } else {
                log.info("Requesting shard state be set to 'recovery'");
                DistributedQueue inQueue = Overseer.getInQueue(this.zkStateReader.getZkClient());
                propMap = new HashMap();
                propMap.put(QUEUE_OPERATION, "updateshardstate");
                for (String subSlice2 : subSlices) {
                    propMap.put(subSlice2, Slice.RECOVERY);
                }
                propMap.put("collection", collectionName);
                ZkNodeProps m = new ZkNodeProps(propMap);
                inQueue.offer(ZkStateReader.toJSON(m));
            }
            return true;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error executing split operation for collection: " + collectionName + " parent shard: " + slice, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
        }
    }

    private void commit(NamedList results, String slice, Replica parentShardLeader) {
        log.info("Calling soft commit to make sub shard updates visible");
        String coreUrl = new ZkCoreNodeProps(parentShardLeader).getCoreUrl();
        UpdateResponse updateResponse = null;
        try {
            updateResponse = OverseerCollectionProcessor.softCommit(coreUrl);
            this.processResponse(results, null, coreUrl, updateResponse, slice);
        }
        catch (Exception e) {
            this.processResponse(results, e, coreUrl, updateResponse, slice);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to call distrib softCommit on: " + coreUrl, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UpdateResponse softCommit(String url) throws SolrServerException, IOException {
        HttpSolrServer server = null;
        try {
            server = new HttpSolrServer(url);
            server.setConnectionTimeout(30000);
            server.setSoTimeout(120000);
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParams(new ModifiableSolrParams());
            ureq.setAction(AbstractUpdateRequest.ACTION.COMMIT, false, true, true);
            UpdateResponse updateResponse = ureq.process(server);
            return updateResponse;
        }
        finally {
            if (server != null) {
                server.shutdown();
            }
        }
    }

    private String waitForCoreNodeName(DocCollection collection, String msgBaseUrl, String msgCore) {
        int retryCount = 320;
        while (retryCount-- > 0) {
            Map<String, Slice> slicesMap = this.zkStateReader.getClusterState().getSlicesMap(collection.getName());
            if (slicesMap != null) {
                for (Slice slice : slicesMap.values()) {
                    for (Replica replica : slice.getReplicas()) {
                        String baseUrl = replica.getStr("base_url");
                        String core = replica.getStr("core");
                        if (!baseUrl.equals(msgBaseUrl) || !core.equals(msgCore)) continue;
                        return replica.getName();
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find coreNodeName");
    }

    private void collectShardResponses(NamedList results, boolean abortOnError, String msgOnError) {
        ShardResponse srsp;
        do {
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
            Throwable exception = srsp.getException();
            if (!abortOnError || exception == null) continue;
            while (srsp != null) {
                srsp = this.shardHandler.takeCompletedOrError();
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msgOnError, exception);
        } while (srsp != null);
    }

    private void deleteShard(ClusterState clusterState, ZkNodeProps message, NamedList results) {
        log.info("Delete shard invoked");
        String collection = message.getStr("collection");
        String sliceId = message.getStr("shard");
        Slice slice = clusterState.getSlice(collection, sliceId);
        if (slice == null) {
            if (clusterState.hasCollection(collection)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with the specified name exists: " + slice);
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No collection with the specified name exists: " + collection);
        }
        if (slice.getRange() != null && !slice.getState().equals(Slice.INACTIVE) && !slice.getState().equals(Slice.RECOVERY)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The slice: " + slice.getName() + " is currently " + slice.getState() + ". Only INACTIVE (or custom-hashed) slices can be deleted.");
        }
        try {
            ShardResponse srsp;
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", CoreAdminParams.CoreAdminAction.UNLOAD.toString());
            params.set("deleteIndex", "true");
            this.sliceCmd(clusterState, params, null, slice);
            do {
                if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
                this.processResponse(results, srsp);
            } while (srsp != null);
            ZkNodeProps m = new ZkNodeProps(QUEUE_OPERATION, "removeshard", "collection", collection, "shard", sliceId);
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON(m));
            long now = System.currentTimeMillis();
            long timeout = now + 30000L;
            boolean removed = false;
            while (System.currentTimeMillis() < timeout) {
                Thread.sleep(100L);
                removed = this.zkStateReader.getClusterState().getSlice(collection, sliceId) == null;
                if (!removed) continue;
                Thread.sleep(100L);
                break;
            }
            if (!removed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + collection + " shard: " + sliceId);
            }
            log.info("Successfully deleted collection: " + collection + ", shard: " + sliceId);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error executing delete operation for collection: " + collection + " shard: " + sliceId, (Throwable)e);
        }
    }

    private void migrate(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String sourceCollectionName = message.getStr("collection");
        String splitKey = message.getStr("split.key");
        String targetCollectionName = message.getStr("target.collection");
        int timeout = message.getInt("forward.timeout", 600) * 1000;
        DocCollection sourceCollection = clusterState.getCollection(sourceCollectionName);
        if (sourceCollection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown source collection: " + sourceCollectionName);
        }
        DocCollection targetCollection = clusterState.getCollection(targetCollectionName);
        if (targetCollection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown target collection: " + sourceCollectionName);
        }
        if (!(sourceCollection.getRouter() instanceof CompositeIdRouter)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source collection must use a compositeId router");
        }
        if (!(targetCollection.getRouter() instanceof CompositeIdRouter)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target collection must use a compositeId router");
        }
        CompositeIdRouter sourceRouter = (CompositeIdRouter)sourceCollection.getRouter();
        CompositeIdRouter targetRouter = (CompositeIdRouter)targetCollection.getRouter();
        Collection<Slice> sourceSlices = sourceRouter.getSearchSlicesSingle(splitKey, null, sourceCollection);
        if (sourceSlices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active slices available in source collection: " + sourceCollection + "for given split.key: " + splitKey);
        }
        Collection<Slice> targetSlices = targetRouter.getSearchSlicesSingle(splitKey, null, targetCollection);
        if (targetSlices.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active slices available in target collection: " + targetCollection + "for given split.key: " + splitKey);
        }
        for (Slice sourceSlice : sourceSlices) {
            for (Slice targetSlice : targetSlices) {
                log.info("Migrating source shard: {} to target shard: {} for split.key = " + splitKey, (Object)sourceSlice, (Object)targetSlice);
                this.migrateKey(clusterState, sourceCollection, sourceSlice, targetCollection, targetSlice, splitKey, timeout, results);
            }
        }
    }

    private void migrateKey(ClusterState clusterState, DocCollection sourceCollection, Slice sourceSlice, DocCollection targetCollection, Slice targetSlice, String splitKey, int timeout, NamedList results) throws KeeperException, InterruptedException {
        String tempSourceCollectionName = "split_" + sourceSlice.getName() + "_temp_" + targetSlice.getName();
        if (clusterState.hasCollection(tempSourceCollectionName)) {
            log.info("Deleting temporary collection: " + tempSourceCollectionName);
            Map<String, Object> props = ZkNodeProps.makeMap(QUEUE_OPERATION, DELETECOLLECTION, "name", tempSourceCollectionName);
            try {
                this.deleteCollection(new ZkNodeProps(props), results);
            }
            catch (Exception e) {
                log.warn("Unable to clean up existing temporary collection: " + tempSourceCollectionName, (Throwable)e);
            }
        }
        CompositeIdRouter sourceRouter = (CompositeIdRouter)sourceCollection.getRouter();
        DocRouter.Range keyHashRange = sourceRouter.keyHashRange(splitKey);
        log.info("Hash range for split.key: {} is: {}", (Object)splitKey, (Object)keyHashRange);
        DocRouter.Range splitRange = this.intersect(targetSlice.getRange(), this.intersect(sourceSlice.getRange(), keyHashRange));
        if (splitRange == null) {
            log.info("No common hashes between source shard: {} and target shard: {}", (Object)sourceSlice.getName(), (Object)targetSlice.getName());
            return;
        }
        log.info("Common hash range between source shard: {} and target shard: {} = " + splitRange, (Object)sourceSlice.getName(), (Object)targetSlice.getName());
        Replica targetLeader = this.zkStateReader.getLeaderRetry(targetCollection.getName(), targetSlice.getName(), 10000);
        log.info("Asking target leader node: " + targetLeader.getNodeName() + " core: " + targetLeader.getStr("core") + " to buffer updates");
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.REQUESTBUFFERUPDATES.toString());
        params.set("name", targetLeader.getStr("core"));
        this.sendShardRequest(targetLeader.getNodeName(), params);
        this.collectShardResponses(results, true, "MIGRATE failed to request node to buffer updates");
        ZkNodeProps m = new ZkNodeProps(QUEUE_OPERATION, "addroutingrule", "collection", sourceCollection.getName(), "shard", sourceSlice.getName(), "routeKey", SolrIndexSplitter.getRouteKey(splitKey) + "!", "range", splitRange.toString(), "targetCollection", targetCollection.getName(), "expireAt", String.valueOf(System.currentTimeMillis() + (long)timeout));
        log.info("Adding routing rule: " + m);
        Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON(m));
        log.info("Waiting to see routing rule updated in clusterstate");
        long waitUntil = System.currentTimeMillis() + 60000L;
        boolean added = false;
        while (System.currentTimeMillis() < waitUntil) {
            RoutingRule rule;
            Thread.sleep(100L);
            Map<String, RoutingRule> rules = this.zkStateReader.getClusterState().getSlice(sourceCollection.getName(), sourceSlice.getName()).getRoutingRules();
            if (rules == null || (rule = rules.get(SolrIndexSplitter.getRouteKey(splitKey) + "!")) == null || !rule.getRouteRanges().contains(splitRange)) continue;
            added = true;
            break;
        }
        if (!added) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not add routing rule: " + m);
        }
        log.info("Routing rule added successfully");
        Replica sourceLeader = this.zkStateReader.getLeaderRetry(sourceCollection.getName(), sourceSlice.getName(), 10000);
        String configName = this.zkStateReader.readConfigName(sourceCollection.getName());
        Map<String, Object> props = ZkNodeProps.makeMap(QUEUE_OPERATION, CREATECOLLECTION, "name", tempSourceCollectionName, REPLICATION_FACTOR, 1, NUM_SLICES, 1, COLL_CONF, configName, CREATE_NODE_SET, sourceLeader.getNodeName());
        log.info("Creating temporary collection: " + props);
        this.createCollection(clusterState, new ZkNodeProps(props), results);
        clusterState = this.zkStateReader.getClusterState();
        Slice tempSourceSlice = clusterState.getCollection(tempSourceCollectionName).getSlices().iterator().next();
        Replica tempSourceLeader = this.zkStateReader.getLeaderRetry(tempSourceCollectionName, tempSourceSlice.getName(), 120000);
        String tempCollectionReplica1 = tempSourceCollectionName + "_" + tempSourceSlice.getName() + "_replica1";
        String coreNodeName = this.waitForCoreNodeName(clusterState.getCollection(tempSourceCollectionName), this.zkStateReader.getBaseUrlForNodeName(sourceLeader.getNodeName()), tempCollectionReplica1);
        log.info("Asking source leader to wait for: " + tempCollectionReplica1 + " to be alive on: " + sourceLeader.getNodeName());
        CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
        cmd.setCoreName(tempCollectionReplica1);
        cmd.setNodeName(sourceLeader.getNodeName());
        cmd.setCoreNodeName(coreNodeName);
        cmd.setState("active");
        cmd.setCheckLive(true);
        cmd.setOnlyIfLeader(true);
        this.sendShardRequest(tempSourceLeader.getNodeName(), new ModifiableSolrParams(cmd.getParams()));
        this.collectShardResponses(results, true, "MIGRATE failed to create temp collection leader or timed out waiting for it to come up");
        log.info("Asking source leader to split index");
        params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.SPLIT.toString());
        params.set("core", sourceLeader.getStr("core"));
        params.add("targetCore", tempSourceLeader.getStr("core"));
        params.set("ranges", splitRange.toString());
        params.set("split.key", splitKey);
        this.sendShardRequest(sourceLeader.getNodeName(), params);
        this.collectShardResponses(results, true, "MIGRATE failed to invoke SPLIT core admin command");
        log.info("Creating a replica of temporary collection: {} on the target leader node: {}", (Object)tempSourceCollectionName, (Object)targetLeader.getNodeName());
        params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.CREATE.toString());
        String tempCollectionReplica2 = tempSourceCollectionName + "_" + tempSourceSlice.getName() + "_replica2";
        params.set("name", tempCollectionReplica2);
        params.set("collection", tempSourceCollectionName);
        params.set("shard", tempSourceSlice.getName());
        this.sendShardRequest(targetLeader.getNodeName(), params);
        coreNodeName = this.waitForCoreNodeName(clusterState.getCollection(tempSourceCollectionName), this.zkStateReader.getBaseUrlForNodeName(targetLeader.getNodeName()), tempCollectionReplica2);
        log.info("Asking temp source leader to wait for: " + tempCollectionReplica2 + " to be alive on: " + targetLeader.getNodeName());
        cmd = new CoreAdminRequest.WaitForState();
        cmd.setCoreName(tempSourceLeader.getStr("core"));
        cmd.setNodeName(targetLeader.getNodeName());
        cmd.setCoreNodeName(coreNodeName);
        cmd.setState("active");
        cmd.setCheckLive(true);
        cmd.setOnlyIfLeader(true);
        this.sendShardRequest(tempSourceLeader.getNodeName(), new ModifiableSolrParams(cmd.getParams()));
        this.collectShardResponses(results, true, "MIGRATE failed to create temp collection replica or timed out waiting for them to come up");
        log.info("Successfully created replica of temp source collection on target leader node");
        log.info("Requesting merge of temp source collection replica to target leader");
        params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.MERGEINDEXES.toString());
        params.set("core", targetLeader.getStr("core"));
        params.set("srcCore", tempCollectionReplica2);
        this.sendShardRequest(targetLeader.getNodeName(), params);
        this.collectShardResponses(results, true, "MIGRATE failed to merge " + tempCollectionReplica2 + " to " + targetLeader.getStr("core") + " on node: " + targetLeader.getNodeName());
        log.info("Asking target leader to apply buffered updates");
        params = new ModifiableSolrParams();
        params.set("action", CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString());
        params.set("name", targetLeader.getStr("core"));
        this.sendShardRequest(targetLeader.getNodeName(), params);
        this.collectShardResponses(results, true, "MIGRATE failed to request node to apply buffered updates");
        try {
            log.info("Deleting temporary collection: " + tempSourceCollectionName);
            props = ZkNodeProps.makeMap(QUEUE_OPERATION, DELETECOLLECTION, "name", tempSourceCollectionName);
            this.deleteCollection(new ZkNodeProps(props), results);
        }
        catch (Exception e) {
            log.error("Unable to delete temporary collection: " + tempSourceCollectionName + ". Please remove it manually", (Throwable)e);
        }
    }

    private DocRouter.Range intersect(DocRouter.Range a, DocRouter.Range b) {
        if (a == null || b == null || !a.overlaps(b)) {
            return null;
        }
        if (a.isSubsetOf(b)) {
            return a;
        }
        if (b.isSubsetOf(a)) {
            return b;
        }
        if (b.includes(a.max)) {
            return new DocRouter.Range(b.min, a.max);
        }
        return new DocRouter.Range(a.min, b.max);
    }

    private void sendShardRequest(String nodeName, ModifiableSolrParams params) {
        ShardRequest sreq = new ShardRequest();
        params.set("qt", this.adminPath);
        sreq.purpose = 1;
        String replica = this.zkStateReader.getBaseUrlForNodeName(nodeName);
        sreq.shards = new String[]{replica};
        sreq.actualShards = sreq.shards;
        sreq.params = params;
        this.shardHandler.submit(sreq, replica, sreq.params);
    }

    private void addPropertyParams(ZkNodeProps message, ModifiableSolrParams params) {
        for (String key : message.keySet()) {
            if (!key.startsWith(COLL_PROP_PREFIX)) continue;
            params.set(key, message.getStr(key));
        }
    }

    private void createCollection(ClusterState clusterState, ZkNodeProps message, NamedList results) throws KeeperException, InterruptedException {
        String collectionName = message.getStr("name");
        if (clusterState.hasCollection(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "collection already exists: " + collectionName);
        }
        try {
            ShardResponse srsp;
            int requestedShardsToCreate;
            int maxShardsAllowedToCreate;
            List<String> createNodeList;
            int repFactor = message.getInt(REPLICATION_FACTOR, 1);
            Integer numSlices = message.getInt(NUM_SLICES, null);
            String router = message.getStr("router.name", "compositeId");
            ArrayList<String> shardNames = new ArrayList<String>();
            if ("implicit".equals(router)) {
                Overseer.getShardNames(shardNames, message.getStr(SHARDS_PROP, null));
                numSlices = shardNames.size();
            } else {
                Overseer.getShardNames(numSlices, shardNames);
            }
            if (numSlices == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param");
            }
            int maxShardsPerNode = message.getInt(MAX_SHARDS_PER_NODE, 1);
            String createNodeSetStr = message.getStr(CREATE_NODE_SET);
            List<String> list = createNodeList = createNodeSetStr == null ? null : StrUtils.splitSmart(createNodeSetStr, ",", true);
            if (repFactor <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "replicationFactor must be greater than 0");
            }
            if (numSlices <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards must be > 0");
            }
            Set<String> nodes = clusterState.getLiveNodes();
            ArrayList<String> nodeList = new ArrayList<String>(nodes.size());
            nodeList.addAll(nodes);
            if (createNodeList != null) {
                nodeList.retainAll(createNodeList);
            }
            Collections.shuffle(nodeList);
            if (nodeList.size() <= 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". No live Solr-instances" + (createNodeList != null ? " among Solr-instances specified in createNodeSet:" + createNodeSetStr : ""));
            }
            if (repFactor > nodeList.size()) {
                log.warn("Specified replicationFactor of " + repFactor + " on collection " + collectionName + " is higher than or equal to the number of Solr instances currently live or part of your " + CREATE_NODE_SET + "(" + nodeList.size() + "). Its unusual to run two replica of the same slice on the same Solr-instance.");
            }
            if ((maxShardsAllowedToCreate = maxShardsPerNode * nodeList.size()) < (requestedShardsToCreate = numSlices * repFactor)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot create collection " + collectionName + ". Value of " + MAX_SHARDS_PER_NODE + " is " + maxShardsPerNode + ", and the number of live nodes is " + nodeList.size() + ". This allows a maximum of " + maxShardsAllowedToCreate + " to be created. Value of " + NUM_SLICES + " is " + numSlices + " and value of " + REPLICATION_FACTOR + " is " + repFactor + ". This requires " + requestedShardsToCreate + " shards to be created (higher than the allowed number)");
            }
            String configName = this.createConfNode(collectionName, message);
            Overseer.getInQueue(this.zkStateReader.getZkClient()).offer(ZkStateReader.toJSON(message));
            long waitUntil = System.currentTimeMillis() + 30000L;
            boolean created = false;
            while (System.currentTimeMillis() < waitUntil) {
                Thread.sleep(100L);
                created = this.zkStateReader.getClusterState().getCollections().contains(message.getStr("name"));
                if (!created) continue;
            }
            if (!created) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully createcollection: " + message.getStr("name"));
            }
            log.info("going to create cores replicas shardNames {} , repFactor : {}", shardNames, (Object)repFactor);
            for (int i = 1; i <= shardNames.size(); ++i) {
                String sliceName = (String)shardNames.get(i - 1);
                for (int j = 1; j <= repFactor; ++j) {
                    String nodeName = (String)nodeList.get((repFactor * (i - 1) + (j - 1)) % nodeList.size());
                    String shardName = collectionName + "_" + sliceName + "_replica" + j;
                    log.info("Creating shard " + shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + nodeName);
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", CoreAdminParams.CoreAdminAction.CREATE.toString());
                    params.set("name", shardName);
                    params.set(COLL_CONF, configName);
                    params.set("collection", collectionName);
                    params.set("shard", sliceName);
                    params.set(NUM_SLICES, numSlices);
                    this.addPropertyParams(message, params);
                    ShardRequest sreq = new ShardRequest();
                    params.set("qt", this.adminPath);
                    sreq.purpose = 1;
                    String replica = this.zkStateReader.getBaseUrlForNodeName(nodeName);
                    sreq.shards = new String[]{replica};
                    sreq.actualShards = sreq.shards;
                    sreq.params = params;
                    this.shardHandler.submit(sreq, replica, sreq.params);
                }
            }
            do {
                if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
                this.processResponse(results, srsp);
            } while (srsp != null);
            log.info("Finished create command on all shards for collection: " + collectionName);
        }
        catch (SolrException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)ex);
        }
    }

    private String createConfNode(String coll, ZkNodeProps message) throws KeeperException, InterruptedException {
        String configName = message.getStr(COLL_CONF);
        if (configName == null) {
            List<String> configNames = null;
            try {
                configNames = this.zkStateReader.getZkClient().getChildren("/configs", null, true);
                if (configNames != null && configNames.size() == 1) {
                    configName = configNames.get(0);
                    log.info("Only one config set found in zk - using it:" + configName);
                }
            }
            catch (KeeperException.NoNodeException e) {
                // empty catch block
            }
        }
        if (configName != null) {
            log.info("creating collections conf node {} ", (Object)("/collections/" + coll));
            this.zkStateReader.getZkClient().makePath("/collections/" + coll, ZkStateReader.toJSON(ZkNodeProps.makeMap("configName", configName)), true);
        } else {
            String msg = "Could not obtain config name";
            log.warn(msg);
        }
        return configName;
    }

    private void collectionCmd(ClusterState clusterState, ZkNodeProps message, ModifiableSolrParams params, NamedList results, String stateMatcher) {
        ShardResponse srsp;
        log.info("Executing Collection Cmd : " + params);
        String collectionName = message.getStr("name");
        DocCollection coll = clusterState.getCollection(collectionName);
        for (Map.Entry<String, Slice> entry : coll.getSlicesMap().entrySet()) {
            Slice slice = entry.getValue();
            this.sliceCmd(clusterState, params, stateMatcher, slice);
        }
        do {
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null) continue;
            this.processResponse(results, srsp);
        } while (srsp != null);
    }

    private void sliceCmd(ClusterState clusterState, ModifiableSolrParams params, String stateMatcher, Slice slice) {
        Map<String, Replica> shards = slice.getReplicasMap();
        Set<Map.Entry<String, Replica>> shardEntries = shards.entrySet();
        for (Map.Entry<String, Replica> shardEntry : shardEntries) {
            ZkNodeProps node = shardEntry.getValue();
            if (!clusterState.liveNodesContain(node.getStr("node_name")) || stateMatcher != null && !node.getStr("state").equals(stateMatcher)) continue;
            ModifiableSolrParams cloneParams = new ModifiableSolrParams();
            cloneParams.add(params);
            cloneParams.set("core", node.getStr("core"));
            String replica = node.getStr("base_url");
            ShardRequest sreq = new ShardRequest();
            sreq.nodeName = node.getStr("node_name");
            cloneParams.set("qt", this.adminPath);
            sreq.purpose = 1;
            sreq.shards = new String[]{replica};
            sreq.actualShards = sreq.shards;
            sreq.params = cloneParams;
            log.info("Collection Admin sending CoreAdmin cmd to " + replica + " params:" + sreq.params);
            this.shardHandler.submit(sreq, replica, sreq.params);
        }
    }

    private void processResponse(NamedList results, ShardResponse srsp) {
        Throwable e = srsp.getException();
        String nodeName = srsp.getNodeName();
        SolrResponse solrResponse = srsp.getSolrResponse();
        String shard = srsp.getShard();
        this.processResponse(results, e, nodeName, solrResponse, shard);
    }

    private void processResponse(NamedList results, Throwable e, String nodeName, SolrResponse solrResponse, String shard) {
        if (e != null) {
            log.error("Error from shard: " + shard, e);
            SimpleOrderedMap<String> failure = (SimpleOrderedMap<String>)results.get("failure");
            if (failure == null) {
                failure = new SimpleOrderedMap<String>();
                results.add("failure", failure);
            }
            failure.add(nodeName, e.getClass().getName() + ":" + e.getMessage());
        } else {
            SimpleOrderedMap<NamedList<Object>> success = (SimpleOrderedMap<NamedList<Object>>)results.get("success");
            if (success == null) {
                success = new SimpleOrderedMap<NamedList<Object>>();
                results.add("success", success);
            }
            success.add(nodeName, solrResponse.getResponse());
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

