/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.ShardLeaderElectionContextBase;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShardLeaderElectionContext
extends ShardLeaderElectionContextBase {
    private static Logger log = LoggerFactory.getLogger(ShardLeaderElectionContext.class);
    private final ZkController zkController;
    private final CoreContainer cc;
    private final SyncStrategy syncStrategy;
    private volatile boolean isClosed = false;

    public ShardLeaderElectionContext(LeaderElector leaderElector, String shardId, String collection, String coreNodeName, ZkNodeProps props, ZkController zkController, CoreContainer cc) {
        super(leaderElector, shardId, collection, coreNodeName, props, zkController.getZkStateReader());
        this.zkController = zkController;
        this.cc = cc;
        this.syncStrategy = new SyncStrategy(cc);
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.syncStrategy.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runLeaderProcess(boolean weAreReplacement, int pauseBeforeStart) throws KeeperException, InterruptedException, IOException {
        boolean success;
        log.info("Running the leader process for shard " + this.shardId);
        String coreName = this.leaderProps.getStr("core");
        ZkNodeProps m = new ZkNodeProps("operation", "leader", "shard", this.shardId, "collection", this.collection);
        Overseer.getInQueue(this.zkClient).offer(ZkStateReader.toJSON(m));
        int leaderVoteWait = this.cc.getZkController().getLeaderVoteWait();
        if (!weAreReplacement) {
            this.waitForReplicasToComeUp(weAreReplacement, leaderVoteWait);
        }
        SolrCore core = null;
        try {
            core = this.cc.getCore(coreName);
            if (core == null) {
                this.cancelElection();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fatal Error, SolrCore not found:" + coreName + " in " + this.cc.getCoreNames());
            }
            if (weAreReplacement && !this.shouldIBeLeader(this.leaderProps, core, weAreReplacement)) {
                this.rejoinLeaderElection(this.leaderSeqPath, core);
                return;
            }
            log.info("I may be the new leader - try and sync");
            core.getUpdateHandler().getSolrCoreState().cancelRecovery();
            if (weAreReplacement) {
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, (Throwable)e);
                }
            }
            success = false;
            try {
                success = this.syncStrategy.sync(this.zkController, core, this.leaderProps, weAreReplacement);
            }
            catch (Exception e) {
                SolrException.log(log, "Exception while trying to sync", e);
                success = false;
            }
            UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
            if (!success) {
                boolean hasRecentUpdates = false;
                if (ulog != null) {
                    UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();
                    try {
                        hasRecentUpdates = !recentUpdates.getVersions(1).isEmpty();
                    }
                    finally {
                        recentUpdates.close();
                    }
                }
                if (!hasRecentUpdates) {
                    log.info("We failed sync, but we have no versions - we can't sync in that case - we were active before, so become leader anyway");
                    success = true;
                }
            }
            if (log.isDebugEnabled()) {
                try {
                    RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                    SolrIndexSearcher searcher = searchHolder.get();
                    try {
                        log.debug(core.getCoreDescriptor().getCoreContainer().getZkController().getNodeName() + " synched " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits);
                    }
                    finally {
                        searchHolder.decref();
                    }
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
                }
            }
            if (!success) {
                this.rejoinLeaderElection(this.leaderSeqPath, core);
                return;
            }
            log.info("I am the new leader: " + ZkCoreNodeProps.getCoreUrl(this.leaderProps) + " " + this.shardId);
            core.getCoreDescriptor().getCloudDescriptor().setLeader(true);
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
        success = false;
        try {
            super.runLeaderProcess(weAreReplacement, 0);
            success = true;
        }
        catch (Exception e) {
            SolrException.log(log, "There was a problem trying to register as the leader", e);
            try {
                core = this.cc.getCore(coreName);
                if (core == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fatal Error, SolrCore not found:" + coreName + " in " + this.cc.getCoreNames());
                }
                core.getCoreDescriptor().getCloudDescriptor().setLeader(false);
                this.rejoinLeaderElection(this.leaderSeqPath, core);
            }
            finally {
                try {
                    if (!success) {
                        this.cancelElection();
                    }
                }
                finally {
                    if (core != null) {
                        core.close();
                    }
                }
            }
        }
    }

    private boolean areAnyOtherReplicasActive(ZkController zkController, ZkNodeProps leaderProps, String collection, String shardId) {
        ClusterState clusterState = zkController.getZkStateReader().getClusterState();
        Map<String, Slice> slices = clusterState.getSlicesMap(collection);
        Slice slice = slices.get(shardId);
        if (!slice.getState().equals(Slice.ACTIVE)) {
            return false;
        }
        Map<String, Replica> replicasMap = slice.getReplicasMap();
        for (Map.Entry<String, Replica> shard : replicasMap.entrySet()) {
            String state = shard.getValue().getStr("state");
            if (!state.equals("active") || !clusterState.liveNodesContain(shard.getValue().getStr("node_name")) || new ZkCoreNodeProps(shard.getValue()).getCoreUrl().equals(new ZkCoreNodeProps(leaderProps).getCoreUrl())) continue;
            return true;
        }
        return false;
    }

    private void waitForReplicasToComeUp(boolean weAreReplacement, int timeout) throws InterruptedException {
        long timeoutAt = System.currentTimeMillis() + (long)timeout;
        String shardsElectZkPath = this.electionPath + "/election";
        Slice slices = this.zkController.getClusterState().getSlice(this.collection, this.shardId);
        int cnt = 0;
        while (!this.isClosed && !this.cc.isShutDown()) {
            if (slices != null) {
                int found = 0;
                try {
                    found = this.zkClient.getChildren(shardsElectZkPath, null, true).size();
                }
                catch (KeeperException e) {
                    SolrException.log(log, "Error checking for the number of election participants", e);
                }
                if (found >= slices.getReplicasMap().size()) {
                    log.info("Enough replicas found to continue.");
                    return;
                }
                if (cnt % 40 == 0) {
                    log.info("Waiting until we see more replicas up for shard " + this.shardId + ": total=" + slices.getReplicasMap().size() + " found=" + found + " timeoutin=" + (timeoutAt - System.currentTimeMillis()));
                }
                if (System.currentTimeMillis() > timeoutAt) {
                    log.info("Was waiting for replicas to come up, but they are taking too long - assuming they won't come back till later");
                    return;
                }
            } else {
                log.warn("Shard not found: " + this.shardId + " for collection " + this.collection);
                return;
            }
            Thread.sleep(500L);
            slices = this.zkController.getClusterState().getSlice(this.collection, this.shardId);
            ++cnt;
        }
    }

    private void rejoinLeaderElection(String leaderSeqPath, SolrCore core) throws InterruptedException, KeeperException, IOException {
        if (this.cc.isShutDown()) {
            log.info("Not rejoining election because CoreContainer is shutdown");
            return;
        }
        log.info("There may be a better leader candidate than us - going back into recovery");
        this.cancelElection();
        core.getUpdateHandler().getSolrCoreState().doRecovery(this.cc, core.getCoreDescriptor());
        this.leaderElector.joinElection(this, true);
    }

    private boolean shouldIBeLeader(ZkNodeProps leaderProps, SolrCore core, boolean weAreReplacement) {
        log.info("Checking if I should try and be the leader.");
        if (this.isClosed) {
            log.info("Bailing on leader process because we have been closed");
            return false;
        }
        if (!weAreReplacement) {
            return true;
        }
        if (core.getCoreDescriptor().getCloudDescriptor().getLastPublished().equals("active")) {
            log.info("My last published State was Active, it's okay to be the leader.");
            return true;
        }
        log.info("My last published State was " + core.getCoreDescriptor().getCloudDescriptor().getLastPublished() + ", I won't be the leader.");
        return false;
    }
}

