/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.FacetCollector;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.util.BoundedTreeSet;

class CountSortedFacetCollector
extends FacetCollector {
    private final CharsRef spare = new CharsRef();
    final int offset;
    final int limit;
    final int maxsize;
    final BoundedTreeSet<SimpleFacets.CountPair<String, Integer>> queue;
    int min;

    public CountSortedFacetCollector(int offset, int limit, int mincount) {
        this.offset = offset;
        this.limit = limit;
        this.maxsize = limit > 0 ? offset + limit : 0x7FFFFFFE;
        this.queue = new BoundedTreeSet(this.maxsize);
        this.min = mincount - 1;
    }

    @Override
    public boolean collect(BytesRef term, int count) {
        if (count > this.min) {
            UnicodeUtil.UTF8toUTF16(term, this.spare);
            this.queue.add(new SimpleFacets.CountPair<String, Integer>(this.spare.toString(), count));
            if (this.queue.size() >= this.maxsize) {
                this.min = (Integer)((SimpleFacets.CountPair)this.queue.last()).val;
            }
        }
        return false;
    }

    @Override
    public NamedList<Integer> getFacetCounts() {
        NamedList<Integer> res = new NamedList<Integer>();
        int off = this.offset;
        int lim = this.limit >= 0 ? this.limit : Integer.MAX_VALUE;
        for (SimpleFacets.CountPair countPair : this.queue) {
            if (--off >= 0) continue;
            if (--lim < 0) break;
            res.add((String)countPair.key, (Integer)countPair.val);
        }
        return res;
    }
}

