/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.io.LegacyShapeReadWriterFormat;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialArgsParser;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.util.MapListener;
import org.apache.solr.util.SpatialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpatialFieldType<T extends SpatialStrategy>
extends FieldType
implements SpatialQueryable {
    public static final String SCORE_PARAM = "score";
    public static final String FILTER_PARAM = "filter";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected SpatialContext ctx;
    protected SpatialArgsParser argsParser;
    private final Cache<String, T> fieldStrategyCache = CacheBuilder.newBuilder().build();

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        String units = args.remove("units");
        if (!"degrees".equals(units)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Must specify units=\"degrees\" on field types with class " + this.getClass().getSimpleName());
        }
        String wbStr = args.get("worldBounds");
        if (wbStr != null && !wbStr.toUpperCase(Locale.ROOT).startsWith("ENVELOPE")) {
            this.log.warn("Using old worldBounds format? Should use ENVELOPE(xMin, xMax, yMax, yMin).");
            String[] parts = wbStr.split(" ");
            if (parts.length == 4) {
                args.put("worldBounds", "ENVELOPE(" + parts[0] + ", " + parts[2] + ", " + parts[3] + ", " + parts[1] + ")");
            }
        }
        MapListener<String, String> argsWrap = new MapListener<String, String>(args);
        this.ctx = SpatialContextFactory.makeSpatialContext(argsWrap, schema.getResourceLoader().getClassLoader());
        args.keySet().removeAll(argsWrap.getSeenKeys());
        this.argsParser = this.newSpatialArgsParser();
    }

    protected SpatialArgsParser newSpatialArgsParser() {
        return new SpatialArgsParser(){

            @Override
            protected Shape parseShape(String str, SpatialContext ctx) throws ParseException {
                return AbstractSpatialFieldType.this.parseShape(str);
            }
        };
    }

    @Override
    public final Field createField(SchemaField field, Object val, float boost) {
        throw new IllegalStateException("instead call createFields() because isPolyField() is true");
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object val, float boost) {
        String shapeStr = null;
        Shape shape = null;
        if (val instanceof Shape) {
            shape = (Shape)val;
        } else {
            shapeStr = val.toString();
            shape = this.parseShape(shapeStr);
        }
        if (shape == null) {
            this.log.debug("Field {}: null shape for input: {}", (Object)field, val);
            return Collections.emptyList();
        }
        ArrayList<IndexableField> result = new ArrayList<IndexableField>();
        if (field.indexed()) {
            T strategy = this.getStrategy(field.getName());
            result.addAll(Arrays.asList(((SpatialStrategy)strategy).createIndexableFields(shape)));
        }
        if (field.stored()) {
            if (shapeStr == null) {
                shapeStr = this.shapeToString(shape);
            }
            result.add(new StoredField(field.getName(), shapeStr));
        }
        return result;
    }

    protected Shape parseShape(String str) {
        if (str.length() == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "empty string shape");
        }
        try {
            Shape shape = LegacyShapeReadWriterFormat.readShapeOrNull((String)str, (SpatialContext)this.ctx);
            if (shape != null) {
                return shape;
            }
            return this.ctx.readShapeFromWkt(str);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (!message.contains(str)) {
                message = "Couldn't parse shape '" + str + "' because: " + message;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message, (Throwable)e);
        }
    }

    protected String shapeToString(Shape shape) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Getting a String from a Shape is no longer possible. See javadocs for commentary.");
    }

    protected abstract T newSpatialStrategy(String var1);

    @Override
    public final boolean isPolyField() {
        return true;
    }

    @Override
    public Query createSpatialQuery(QParser parser, SpatialOptions options) {
        Point pt = SpatialUtils.parsePointSolrException(options.pointStr, this.ctx);
        double distDeg = DistanceUtils.dist2Degrees(options.distance, options.radius);
        Shape shape = this.ctx.makeCircle(pt, distDeg);
        if (options.bbox) {
            shape = shape.getBoundingBox();
        }
        SpatialArgs spatialArgs = new SpatialArgs(SpatialOperation.Intersects, shape);
        return this.getQueryFromSpatialArgs(parser, options.field, spatialArgs);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        if (!minInclusive || !maxInclusive) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Both sides of spatial range query must be inclusive: " + field.getName());
        }
        Point p1 = SpatialUtils.parsePointSolrException(part1, this.ctx);
        Point p2 = SpatialUtils.parsePointSolrException(part2, this.ctx);
        Rectangle bbox = this.ctx.makeRectangle(p1, p2);
        SpatialArgs spatialArgs = new SpatialArgs(SpatialOperation.Intersects, bbox);
        return this.getQueryFromSpatialArgs(parser, field, spatialArgs);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "A ValueSource isn't directly available from this field. Instead try a query using the distance as the score.");
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        return this.getQueryFromSpatialArgs(parser, field, this.parseSpatialArgs(externalVal));
    }

    protected SpatialArgs parseSpatialArgs(String externalVal) {
        try {
            return this.argsParser.parse(externalVal, this.ctx);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    private Query getQueryFromSpatialArgs(QParser parser, SchemaField field, SpatialArgs spatialArgs) {
        ValueSource valueSource;
        String score;
        T strategy = this.getStrategy(field.getName());
        SolrParams localParams = parser.getLocalParams();
        String string = score = localParams == null ? null : localParams.get(SCORE_PARAM);
        if (score == null || "none".equals(score) || "".equals(score)) {
            return ((SpatialStrategy)strategy).makeQuery(spatialArgs);
        }
        if ("distance".equals(score)) {
            double multiplier = 1.0;
            valueSource = ((SpatialStrategy)strategy).makeDistanceValueSource(spatialArgs.getShape().getCenter(), multiplier);
        } else if ("recipDistance".equals(score)) {
            valueSource = ((SpatialStrategy)strategy).makeRecipDistanceValueSource(spatialArgs.getShape());
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'score' local-param must be one of 'none', 'distance', or 'recipDistance'");
        }
        FunctionQuery functionQuery = new FunctionQuery(valueSource);
        if (localParams != null && !localParams.getBool(FILTER_PARAM, true)) {
            return functionQuery;
        }
        Filter filter = ((SpatialStrategy)strategy).makeFilter(spatialArgs);
        return new FilteredQuery(functionQuery, filter);
    }

    public T getStrategy(final String fieldName) {
        try {
            return (T)((SpatialStrategy)this.fieldStrategyCache.get((Object)fieldName, new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return AbstractSpatialFieldType.this.newSpatialStrategy(fieldName);
                }
            }));
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sorting not supported on SpatialField: " + field.getName() + ", instead try sorting by query.");
    }
}

