/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.search.CacheRegenerator;
import org.apache.solr.search.SolrCache;
import org.apache.solr.util.DOMUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CacheConfig {
    private String nodeName;
    private Class<? extends SolrCache> clazz;
    private Map<String, String> args;
    private CacheRegenerator regenerator;
    private String cacheImpl;
    private Object[] persistence = new Object[1];
    private String regenImpl;

    public CacheConfig() {
    }

    public CacheConfig(Class<? extends SolrCache> clazz, Map<String, String> args, CacheRegenerator regenerator) {
        this.clazz = clazz;
        this.args = args;
        this.regenerator = regenerator;
    }

    public CacheRegenerator getRegenerator() {
        return this.regenerator;
    }

    public void setRegenerator(CacheRegenerator regenerator) {
        this.regenerator = regenerator;
    }

    public static CacheConfig[] getMultipleConfigs(SolrConfig solrConfig, String configPath) {
        NodeList nodes = (NodeList)solrConfig.evaluate(configPath, XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        CacheConfig[] configs = new CacheConfig[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            configs[i] = CacheConfig.getConfig(solrConfig, nodes.item(i));
        }
        return configs;
    }

    public static CacheConfig getConfig(SolrConfig solrConfig, String xpath) {
        Node node = solrConfig.getNode(xpath, false);
        return CacheConfig.getConfig(solrConfig, node);
    }

    public static CacheConfig getConfig(SolrConfig solrConfig, Node node) {
        if (node == null) {
            return null;
        }
        CacheConfig config = new CacheConfig();
        config.nodeName = node.getNodeName();
        config.args = DOMUtil.toMap(node.getAttributes());
        String nameAttr = config.args.get("name");
        if (nameAttr == null) {
            config.args.put("name", config.nodeName);
        }
        SolrResourceLoader loader = solrConfig.getResourceLoader();
        config.cacheImpl = config.args.get("class");
        config.regenImpl = config.args.get("regenerator");
        config.clazz = loader.findClass(config.cacheImpl, SolrCache.class);
        if (config.regenImpl != null) {
            config.regenerator = loader.newInstance(config.regenImpl, CacheRegenerator.class);
        }
        return config;
    }

    public SolrCache newInstance() {
        try {
            SolrCache cache = this.clazz.newInstance();
            this.persistence[0] = cache.init(this.args, this.persistence[0], this.regenerator);
            return cache;
        }
        catch (Exception e) {
            SolrException.log(SolrCache.log, "Error instantiating cache", e);
            return null;
        }
    }
}

