/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.query;

import java.util.Collection;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfiguration;
import org.apache.jackrabbit.oak.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrQueryIndex
implements QueryIndex.FulltextQueryIndex {
    private static final String NATIVE_SOLR_QUERY = "native*solr";
    private static final String NATIVE_LUCENE_QUERY = "native*lucene";
    public static final String TYPE = "solr";
    private final Logger log = LoggerFactory.getLogger(SolrQueryIndex.class);
    private final String name;
    private final SolrServer solrServer;
    private final OakSolrConfiguration configuration;
    private final NodeAggregator aggregator;

    public SolrQueryIndex(String name, SolrServer solrServer, OakSolrConfiguration configuration) {
        this.name = name;
        this.solrServer = solrServer;
        this.configuration = configuration;
        this.aggregator = null;
    }

    public String getIndexName() {
        return this.name;
    }

    public double getCost(Filter filter, NodeState root) {
        if (filter.getFullTextConstraint() == null && filter.getFulltextConditions() == null || filter.getPropertyRestrictions() != null && filter.getPropertyRestrictions().size() == 1 && filter.getPropertyRestriction("jcr:uuid") != null) {
            return Double.POSITIVE_INFINITY;
        }
        int cost = 10;
        Collection restrictions = filter.getPropertyRestrictions();
        if (restrictions != null) {
            cost /= 5;
        }
        if (filter.getPathRestriction() != null) {
            cost /= 2;
        }
        return cost;
    }

    public String getPlan(Filter filter, NodeState nodeState) {
        return this.getQuery(filter).toString();
    }

    private SolrQuery getQuery(Filter filter) {
        SolrQuery solrQuery = new SolrQuery();
        this.setDefaults(solrQuery);
        StringBuilder queryBuilder = new StringBuilder();
        if (filter.getFullTextConstraint() != null) {
            queryBuilder.append(this.getFullTextQuery(filter.getFullTextConstraint()));
            queryBuilder.append(' ');
        } else if (filter.getFulltextConditions() != null) {
            Collection fulltextConditions = filter.getFulltextConditions();
            for (String fulltextCondition : fulltextConditions) {
                queryBuilder.append(fulltextCondition).append(" ");
            }
        }
        Collection propertyRestrictions = filter.getPropertyRestrictions();
        if (propertyRestrictions != null && !propertyRestrictions.isEmpty()) {
            for (Filter.PropertyRestriction pr : propertyRestrictions) {
                if (NATIVE_SOLR_QUERY.equals(pr.propertyName) || NATIVE_LUCENE_QUERY.equals(pr.propertyName)) {
                    String nativeQueryString = String.valueOf(pr.first.getValue(pr.first.getType()));
                    if (this.isSupportedHttpRequest(nativeQueryString)) {
                        String requestHandlerString = nativeQueryString.substring(0, nativeQueryString.indexOf(63));
                        if (!"select".equals(requestHandlerString)) {
                            if (requestHandlerString.charAt(0) != '/') {
                                requestHandlerString = "/" + requestHandlerString;
                            }
                            solrQuery.setRequestHandler(requestHandlerString);
                        }
                        String parameterString = nativeQueryString.substring(nativeQueryString.indexOf(63) + 1);
                        for (String param : parameterString.split("&")) {
                            String[] kv = param.split("=");
                            if (kv.length != 2) {
                                throw new RuntimeException("Unparsable native HTTP Solr query");
                            }
                            if ("stream.body".equals(kv[0])) {
                                kv[0] = "q";
                                String mltFlString = "mlt.fl=";
                                int mltFlIndex = parameterString.indexOf(mltFlString);
                                if (mltFlIndex > -1) {
                                    int beginIndex = mltFlIndex + mltFlString.length();
                                    int endIndex = parameterString.indexOf(38, beginIndex);
                                    String fields = endIndex > beginIndex ? parameterString.substring(beginIndex, endIndex) : parameterString.substring(beginIndex);
                                    kv[1] = "_query_:\"{!dismax qf=" + fields + " q.op=OR}" + kv[1] + "\"";
                                }
                            }
                            solrQuery.setParam(kv[0], kv[1]);
                        }
                        return solrQuery;
                    }
                    queryBuilder.append(nativeQueryString);
                } else {
                    String prField;
                    CharSequence fieldName;
                    if (pr.propertyName.contains("/") || "rep:excerpt".equals(pr.propertyName)) continue;
                    String first = null;
                    if (pr.first != null) {
                        first = SolrQueryIndex.partialEscape(String.valueOf(pr.first.getValue(pr.first.getType()))).toString();
                    }
                    String last = null;
                    if (pr.last != null) {
                        last = SolrQueryIndex.partialEscape(String.valueOf(pr.last.getValue(pr.last.getType()))).toString();
                    }
                    if ("jcr\\:path".equals((fieldName = SolrQueryIndex.partialEscape((prField = this.configuration.getFieldForPropertyRestriction(pr)) != null ? prField : pr.propertyName)).toString())) {
                        queryBuilder.append(this.configuration.getPathField());
                        queryBuilder.append(':');
                        queryBuilder.append(first);
                    } else if (pr.first != null && pr.last != null && pr.first.equals(pr.last)) {
                        queryBuilder.append(fieldName).append(':');
                        queryBuilder.append(first);
                    } else if (pr.first == null && pr.last == null) {
                        if (!queryBuilder.toString().contains(fieldName + ":")) {
                            queryBuilder.append(fieldName).append(':');
                            queryBuilder.append('*');
                        }
                    } else if (pr.first != null && pr.last == null || pr.last != null && pr.first == null || !pr.first.equals(pr.last)) {
                        queryBuilder.append(fieldName).append(':');
                        queryBuilder.append(SolrQueryIndex.createRangeQuery(first, last, pr.firstIncluding, pr.lastIncluding));
                    } else if (pr.isLike) {
                        queryBuilder.append(fieldName).append(':');
                        queryBuilder.append(SolrQueryIndex.partialEscape(String.valueOf(pr.first.getValue(pr.first.getType())).replace('%', '*').replace('_', '?')));
                    } else {
                        throw new RuntimeException("[unexpected!] not handled case");
                    }
                }
                queryBuilder.append(" ");
            }
        }
        String[] pts = filter.getPrimaryTypes().toArray(new String[filter.getPrimaryTypes().size()]);
        for (int i = 0; i < pts.length; ++i) {
            String pt = pts[i];
            if (i == 0) {
                queryBuilder.append("(");
            }
            if (i > 0 && i < pts.length) {
                queryBuilder.append("OR ");
            }
            queryBuilder.append("jcr\\:primaryType").append(':').append(SolrQueryIndex.partialEscape(pt)).append(" ");
            if (i != pts.length - 1) continue;
            queryBuilder.append(")");
            queryBuilder.append(' ');
        }
        Filter.PathRestriction pathRestriction = filter.getPathRestriction();
        if (pathRestriction != null) {
            String path = SolrQueryIndex.purgePath(filter);
            String fieldName = this.configuration.getFieldForPathRestriction(pathRestriction);
            if (fieldName != null) {
                queryBuilder.append(fieldName);
                queryBuilder.append(':');
                queryBuilder.append(path);
            }
        }
        if (queryBuilder.length() == 0) {
            queryBuilder.append("*:*");
        }
        String escapedQuery = queryBuilder.toString();
        solrQuery.setQuery(escapedQuery);
        if (this.log.isDebugEnabled()) {
            this.log.debug("JCR query {} has been converted to Solr query {}", (Object)filter.getQueryStatement(), (Object)solrQuery.toString());
        }
        return solrQuery;
    }

    private String getFullTextQuery(FullTextExpression ft) {
        final StringBuilder fullTextString = new StringBuilder();
        ft.accept(new FullTextVisitor(){

            public boolean visit(FullTextOr or) {
                fullTextString.append('(');
                for (int i = 0; i < or.list.size(); ++i) {
                    if (i > 0 && i < or.list.size()) {
                        fullTextString.append(" OR ");
                    }
                    FullTextExpression e = (FullTextExpression)or.list.get(i);
                    String orTerm = SolrQueryIndex.this.getFullTextQuery(e);
                    fullTextString.append(orTerm);
                }
                fullTextString.append(')');
                fullTextString.append(' ');
                return true;
            }

            public boolean visit(FullTextAnd and) {
                fullTextString.append('(');
                for (int i = 0; i < and.list.size(); ++i) {
                    if (i > 0 && i < and.list.size()) {
                        fullTextString.append(" AND ");
                    }
                    FullTextExpression e = (FullTextExpression)and.list.get(i);
                    String andTerm = SolrQueryIndex.this.getFullTextQuery(e);
                    fullTextString.append(andTerm);
                }
                fullTextString.append(')');
                fullTextString.append(' ');
                return true;
            }

            public boolean visit(FullTextTerm term) {
                String boost;
                String p;
                if (term.isNot()) {
                    fullTextString.append('-');
                }
                if ((p = term.getPropertyName()) != null && p.indexOf(47) >= 0) {
                    p = PathUtils.getName((String)p);
                }
                if (p == null) {
                    p = SolrQueryIndex.this.configuration.getCatchAllField();
                }
                fullTextString.append(SolrQueryIndex.partialEscape(p));
                fullTextString.append(':');
                String termText = term.getText();
                if (termText.indexOf(32) > 0) {
                    fullTextString.append('\"');
                }
                fullTextString.append(termText.replace("/", "\\/").replace(":", "\\:"));
                if (termText.indexOf(32) > 0) {
                    fullTextString.append('\"');
                }
                if ((boost = term.getBoost()) != null) {
                    fullTextString.append('^');
                    fullTextString.append(boost);
                }
                fullTextString.append(' ');
                return true;
            }
        });
        return fullTextString.toString();
    }

    private boolean isSupportedHttpRequest(String nativeQueryString) {
        return nativeQueryString.matches("(mlt|query|select|get)\\\\?.*");
    }

    private void setDefaults(SolrQuery solrQuery) {
        solrQuery.setParam("q.op", "AND");
        solrQuery.setParam("fl", "* score");
        String catchAllField = this.configuration.getCatchAllField();
        if (catchAllField != null && catchAllField.length() > 0) {
            solrQuery.setParam("df", catchAllField);
        }
        solrQuery.setParam("rows", "100000");
    }

    private static String createRangeQuery(String first, String last, boolean firstIncluding, boolean lastIncluding) {
        return "[" + (first != null ? first : "*") + " TO " + (last != null ? last : "*") + "]";
    }

    private static String purgePath(Filter filter) {
        return SolrQueryIndex.partialEscape(filter.getPath()).toString();
    }

    private static CharSequence partialEscape(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '/' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '-' || c == ' ') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb;
    }

    public Cursor query(Filter filter, NodeState root) {
        SolrCursor cursor;
        if (this.log.isDebugEnabled()) {
            this.log.debug("converting filter {}", (Object)filter);
        }
        try {
            SolrQuery query = this.getQuery(filter);
            if (this.log.isDebugEnabled()) {
                this.log.debug("sending query {}", (Object)query);
            }
            QueryResponse queryResponse = this.solrServer.query(query);
            if (this.log.isDebugEnabled()) {
                this.log.debug("getting response {}", (Object)queryResponse);
            }
            cursor = new SolrCursor(queryResponse);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cursor;
    }

    @CheckForNull
    public NodeAggregator getNodeAggregator() {
        return this.aggregator;
    }

    private class SolrCursor
    implements Cursor {
        private final SolrDocumentList results;
        private int i;

        public SolrCursor(QueryResponse queryResponse) {
            this.results = queryResponse.getResults();
            this.i = 0;
        }

        public boolean hasNext() {
            return this.results != null && this.i < this.results.size();
        }

        public void remove() {
            this.results.remove(this.i);
        }

        public IndexRow next() {
            if (this.i < this.results.size()) {
                final SolrDocument doc = (SolrDocument)this.results.get(this.i);
                ++this.i;
                return new IndexRow(){

                    public String getPath() {
                        return String.valueOf(doc.getFieldValue(SolrQueryIndex.this.configuration.getPathField()));
                    }

                    public PropertyValue getValue(String columnName) {
                        if ("jcr:score".equals(columnName)) {
                            float score = 0.0f;
                            Object scoreObj = doc.get("score");
                            if (scoreObj != null) {
                                score = ((Float)scoreObj).floatValue();
                            }
                            return PropertyValues.newDouble((Double)Double.valueOf(score));
                        }
                        Object o = doc.getFieldValue(columnName);
                        return o == null ? null : PropertyValues.newString((String)o.toString());
                    }
                };
            }
            return null;
        }
    }
}

