/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function.distance;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.FloatDocValues;
import org.apache.lucene.search.spell.StringDistance;

public class StringDistanceFunction
extends ValueSource {
    protected ValueSource str1;
    protected ValueSource str2;
    protected StringDistance dist;

    public StringDistanceFunction(ValueSource str1, ValueSource str2, StringDistance measure) {
        this.str1 = str1;
        this.str2 = str2;
        this.dist = measure;
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final FunctionValues str1DV = this.str1.getValues(context, readerContext);
        final FunctionValues str2DV = this.str2.getValues(context, readerContext);
        return new FloatDocValues(this){

            @Override
            public float floatVal(int doc) {
                return StringDistanceFunction.this.dist.getDistance(str1DV.strVal(doc), str2DV.strVal(doc));
            }

            @Override
            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append("strdist").append('(');
                sb.append(str1DV.toString(doc)).append(',').append(str2DV.toString(doc)).append(", dist=").append(StringDistanceFunction.this.dist.getClass().getName());
                sb.append(')');
                return sb.toString();
            }
        };
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append("strdist").append('(');
        sb.append(this.str1).append(',').append(this.str2).append(", dist=").append(this.dist.getClass().getName());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringDistanceFunction)) {
            return false;
        }
        StringDistanceFunction that = (StringDistanceFunction)o;
        if (!this.dist.equals(that.dist)) {
            return false;
        }
        if (!this.str1.equals(that.str1)) {
            return false;
        }
        return this.str2.equals(that.str2);
    }

    @Override
    public int hashCode() {
        int result = this.str1.hashCode();
        result = 31 * result + this.str2.hashCode();
        result = 31 * result + this.dist.hashCode();
        return result;
    }
}

