/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.RateLimitedDirectoryWrapper;
import org.apache.solr.core.CachingDirectoryFactory;
import org.apache.solr.core.DirectoryFactory;

public class StandardDirectoryFactory
extends CachingDirectoryFactory {
    @Override
    protected Directory create(String path, DirectoryFactory.DirContext dirContext) throws IOException {
        return FSDirectory.open(new File(path));
    }

    @Override
    public String normalize(String path) throws IOException {
        String cpath = new File(path).getCanonicalPath();
        return super.normalize(cpath);
    }

    @Override
    public boolean exists(String path) throws IOException {
        File dirFile = new File(path);
        return dirFile.canRead() && dirFile.list().length > 0;
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    @Override
    protected void removeDirectory(CachingDirectoryFactory.CacheValue cacheValue) throws IOException {
        File dirFile = new File(cacheValue.path);
        FileUtils.deleteDirectory((File)dirFile);
    }

    @Override
    public void move(Directory fromDir, Directory toDir, String fileName, IOContext ioContext) throws IOException {
        File dir2;
        File indexFileInIndex;
        File dir1;
        File indexFileInTmpDir;
        boolean success;
        Directory baseFromDir = this.getBaseDir(fromDir);
        Directory baseToDir = this.getBaseDir(toDir);
        if (baseFromDir instanceof FSDirectory && baseToDir instanceof FSDirectory && (success = (indexFileInTmpDir = new File(dir1 = ((FSDirectory)baseFromDir).getDirectory(), fileName)).renameTo(indexFileInIndex = new File(dir2 = ((FSDirectory)baseToDir).getDirectory(), fileName)))) {
            return;
        }
        super.move(fromDir, toDir, fileName, ioContext);
    }

    private Directory getBaseDir(Directory dir) {
        Directory baseDir = dir instanceof NRTCachingDirectory ? ((NRTCachingDirectory)dir).getDelegate() : (dir instanceof RateLimitedDirectoryWrapper ? ((RateLimitedDirectoryWrapper)dir).getDelegate() : dir);
        return baseDir;
    }
}

