/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.index;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.index.SolrIndexEditor;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.solr.client.solrj.SolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexEditorProvider
implements IndexEditorProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SolrServerProvider solrServerProvider;
    private final OakSolrConfigurationProvider oakSolrConfigurationProvider;

    public SolrIndexEditorProvider(SolrServerProvider solrServerProvider, OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        this.solrServerProvider = solrServerProvider;
        this.oakSolrConfigurationProvider = oakSolrConfigurationProvider;
    }

    public Editor getIndexEditor(@Nonnull String type, @Nonnull NodeBuilder definition, @Nonnull NodeState root, @Nonnull IndexUpdateCallback callback) throws CommitFailedException {
        block5: {
            if ("solr".equals(type) && this.isConfigurationOk()) {
                try {
                    SolrServer solrServer = this.solrServerProvider.getSolrServer();
                    if (solrServer != null) {
                        return new SolrIndexEditor(definition, solrServer, this.oakSolrConfigurationProvider.getConfiguration(), callback);
                    }
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("null SolrServer provided, cannot index {}", (Object)definition);
                    }
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error("unable to create SolrIndexEditor", (Throwable)e);
                }
            }
        }
        return null;
    }

    private boolean isConfigurationOk() {
        return this.solrServerProvider != null && this.oakSolrConfigurationProvider != null;
    }
}

