/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStreamToAutomaton;
import org.apache.lucene.search.suggest.analyzing.AnalyzingSuggester;
import org.apache.lucene.search.suggest.analyzing.FSTUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.BasicAutomata;
import org.apache.lucene.util.automaton.BasicOperations;
import org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.apache.lucene.util.automaton.SpecialOperations;
import org.apache.lucene.util.automaton.UTF32ToUTF8;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PairOutputs;

public final class FuzzySuggester
extends AnalyzingSuggester {
    private final int maxEdits;
    private final boolean transpositions;
    private final int nonFuzzyPrefix;
    private final int minFuzzyLength;
    private final boolean unicodeAware;
    public static final boolean DEFAULT_UNICODE_AWARE = false;
    public static final int DEFAULT_MIN_FUZZY_LENGTH = 3;
    public static final int DEFAULT_NON_FUZZY_PREFIX = 1;
    public static final int DEFAULT_MAX_EDITS = 1;
    public static final boolean DEFAULT_TRANSPOSITIONS = true;

    public FuzzySuggester(Analyzer analyzer) {
        this(analyzer, analyzer);
    }

    public FuzzySuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer) {
        this(indexAnalyzer, queryAnalyzer, 3, 256, -1, true, 1, true, 1, 3, false);
    }

    public FuzzySuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, int options, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean preservePositionIncrements, int maxEdits, boolean transpositions, int nonFuzzyPrefix, int minFuzzyLength, boolean unicodeAware) {
        super(indexAnalyzer, queryAnalyzer, options, maxSurfaceFormsPerAnalyzedForm, maxGraphExpansions, preservePositionIncrements);
        if (maxEdits < 0 || maxEdits > 2) {
            throw new IllegalArgumentException("maxEdits must be between 0 and 2");
        }
        if (nonFuzzyPrefix < 0) {
            throw new IllegalArgumentException("nonFuzzyPrefix must not be >= 0 (got " + nonFuzzyPrefix + ")");
        }
        if (minFuzzyLength < 0) {
            throw new IllegalArgumentException("minFuzzyLength must not be >= 0 (got " + minFuzzyLength + ")");
        }
        this.maxEdits = maxEdits;
        this.transpositions = transpositions;
        this.nonFuzzyPrefix = nonFuzzyPrefix;
        this.minFuzzyLength = minFuzzyLength;
        this.unicodeAware = unicodeAware;
    }

    @Override
    protected List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> getFullPrefixPaths(List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths, Automaton lookupAutomaton, FST<PairOutputs.Pair<Long, BytesRef>> fst) throws IOException {
        Automaton levA = this.convertAutomaton(this.toLevenshteinAutomata(lookupAutomaton));
        return FSTUtil.intersectPrefixPaths(levA, fst);
    }

    @Override
    protected Automaton convertAutomaton(Automaton a) {
        if (this.unicodeAware) {
            Automaton utf8automaton = new UTF32ToUTF8().convert(a);
            BasicOperations.determinize(utf8automaton);
            return utf8automaton;
        }
        return a;
    }

    @Override
    TokenStreamToAutomaton getTokenStreamToAutomaton() {
        TokenStreamToAutomaton tsta = super.getTokenStreamToAutomaton();
        tsta.setUnicodeArcs(this.unicodeAware);
        return tsta;
    }

    Automaton toLevenshteinAutomata(Automaton automaton) {
        Set<IntsRef> ref = SpecialOperations.getFiniteStrings(automaton, -1);
        Automaton[] subs = new Automaton[ref.size()];
        int upto = 0;
        for (IntsRef path : ref) {
            if (path.length <= this.nonFuzzyPrefix || path.length < this.minFuzzyLength) {
                subs[upto] = BasicAutomata.makeString(path.ints, path.offset, path.length);
                ++upto;
                continue;
            }
            Automaton prefix = BasicAutomata.makeString(path.ints, path.offset, this.nonFuzzyPrefix);
            int[] ints = new int[path.length - this.nonFuzzyPrefix];
            System.arraycopy(path.ints, path.offset + this.nonFuzzyPrefix, ints, 0, ints.length);
            LevenshteinAutomata lev = new LevenshteinAutomata(ints, this.unicodeAware ? 0x10FFFF : 255, this.transpositions);
            Automaton levAutomaton = lev.toAutomaton(this.maxEdits);
            Automaton combined = BasicOperations.concatenate(Arrays.asList(prefix, levAutomaton));
            combined.setDeterministic(true);
            subs[upto] = combined;
            ++upto;
        }
        if (subs.length == 0) {
            return BasicAutomata.makeEmpty();
        }
        if (subs.length == 1) {
            return subs[0];
        }
        Automaton a = BasicOperations.union(Arrays.asList(subs));
        BasicOperations.determinize(a);
        return a;
    }
}

