/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.ArrayList;
import java.util.List;

public abstract class RangeFacet<B, G> {
    private final String name;
    private final List<Count> counts = new ArrayList<Count>();
    private final B start;
    private final B end;
    private final G gap;
    private final Number before;
    private final Number after;
    private final Number between;

    protected RangeFacet(String name, B start, B end, G gap, Number before, Number after, Number between) {
        this.name = name;
        this.start = start;
        this.end = end;
        this.gap = gap;
        this.before = before;
        this.after = after;
        this.between = between;
    }

    public void addCount(String value, int count) {
        this.counts.add(new Count(value, count, this));
    }

    public String getName() {
        return this.name;
    }

    public List<Count> getCounts() {
        return this.counts;
    }

    public B getStart() {
        return this.start;
    }

    public B getEnd() {
        return this.end;
    }

    public G getGap() {
        return this.gap;
    }

    public Number getBefore() {
        return this.before;
    }

    public Number getAfter() {
        return this.after;
    }

    public Number getBetween() {
        return this.between;
    }

    public static class Count {
        private final String value;
        private final int count;
        private final RangeFacet rangeFacet;

        public Count(String value, int count, RangeFacet rangeFacet) {
            this.value = value;
            this.count = count;
            this.rangeFacet = rangeFacet;
        }

        public String getValue() {
            return this.value;
        }

        public int getCount() {
            return this.count;
        }

        public RangeFacet getRangeFacet() {
            return this.rangeFacet;
        }
    }

    public static class Date
    extends RangeFacet<java.util.Date, String> {
        @Deprecated
        public Date(String name, java.util.Date start, java.util.Date end, String gap, Number before, Number after) {
            this(name, start, end, gap, before, after, (Number)null);
        }

        public Date(String name, java.util.Date start, java.util.Date end, String gap, Number before, Number after, Number between) {
            super(name, start, end, gap, before, after, between);
        }
    }

    public static class Numeric
    extends RangeFacet<Number, Number> {
        @Deprecated
        public Numeric(String name, Number start, Number end, Number gap, Number before, Number after) {
            this(name, start, end, gap, before, after, (Number)null);
        }

        public Numeric(String name, Number start, Number end, Number gap, Number before, Number after, Number between) {
            super(name, start, end, gap, before, after, between);
        }
    }
}

